/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.File;
import java.io.FileFilter;

public class FileSuffixFilter
implements FileFilter {
    protected final String[] suffixes;
    protected final boolean ignoreCase;

    public FileSuffixFilter(String[] suffixes, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        if (ignoreCase) {
            this.suffixes = new String[suffixes.length];
            int i = 0;
            while (i < suffixes.length) {
                this.suffixes[i] = suffixes[i].toLowerCase();
                ++i;
            }
        } else {
            this.suffixes = suffixes;
        }
    }

    public FileSuffixFilter(String[] suffixes) {
        this(suffixes, false);
    }

    public FileSuffixFilter(String suffix, boolean ignoreCase) {
        this(new String[]{suffix}, ignoreCase);
    }

    public FileSuffixFilter(String suffix) {
        this(suffix, false);
    }

    public boolean accept(File file) {
        boolean success = false;
        int i = 0;
        while (i < this.suffixes.length && !success) {
            success = this.ignoreCase ? file.getName().toLowerCase().endsWith(this.suffixes[i]) : file.getName().endsWith(this.suffixes[i]);
            ++i;
        }
        return success;
    }
}

