/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.util.CachePolicy;

public class TimedCachePolicy
extends TimerTask
implements CachePolicy {
    protected static Timer resolutionTimer = new Timer(true);
    protected Map entryMap;
    protected int defaultLifetime;
    protected boolean threadSafe;
    protected long now;
    protected int resolution;

    public TimedCachePolicy() {
        this(1800, false, 0);
    }

    public TimedCachePolicy(int defaultLifetime) {
        this(defaultLifetime, false, 0);
    }

    public TimedCachePolicy(int defaultLifetime, boolean threadSafe, int resolution) {
        this.defaultLifetime = defaultLifetime;
        this.threadSafe = threadSafe;
        if (resolution <= 0) {
            resolution = 60;
        }
        this.resolution = resolution;
    }

    public void create() {
        this.entryMap = this.threadSafe ? Collections.synchronizedMap(new HashMap()) : new HashMap();
        this.now = System.currentTimeMillis();
    }

    public void start() {
        resolutionTimer.scheduleAtFixedRate((TimerTask)this, 0L, (long)(1000 * this.resolution));
    }

    public void stop() {
        super.cancel();
        this.flush();
    }

    public void destroy() {
        this.entryMap.clear();
    }

    public Object get(Object key) {
        TimedEntry entry = (TimedEntry)this.entryMap.get(key);
        if (entry == null) {
            return null;
        }
        if (!entry.isCurrent(this.now) && !entry.refresh()) {
            entry.destroy();
            this.entryMap.remove(key);
            return null;
        }
        Object value = entry.getValue();
        return value;
    }

    public Object peek(Object key) {
        TimedEntry entry = (TimedEntry)this.entryMap.get(key);
        Object value = null;
        if (entry != null) {
            value = entry.getValue();
        }
        return value;
    }

    public void insert(Object key, Object value) {
        if (this.entryMap.containsKey(key)) {
            throw new IllegalStateException("Attempt to insert duplicate entry");
        }
        TimedEntry entry = null;
        entry = !(value instanceof TimedEntry) ? new DefaultTimedEntry(this.defaultLifetime, value) : (TimedEntry)value;
        entry.init(this.now);
        this.entryMap.put(key, entry);
    }

    public void remove(Object key) {
        TimedEntry entry = (TimedEntry)this.entryMap.remove(key);
        if (entry != null) {
            entry.destroy();
        }
    }

    public void flush() {
        Map tmpMap = this.entryMap;
        this.entryMap = this.threadSafe ? Collections.synchronizedMap(new HashMap()) : new HashMap();
        Iterator iter = tmpMap.values().iterator();
        while (iter.hasNext()) {
            TimedEntry entry = (TimedEntry)iter.next();
            entry.destroy();
        }
        tmpMap.clear();
    }

    public int size() {
        return this.entryMap.size();
    }

    public int getDefaultLifetime() {
        return this.defaultLifetime;
    }

    public void setDefaultLifetime(int defaultLifetime) {
        this.defaultLifetime = defaultLifetime;
    }

    public void run() {
        this.now = System.currentTimeMillis();
    }

    public long currentTimeMillis() {
        return this.now;
    }

    public TimedEntry peekEntry(Object key) {
        TimedEntry entry = (TimedEntry)this.entryMap.get(key);
        return entry;
    }

    static class DefaultTimedEntry
    implements TimedEntry {
        long expirationTime;
        Object value;

        DefaultTimedEntry(long lifetime, Object value) {
            this.expirationTime = 1000L * lifetime;
            this.value = value;
        }

        public void init(long now) {
            this.expirationTime += now;
        }

        public boolean isCurrent(long now) {
            return this.expirationTime > now;
        }

        public boolean refresh() {
            return false;
        }

        public void destroy() {
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static interface TimedEntry {
        public void init(long var1);

        public boolean isCurrent(long var1);

        public boolean refresh();

        public void destroy();

        public Object getValue();
    }
}

