/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jboss.util.EmptyStringException;
import org.jboss.util.NullArgumentException;
import org.jboss.util.platform.Constants;

public final class Strings {
    public static final String EMPTY = "";
    public static final String NEWLINE = Constants.LINE_SEPARATOR;

    public static String subst(StringBuffer buff, String from, String to, String string) {
        int begin = 0;
        int end = 0;
        while ((end = string.indexOf(from, end)) != -1) {
            buff.append(string.substring(begin, end));
            buff.append(to);
            end = begin = end + from.length();
        }
        buff.append(string.substring(begin, string.length()));
        return buff.toString();
    }

    public static String subst(String from, String to, String string) {
        return Strings.subst(new StringBuffer(), from, to, string);
    }

    /*
     * WARNING - void declaration
     */
    public static String subst(StringBuffer buff, String string, Map map, String beginToken, String endToken) {
        Range range;
        int begin = 0;
        int rangeEnd = 0;
        while ((range = Strings.rangeOf(beginToken, endToken, string, rangeEnd)) != null) {
            void var7_7;
            buff.append(string.substring(begin, var7_7.begin));
            String key = string.substring(var7_7.begin + beginToken.length(), var7_7.end);
            Object value = map.get(key);
            if (value == null) {
                value = EMPTY;
            }
            buff.append(value);
            rangeEnd = begin = var7_7.end + endToken.length();
        }
        buff.append(string.substring(begin, string.length()));
        return buff.toString();
    }

    public static String subst(String string, Map map, String beginToken, String endToken) {
        return Strings.subst(new StringBuffer(), string, map, beginToken, endToken);
    }

    public static String subst(StringBuffer buff, String string, String[] replace, char token) {
        int i = string.length();
        int j = 0;
        while (j >= 0 && j < i) {
            char c = string.charAt(j);
            if (c == token) {
                if (j != i) {
                    int k = Character.digit(string.charAt(j + 1), 10);
                    if (k == -1) {
                        buff.append(string.charAt(j + 1));
                    } else if (k < replace.length) {
                        buff.append(replace[k]);
                    }
                    ++j;
                }
            } else {
                buff.append(c);
            }
            ++j;
        }
        return buff.toString();
    }

    public static String subst(String string, String[] replace, char token) {
        return Strings.subst(new StringBuffer(), string, replace, token);
    }

    public static String subst(String string, String[] replace) {
        return Strings.subst(new StringBuffer(), string, replace, '%');
    }

    public static Range rangeOf(String beginToken, String endToken, String string, int fromIndex) {
        int end;
        int begin = string.indexOf(beginToken, fromIndex);
        if (begin != -1 && (end = string.indexOf(endToken, begin + 1)) != -1) {
            return new Range(begin, end);
        }
        return null;
    }

    public static Range rangeOf(String beginToken, String endToken, String string) {
        return Strings.rangeOf(beginToken, endToken, string, 0);
    }

    public static String[] split(String string, String delim, int limit) {
        int count = Strings.count(string, delim) + 1;
        if (limit > 0 && count > limit) {
            count = limit;
        }
        String[] strings = new String[count];
        int begin = 0;
        int i = 0;
        while (i < count) {
            int end = string.indexOf(delim, begin);
            if (end == -1 || i + 1 == count) {
                end = string.length();
            }
            strings[i] = end == 0 ? EMPTY : string.substring(begin, end);
            begin = end + 1;
            ++i;
        }
        return strings;
    }

    public static String[] split(String string, String delim) {
        return Strings.split(string, delim, -1);
    }

    public static String join(StringBuffer buff, Object[] array, String delim) {
        boolean haveDelim = delim != null;
        int i = 0;
        while (i < array.length) {
            buff.append(array[i]);
            if (haveDelim && i + 1 < array.length) {
                buff.append(delim);
            }
            ++i;
        }
        return buff.toString();
    }

    public static String join(Object[] array, String delim) {
        return Strings.join(new StringBuffer(), array, delim);
    }

    public static String join(Object[] array) {
        return Strings.join(array, null);
    }

    public static String join(byte[] array) {
        Object[] bytes = new Byte[array.length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = new Byte(array[i]);
            ++i;
        }
        return Strings.join(bytes, null);
    }

    public static String join(StringBuffer buff, Object[] array, String prefix, String separator, String suffix) {
        buff.append(prefix);
        Strings.join(buff, array, separator);
        buff.append(suffix);
        return buff.toString();
    }

    public static String join(Object[] array, String prefix, String separator, String suffix) {
        return Strings.join(new StringBuffer(), array, prefix, separator, suffix);
    }

    public static int count(String string, String substring) {
        int count = 0;
        int idx = 0;
        while ((idx = string.indexOf(substring, idx)) != -1) {
            ++idx;
            ++count;
        }
        return count;
    }

    public static int count(String string, char c) {
        return Strings.count(string, String.valueOf(c));
    }

    public static String pad(StringBuffer buff, String string, int count) {
        int i = 0;
        while (i < count) {
            buff.append(string);
            ++i;
        }
        return buff.toString();
    }

    public static String pad(String string, int count) {
        return Strings.pad(new StringBuffer(), string, count);
    }

    public static String pad(Object obj, int count) {
        return Strings.pad(new StringBuffer(), String.valueOf(obj), count);
    }

    public static boolean compare(String me, String you) {
        if (me == you) {
            return true;
        }
        if (me == null && you != null) {
            return false;
        }
        return me.equals(you);
    }

    public static boolean isEmpty(String string) {
        return string.equals(EMPTY);
    }

    public static int nthIndexOf(String string, String token, int index) {
        int j = 0;
        int i = 0;
        while (i < index) {
            if ((j = string.indexOf(token, j + 1)) == -1) break;
            ++i;
        }
        return j;
    }

    public static String capitalize(String string) {
        if (string == null) {
            throw new NullArgumentException("string");
        }
        if (string.equals(EMPTY)) {
            throw new EmptyStringException("string");
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String[] trim(String[] strings) {
        int i = 0;
        while (i < strings.length) {
            strings[i] = strings[i].trim();
            ++i;
        }
        return strings;
    }

    public static URL toURL(String urlspec, String relativePrefix) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                url = Strings.makeURLFromFilespec(url.getFile(), relativePrefix);
            }
        }
        catch (Exception e) {
            try {
                url = Strings.makeURLFromFilespec(urlspec, relativePrefix);
            }
            catch (IOException n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private static URL makeURLFromFilespec(String filespec, String relativePrefix) throws IOException {
        File file = new File(filespec);
        if (relativePrefix != null && !file.isAbsolute()) {
            file = new File(relativePrefix, filespec);
        }
        file = file.getCanonicalFile();
        return file.toURL();
    }

    public static URL toURL(String urlspec) throws MalformedURLException {
        return Strings.toURL(urlspec, null);
    }

    public static class Range {
        public int begin;
        public int end;

        public Range(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public Range() {
        }
    }
}

