/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol;

import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;

public class URLStreamHandlerFactory
implements java.net.URLStreamHandlerFactory {
    private static final Logger log = Logger.getLogger(class$org$jboss$net$protocol$URLStreamHandlerFactory == null ? (class$org$jboss$net$protocol$URLStreamHandlerFactory = URLStreamHandlerFactory.class$("org.jboss.net.protocol.URLStreamHandlerFactory")) : class$org$jboss$net$protocol$URLStreamHandlerFactory);
    public static final String PACKAGE_PREFIX = "org.jboss.net.protocol";
    private static Map handlerMap = Collections.synchronizedMap(new HashMap());
    private String[] handlerPkgs = new String[]{"org.jboss.net.protocol"};
    private String lastHandlerPkgs = "org.jboss.net.protocol";
    public static final String[] PROTOCOLS = new String[]{"resource", "file", "njar"};
    static /* synthetic */ Class class$org$jboss$net$protocol$URLStreamHandlerFactory;

    public static void preload() {
        int i = 0;
        while (i < PROTOCOLS.length) {
            try {
                URL url = new URL(PROTOCOLS[i], "", -1, "");
                log.trace("Loaded protocol: " + PROTOCOLS[i]);
            }
            catch (Exception e) {
                log.warn("Failed to load protocol: " + PROTOCOLS[i], e);
            }
            ++i;
        }
    }

    public static void clear() {
        handlerMap.clear();
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = (URLStreamHandler)handlerMap.get(protocol);
        if (handler != null) {
            return handler;
        }
        this.checkHandlerPkgs();
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        int p = 0;
        while (p < this.handlerPkgs.length) {
            try {
                String classname = this.handlerPkgs[p] + "." + protocol + ".Handler";
                Class<?> type = null;
                try {
                    type = ctxLoader.loadClass(classname);
                }
                catch (ClassNotFoundException e) {
                    type = Class.forName(classname);
                }
                if (type != null) {
                    handler = (URLStreamHandler)type.newInstance();
                    handlerMap.put(protocol, handler);
                    log.trace("Found protocol:" + protocol + " handler:" + handler);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            ++p;
        }
        return handler;
    }

    private synchronized void checkHandlerPkgs() {
        String handlerPkgsProp = System.getProperty("java.protocol.handler.pkgs");
        if (handlerPkgsProp != null && !handlerPkgsProp.equals(this.lastHandlerPkgs)) {
            StringTokenizer tokeninzer = new StringTokenizer(handlerPkgsProp, "|");
            ArrayList<String> tmp = new ArrayList<String>();
            while (tokeninzer.hasMoreTokens()) {
                String pkg = tokeninzer.nextToken().intern();
                if (tmp.contains(pkg)) continue;
                tmp.add(pkg);
            }
            if (!tmp.contains(PACKAGE_PREFIX)) {
                tmp.add(PACKAGE_PREFIX);
            }
            this.handlerPkgs = new String[tmp.size()];
            tmp.toArray(this.handlerPkgs);
            this.lastHandlerPkgs = handlerPkgsProp;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

