/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp.jaas;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.rmi.Naming;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.srp.SRPClientSession;
import org.jboss.security.srp.SRPParameters;
import org.jboss.security.srp.SRPServerInterface;

public class SRPLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler handler;
    private Map sharedState;
    private String principalClassName;
    private String srpServerRmiUrl;
    private String srpServerJndiName;
    private String username;
    private char[] password;
    private SRPServerInterface srpServer;
    private SRPParameters params;
    private Principal userPrincipal;
    private byte[] sessionKey;
    private boolean loginFailed;
    private Logger log;
    static /* synthetic */ Class class$java$lang$String;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = handler;
        this.sharedState = sharedState;
        this.principalClassName = (String)options.get("principalClassName");
        if (this.principalClassName == null) {
            this.principalClassName = "org.jboss.security.SimplePrincipal";
        }
        this.srpServerJndiName = (String)options.get("srpServerJndiName");
        this.srpServerRmiUrl = (String)options.get("srpServerRmiUrl");
        this.log = Logger.getLogger(this.getClass());
    }

    public boolean login() throws LoginException {
        byte[] M2;
        byte[] M1;
        boolean trace = this.log.isTraceEnabled();
        this.loginFailed = true;
        this.getUserInfo();
        if (this.srpServerJndiName != null) {
            this.srpServer = this.loadServerFromJndi(this.srpServerJndiName);
        } else if (this.srpServerRmiUrl != null) {
            this.srpServer = this.loadServer(this.srpServerRmiUrl);
        } else {
            throw new LoginException("No option specified to access a SRPServerInterface instance");
        }
        if (this.srpServer == null) {
            throw new LoginException("Failed to access a SRPServerInterface instance");
        }
        SRPClientSession client = null;
        try {
            if (trace) {
                this.log.trace((Object)("Getting SRP parameters for username: " + this.username));
            }
            Util.init();
            this.params = this.srpServer.getSRPParameters(this.username);
            if (trace) {
                this.log.trace((Object)("N: " + Util.tob64(this.params.N)));
                this.log.trace((Object)("g: " + Util.tob64(this.params.g)));
                this.log.trace((Object)("s: " + Util.tob64(this.params.s)));
            }
            byte[] hn = Util.newDigest().digest(this.params.N);
            if (trace) {
                this.log.trace((Object)("H(N): " + Util.tob64(hn)));
            }
            byte[] hg = Util.newDigest().digest(this.params.g);
            if (trace) {
                this.log.trace((Object)("H(g): " + Util.tob64(hg)));
                this.log.trace((Object)"Creating SRPClientSession");
            }
            client = new SRPClientSession(this.username, this.password, this.params);
            if (trace) {
                this.log.trace((Object)"Generating client public key");
            }
            byte[] A = client.exponential();
            if (trace) {
                this.log.trace((Object)"Exchanging public keys");
            }
            byte[] B = this.srpServer.init(this.username, A);
            if (trace) {
                this.log.trace((Object)"Generating server challenge");
            }
            M1 = client.response(B);
            if (trace) {
                this.log.trace((Object)"Exchanging challenges");
            }
            M2 = this.srpServer.verify(this.username, M1);
            this.sessionKey = client.getSessionKey();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to complete SRP login", (Throwable)e);
            throw new LoginException("Failed to complete SRP login, msg=" + e.getMessage());
        }
        if (trace) {
            this.log.trace((Object)"Verifying server response");
        }
        if (!client.verify(M2)) {
            throw new LoginException("Failed to validate server reply");
        }
        if (trace) {
            this.log.trace((Object)"Login succeeded");
        }
        this.sharedState.put("javax.security.auth.login.name", this.username);
        this.sharedState.put("javax.security.auth.login.password", M1);
        this.loginFailed = false;
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.loginFailed) {
            return false;
        }
        if (this.principalClassName == null) {
            throw new LoginException("No principalClassName specified");
        }
        this.userPrincipal = null;
        try {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = loader.loadClass(this.principalClassName);
                Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SRPLoginModule.class$("java.lang.String")) : class$java$lang$String};
                Constructor<?> ctor = clazz.getConstructor(parameterTypes);
                Object[] args = new String[]{this.username};
                this.userPrincipal = (Principal)ctor.newInstance(args);
            }
            catch (Exception e) {
                throw new LoginException("Failed to create Principal, " + e.getMessage());
            }
            Object var7_7 = null;
            this.password = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.password = null;
            throw throwable;
        }
        this.subject.getPrincipals().add(this.userPrincipal);
        Set<Object> privateCredentials = this.subject.getPrivateCredentials();
        privateCredentials.add(this.sessionKey);
        if (this.params.cipherAlgorithm != null) {
            Object secretKey = this.createSecretKey(this.params.cipherAlgorithm);
            privateCredentials.add(secretKey);
        }
        privateCredentials.add(this.params);
        return true;
    }

    public boolean abort() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }

    public boolean logout() throws LoginException {
        try {
            if (!this.subject.isReadOnly()) {
                Set<?> s = this.subject.getPrincipals(this.userPrincipal.getClass());
                s.remove(this.userPrincipal);
                this.subject.getPrivateCredentials().remove(this.sessionKey);
            }
            if (this.srpServer != null) {
                this.srpServer.close(this.username);
            }
        }
        catch (Exception e) {
            throw new LoginException("Failed to remove user principal, " + e.getMessage());
        }
        return true;
    }

    private void getUserInfo() throws LoginException {
        String _username = (String)this.sharedState.get("javax.security.auth.login.name");
        char[] _password = null;
        if (this.username != null) {
            Object pw = this.sharedState.get("javax.security.auth.login.password");
            if (pw instanceof char[]) {
                _password = (char[])pw;
            } else if (pw != null) {
                _password = pw.toString().toCharArray();
            }
        }
        if (_username != null && _password != null) {
            this.username = _username;
            this.password = _password;
            return;
        }
        if (this.handler == null) {
            throw new LoginException("No CallbackHandler provied to SRPLoginModule");
        }
        NameCallback nc = new NameCallback("Username: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            this.handler.handle(callbacks);
            this.username = nc.getName();
            _password = pc.getPassword();
            if (_password != null) {
                this.password = _password;
            }
            pc.clearPassword();
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("UnsupportedCallback: " + uce.getCallback().toString());
        }
    }

    private SRPServerInterface loadServerFromJndi(String jndiName) {
        SRPServerInterface server = null;
        try {
            InitialContext ctx = new InitialContext();
            server = (SRPServerInterface)ctx.lookup(jndiName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return server;
    }

    private SRPServerInterface loadServer(String rmiUrl) {
        SRPServerInterface server = null;
        try {
            server = (SRPServerInterface)((Object)Naming.lookup(rmiUrl));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return server;
    }

    private Object createSecretKey(String cipherAlgorithm) throws LoginException {
        Class[] signature = new Class[]{this.sessionKey.getClass(), class$java$lang$String == null ? (class$java$lang$String = SRPLoginModule.class$("java.lang.String")) : class$java$lang$String};
        Object[] args = new Object[]{this.sessionKey, cipherAlgorithm};
        Object secretKey = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> secretKeySpecClass = loader.loadClass("javax.crypto.spec.SecretKeySpec");
            Constructor<?> ctor = secretKeySpecClass.getDeclaredConstructor(signature);
            secretKey = ctor.newInstance(args);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to create SecretKeySpec from session key", (Throwable)e);
            throw new LoginException("Failed to create SecretKeySpec from session key");
        }
        return secretKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

