package miningmart.storedProcedures;
/*
 * Class Quicksort
 * Author : Stefan Schwedt (schwedt@ls8.cs.uni-dortmund.de)
 *	    University of Dortmund - FB 4 - LS 8
 * Build  : May 14th, 2001
 */

public class Quicksort {

  public Quicksort() {}

  // A special version of the quicksort algorithm :
  // it sorts one array, but executes every operation also on another array
  public static void sort(double[] sortby, double[] data, int left, int right) {
    if (sortby == null || sortby.length < 2) return;

    int i = left, j = right;

    double x = sortby[(left+right)/2];

    do {
      while (sortby[i] < x) i++;
      while (x < sortby[j]) j--;

      if (i <= j) {
	double temp = sortby[i]; sortby[i] = sortby[j]; sortby[j] = temp;
	temp = data[i]; data[i] = data[j]; data[j] = temp;
	i++;
	j--;
      }

    } while (i <= j);

    if (left < j)  sort(sortby, data, left, j);
    if (i < right) sort(sortby, data, i, right);
  }
}
