package miningmart.storedProcedures;

import java.sql.Connection;

/**
 * Interface implemented by Db to be able to pass a JDBC connection to a time
 * operator (e.g. Windowing), in the case that stored procedures are not available
 * and the same classes are run outside the database.
 */
public interface BusinessDbConnectionSource {

	/**
	 * @return a <code>Connection</code> to the business database schema.
	 * @throws an exception, if no <code>Connection</code> could be established.
	 * */	
	public Connection getDatabaseConnectionForData() throws Exception;

}

/*
 * Historie
 * --------
 *
 * $Log: BusinessDbConnectionSource.java,v $
 *
 */