/*
 * Decompiled with CFR 0.152.
 */
package miningmart.storedProcedures;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import miningmart.storedProcedures.DbConnector;

public class Windowing {
    private DbConnector connector;
    private ResultSet rSet;
    private int wndSize;
    private int distance;
    private boolean firstWnd;
    private int sourceCol;
    private int timeCol;
    private String[] results;
    private String[] timeStamps;

    public Windowing(DbConnector connector) throws SQLException {
        this.wndSize = 5;
        this.distance = 1;
        this.sourceCol = 1;
        this.timeCol = 2;
        this.firstWnd = true;
        this.results = new String[this.wndSize];
        this.timeStamps = new String[this.wndSize];
        this.connector = connector;
    }

    public Windowing(int wndSize, int distance, DbConnector connector) throws SQLException {
        this.wndSize = wndSize;
        this.distance = distance;
        this.sourceCol = 1;
        this.timeCol = 2;
        this.firstWnd = true;
        this.results = new String[wndSize];
        this.timeStamps = new String[wndSize];
        this.connector = connector;
    }

    public void setWndSize(int size) {
        this.wndSize = size;
        this.results = new String[this.wndSize];
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public void setSourceCol(int col) {
        this.sourceCol = col;
    }

    public void setPrimaryKeyCol(int timeCol) {
        this.timeCol = timeCol;
    }

    public boolean open(String sql) {
        try {
            Statement stmt = this.connector.getConnection().createStatement();
            this.rSet = stmt.executeQuery(sql);
            return true;
        }
        catch (Exception e) {
            DbConnector.infoOutput("Error while opening " + sql);
            return false;
        }
    }

    public void close() {
        if (this.rSet != null) {
            try {
                this.rSet.close();
            }
            catch (SQLException e) {
                DbConnector.infoOutput("Closing ResultSet in class Windowing failed:\n" + e);
            }
            this.rSet = null;
        }
    }

    private void shiftArray(String[] array, int n) {
        int i = 0;
        while (i < array.length) {
            array[i] = i + n < array.length ? array[i + n] : "0";
            ++i;
        }
    }

    public String[] getNextWnd() {
        if (this.rSet == null) {
            return null;
        }
        try {
            if (this.firstWnd) {
                int i = 0;
                while (i < this.wndSize) {
                    if (this.rSet.next()) {
                        this.results[i] = this.rSet.getString(this.sourceCol);
                        this.timeStamps[i] = this.rSet.getString(this.timeCol);
                        if (this.results[i] == null) {
                            --i;
                        }
                    } else {
                        return null;
                    }
                    ++i;
                }
                this.firstWnd = false;
                return this.results;
            }
            if (this.distance < this.wndSize) {
                this.shiftArray(this.results, this.distance);
                this.shiftArray(this.timeStamps, this.distance);
                int i = this.wndSize - this.distance;
                while (i < this.wndSize) {
                    if (this.rSet.next()) {
                        this.results[i] = this.rSet.getString(this.sourceCol);
                        this.timeStamps[i] = this.rSet.getString(this.timeCol);
                        if (this.results[i] == null) {
                            --i;
                        }
                    } else {
                        return null;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.distance - this.wndSize) {
                    if (!this.rSet.next()) {
                        return null;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.wndSize) {
                    if (this.rSet.next()) {
                        this.results[i] = this.rSet.getString(this.sourceCol);
                        this.timeStamps[i] = this.rSet.getString(this.timeCol);
                        if (this.results[i] == null) {
                            --i;
                        }
                    } else {
                        return null;
                    }
                    ++i;
                }
            }
            return this.results;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public String getTimeFirstEntry() {
        if (this.timeStamps == null || this.timeStamps.length == 0) {
            return null;
        }
        return this.timeStamps[0];
    }

    public String getTimeLastEntry() {
        if (this.timeStamps == null || this.timeStamps.length == 0) {
            return null;
        }
        return this.timeStamps[this.timeStamps.length - 1];
    }
}

