/*
 * Decompiled with CFR 0.152.
 */
package miningmart.storedProcedures;

import miningmart.storedProcedures.TimeValue;

public class TimeValueArray {
    private final long startTime;
    private final double startValue;
    private long endTime;
    private double endValue;
    private int size;
    private double sum;

    public TimeValueArray(TimeValue t) {
        this.startTime = t.getTimeAsLong();
        this.startValue = t.getValue();
        this.endTime = this.startTime;
        this.endValue = this.startValue;
        this.size = 1;
        this.sum = this.startValue;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public long getLatestTime() {
        return this.endTime;
    }

    public double getLatestValue() {
        return this.endValue;
    }

    public int getSize() {
        return this.size;
    }

    public double getSum() {
        return this.sum;
    }

    public void add(TimeValue t) {
        if (t == null) {
            return;
        }
        ++this.size;
        this.endTime = t.getTimeAsLong();
        this.endValue = t.getValue();
        this.sum += this.endValue;
    }

    public double getAverageValue() {
        return this.getSum() / (double)this.getSize();
    }

    public double getIncreaseByTime() {
        double valueDiff = this.getLatestValue() - this.getStartValue();
        long timeDiff = this.getLatestTime() - this.getStartTime();
        if (timeDiff == 0L) {
            return 0.0;
        }
        return valueDiff / (double)timeDiff;
    }

    public double extrapolateValueFor(long time) {
        double increase = this.getIncreaseByTime() * (double)(time - this.getLatestTime());
        return this.getLatestValue() + increase;
    }
}

