/*
 * Decompiled with CFR 0.152.
 */
package miningmart.storedProcedures;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import miningmart.storedProcedures.Attribute;
import miningmart.storedProcedures.DbConnector;

class DataType {
    public static final short UNKNOWN = -1;
    public static final short NUMBER = 0;
    public static final short DATE = 1;
    public static final short CHAR = 2;
    public static final short VARCHAR2 = 3;
    private static final String DT_NAME_UNKNOWN = "UNKNOWN";
    private static final String[] dtNames = new String[]{"NUMBER", "DATE", "CHAR", "VARCHAR2"};

    DataType() {
    }

    public static short getTypeFor(String dtString) {
        if (dtString == null) {
            return -1;
        }
        int ret = -1;
        int i = 0;
        while (i < dtNames.length && ret == -1) {
            if (dtNames[i].equalsIgnoreCase(dtString)) {
                ret = i;
            }
            i = (short)(i + 1);
        }
        return (short)ret;
    }

    public static String getNameFor(short dtConstant) {
        if (dtConstant < 0 || dtConstant >= dtNames.length) {
            return DT_NAME_UNKNOWN;
        }
        return dtNames[dtConstant];
    }

    public static short getColumnDataType(String tableName, String columnName, DbConnector dbc) {
        String query;
        if (tableName == null || columnName == null) {
            DbConnector.infoOutput("Warning: Trying to call DataType.getColumnDataType(" + tableName + ", " + columnName + ") with null values!");
            return -1;
        }
        int lastDotIndex = tableName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            query = "SELECT GET_TYPE('" + tableName.toUpperCase() + "', '" + columnName.toUpperCase() + "') FROM DUAL";
        } else {
            String justTableName = tableName.substring(lastDotIndex + 1);
            String owner = tableName.substring(0, lastDotIndex);
            query = "SELECT GET_TYPE2('" + owner.toUpperCase() + "', '" + justTableName.toUpperCase() + "', '" + columnName.toUpperCase() + "') FROM DUAL";
        }
        String dtString = null;
        try {
            Statement stmt = null;
            ResultSet rset = null;
            DbConnector.infoOutput("DB Query: " + query);
            try {
                stmt = dbc.getConnection().createStatement();
                rset = stmt.executeQuery(query);
                if (rset.next()) {
                    dtString = rset.getString(1);
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (rset != null) {
                    try {
                        rset.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            Object var10_11 = null;
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
        catch (SQLException e) {
            DbConnector.infoOutput(e.getMessage());
        }
        return DataType.getTypeFor(dtString);
    }

    public static void wrongDataType(String table, Attribute column) throws SQLException {
        throw new SQLException("Column '" + column + "' of table '" + table + "' has unsupported relational datatype: '" + column.getDataTypeName() + "'!");
    }
}

