/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.util;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.MiningMartException;
import edu.udo.miningmart.m4.hciImpl.CaseImpl;
import edu.udo.miningmart.m4.hciImpl.M4InterfaceImpl;
import edu.udo.miningmart.m4.utils.M4Xml;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFileChooser;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.CreateCaseDialog;
import miningmart.m4.M4Interface;

public class CaseImporter {
    InputStream inputStream;
    int retVal = 0;
    private boolean withColumns = false;
    private boolean noFile = false;

    public void init() {
        JFileChooser chooser = new JFileChooser(Application.systemHome);
        this.retVal = chooser.showOpenDialog(Application.frame);
        File file = chooser.getSelectedFile();
        if (file == null) {
            this.noFile = true;
            return;
        }
        this.noFile = false;
        String filename = file.getPath();
        try {
            this.inputStream = new BufferedInputStream(new FileInputStream(filename));
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            this.retVal = 2;
        }
    }

    public int importCase() {
        if (this.noFile) {
            return -1;
        }
        System.out.println("Start import");
        try {
            DB db = ((M4InterfaceImpl)M4Interface.getInstance()).getM4db();
            try {
                CaseImpl m4case = (CaseImpl)M4Xml.importCase(this.inputStream, db, "M4-XML V0.5");
                CreateCaseDialog ccd = new CreateCaseDialog(Application.frame, "Set Name for imported Case", true);
                ccd.showCreateDialog(m4case);
                M4Interface.setCurrentCase(m4case);
                boolean openCaseReadOnly = false;
                Application.dispatcher.openImportedCase(m4case, openCaseReadOnly);
            }
            catch (MiningMartException e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (IOException e) {
            System.err.println("\nIOException caught during import:");
            System.err.println(String.valueOf(e.getMessage()) + "\n");
        }
        System.out.println(" ..done");
        return this.retVal;
    }
}

