/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.rowSelection;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.rowSelection.RsbqOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;

public class RsbqOperatorView
extends MMStepView {
    JTextField inputConceptName = new JTextField("", 20);
    JTextField leftCondition = new JTextField("", 20);
    JTextField sqlOperator = new JTextField("", 10);
    JTextField rightCondition = new JTextField("", 20);
    RestrictedTextField outputConceptName = new RestrictedTextField("", 20);
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    JButton changeConditionButton = new JButton("Change");
    private RsbqOperator op;
    private DataChooser chooser;

    public RsbqOperatorView(RsbqOperator op) {
        this.op = op;
        this.initControls();
        this.loopPanel.init(op.stepLoopNr);
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.inputConceptName.setEditable(false);
        this.inputConceptName.setBackground(Color.white);
        this.label = new JLabel("InputConcept");
        this.label.setLabelFor(this.inputConceptName);
        this.insets = new Insets(0, 0, 20, 10);
        this.constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptName, this.constraints);
        this.constraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.changeConceptButton.addActionListener(this);
        this.insets = new Insets(0, 0, 5, 10);
        this.leftCondition.setEditable(false);
        this.leftCondition.setBackground(Color.white);
        this.label = new JLabel("Base Attribute");
        this.label.setLabelFor(this.leftCondition);
        this.constraints = new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.leftCondition, this.constraints);
        this.constraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeConditionButton, this.constraints);
        this.changeConditionButton.addActionListener(this);
        this.label = new JLabel("Sql Operator");
        this.label.setLabelFor(this.sqlOperator);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.sqlOperator, this.constraints);
        this.label = new JLabel("Condition");
        this.label.setLabelFor(this.rightCondition);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.rightCondition, this.constraints);
        this.insets = new Insets(15, 0, 10, 0);
        this.label = new JLabel("Output Concept");
        this.label.setLabelFor(this.outputConceptName);
        this.constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptName, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.changeConditionButton.setEnabled(enable);
        this.outputConceptName.setEditable(enable);
        this.sqlOperator.setEditable(enable);
        this.rightCondition.setEditable(enable);
        if (!enable) {
            this.rightCondition.setBackground(Color.white);
            this.outputConceptName.setBackground(Color.white);
            this.sqlOperator.setBackground(Color.white);
        }
        this.loopPanel.addPropertyChangeListener(this);
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        int loopNr = this.getShownLoopNr();
        if (loopNr > 0) {
            --loopNr;
        }
        if (this.op.theInputConcept != null) {
            this.inputConceptName.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptName.setText("");
        }
        BaseAttribute ba = (BaseAttribute)this.op.theLeftConditions.get(loopNr);
        if (ba != null) {
            this.leftCondition.setText(ba.getName());
        } else {
            this.leftCondition.setText("");
        }
        this.sqlOperator.setText((String)this.op.conditionOperatorStrings.get(loopNr));
        this.rightCondition.setText((String)this.op.rightConditionStrings.get(loopNr));
        this.outputConceptName.setText(this.op.outputConceptName);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            this.loopPanel.init(this.op.stepLoopNr);
            this.updateView();
            return;
        }
        if (e.getSource() == this.closeButton) {
            this.op.setParameter();
            Application.menuWindowClose.doClick();
            return;
        }
        int index = this.getShownLoopNr();
        if (index > 0) {
            --index;
        }
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            if (newConcept != null) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.changeConditionButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "select new Attribute", 3, this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            BaseAttribute newBA = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newBA != null) {
                this.op.theLeftConditions.setElementAt(newBA, index);
            }
        }
        if (!this.sqlOperator.getText().equals("")) {
            this.op.conditionOperatorStrings.setElementAt(this.sqlOperator.getText(), index);
        }
        if (!this.rightCondition.getText().equals("")) {
            this.op.rightConditionStrings.setElementAt(this.rightCondition.getText(), index);
        }
        if (!this.outputConceptName.getText().equals("") && this.outputConceptName.hasValidInput()) {
            this.op.outputConceptName = this.outputConceptName.getText();
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("loop_number")) {
            int newVal = (Integer)evt.getNewValue();
            if (newVal == 0) {
                this.op.resizeVector(1);
            } else {
                this.op.resizeVector(newVal);
            }
            this.op.stepLoopNr = newVal;
            this.loopPanel.init(newVal);
            this.updateView();
        } else if (evt.getPropertyName().equals("loopToShow")) {
            int index = Integer.parseInt((String)evt.getOldValue());
            if (index > 0) {
                --index;
            }
            if (!this.sqlOperator.getText().equals("")) {
                this.op.conditionOperatorStrings.setElementAt(this.sqlOperator.getText(), index);
            }
            if (!this.rightCondition.getText().equals("")) {
                this.op.rightConditionStrings.setElementAt(this.rightCondition.getText(), index);
            }
            if (!this.outputConceptName.getText().equals("") && this.outputConceptName.hasValidInput()) {
                this.op.outputConceptName = this.outputConceptName.getText();
            }
            this.updateView();
        }
    }
}

