/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.missingValue;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.missingValue.AssPredValOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;

public class AssPredValOperatorView
extends MMStepView {
    JTextField inputConceptName = new JTextField("", 20);
    JTextField targetAttributeName = new JTextField("", 20);
    JTextField predictedAttributeField = new JTextField("", 5);
    RestrictedTextField outputAttributeName = new RestrictedTextField("", 20);
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    JButton changeAttributeButton = new JButton("Change");
    JButton changePredAttribButton = new JButton("Change");
    private AssPredValOperator op;
    private DataChooser chooser;

    public AssPredValOperatorView(AssPredValOperator op) {
        this.op = op;
        this.initControls();
        this.loopPanel.init(op.stepLoopNr);
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.inputConceptName.setEditable(false);
        this.inputConceptName.setBackground(Color.white);
        this.label = new JLabel("InputConcept");
        this.label.setLabelFor(this.inputConceptName);
        this.insets = new Insets(0, 0, 10, 5);
        this.constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptName, this.constraints);
        this.constraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.changeConceptButton.addActionListener(this);
        this.targetAttributeName.setEditable(false);
        this.targetAttributeName.setBackground(Color.white);
        this.label = new JLabel("Target Attribute");
        this.label.setLabelFor(this.inputConceptName);
        this.constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.targetAttributeName, this.constraints);
        this.constraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeAttributeButton, this.constraints);
        this.changeAttributeButton.addActionListener(this);
        this.predictedAttributeField.setEditable(false);
        this.predictedAttributeField.setBackground(Color.white);
        this.label = new JLabel("Predicted Attribute");
        this.label.setLabelFor(this.predictedAttributeField);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.predictedAttributeField, this.constraints);
        this.constraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changePredAttribButton, this.constraints);
        this.changePredAttribButton.addActionListener(this);
        this.label = new JLabel("Output Attribute");
        this.label.setLabelFor(this.outputAttributeName);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputAttributeName, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.changeAttributeButton.setEnabled(enable);
        this.changePredAttribButton.setEnabled(enable);
        this.outputAttributeName.setEditable(enable);
        if (!enable) {
            this.outputAttributeName.setBackground(Color.white);
        }
        this.loopPanel.addPropertyChangeListener(this);
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        int loopNr = this.getShownLoopNr();
        if (loopNr > 0) {
            --loopNr;
        }
        if (this.op.theInputConcept != null) {
            this.inputConceptName.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptName.setText("");
        }
        BaseAttribute ba = (BaseAttribute)this.op.theTargetAttributes.get(loopNr);
        if (ba != null) {
            this.targetAttributeName.setText(ba.getName());
        } else {
            this.targetAttributeName.setText("");
        }
        ba = (BaseAttribute)this.op.thePredictedAttributes.get(loopNr);
        if (ba != null) {
            this.predictedAttributeField.setText(ba.getName());
        } else {
            this.predictedAttributeField.setText("");
        }
        this.outputAttributeName.setText((String)this.op.outputAttributeNames.get(loopNr));
    }

    public void actionPerformed(ActionEvent e) {
        BaseAttribute newBA;
        super.actionPerformed(e);
        if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            this.loopPanel.init(this.op.stepLoopNr);
            this.updateView();
            return;
        }
        if (e.getSource() == this.closeButton) {
            this.op.setParameter();
            Application.menuWindowClose.doClick();
            return;
        }
        int index = this.getShownLoopNr();
        if (index > 0) {
            --index;
        }
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            if (newConcept != null) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.changeAttributeButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Concepts selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "select new Attribute", 3, this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            newBA = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newBA != null) {
                this.op.theTargetAttributes.setElementAt(newBA, index);
            }
        }
        if (e.getSource() == this.changePredAttribButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Concepts selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "select new Attribute", 3, this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            newBA = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newBA != null) {
                this.op.thePredictedAttributes.setElementAt(newBA, index);
            }
        }
        if (this.outputAttributeName.hasValidInput()) {
            this.op.outputAttributeNames.setElementAt(this.outputAttributeName.getText(), index);
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("loop_number")) {
            int newVal = (Integer)evt.getNewValue();
            if (newVal == 0) {
                this.op.resizeVector(1);
            } else {
                this.op.resizeVector(newVal);
            }
            this.op.stepLoopNr = newVal;
            this.loopPanel.init(newVal);
            this.updateView();
        } else if (evt.getPropertyName().equals("loopToShow")) {
            int index = Integer.parseInt((String)evt.getOldValue());
            if (index > 0) {
                --index;
            }
            if (!this.outputAttributeName.getText().equals("") && this.outputAttributeName.hasValidInput()) {
                this.op.outputAttributeNames.setElementAt(this.outputAttributeName.getText(), index);
            }
            this.updateView();
        }
    }
}

