/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.genericOperator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import miningmart.hci.gui.util.MmDataList;
import miningmart.hci.operators.genericOperator.OperatorParam;
import miningmart.m4.Constraint;
import miningmart.m4.OperatorParameter;

public class ParameterView
extends JPanel
implements ActionListener {
    OperatorParam param;
    JLabel label = new JLabel();
    JLabel dummyLabel;
    JTextField textField = new JTextField();
    MmDataList list;
    JScrollPane scrollPane;
    JButton changeButton = new JButton("Change");
    JButton addButton = new JButton("Add");
    JButton removeButton = new JButton("Remove");
    Font defFont = new Font(this.getFont().getName(), this.getFont().getStyle(), 11);

    public ParameterView(OperatorParam operatorParameter) {
        this.param = operatorParameter;
        this.init();
        this.updateView();
    }

    public void init() {
        if (this.param.isArrayParameter()) {
            this.setLayout(new GridBagLayout());
            this.label = new JLabel(this.param.getName());
            this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.dummyLabel = new JLabel(" ");
            this.add((Component)this.dummyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.dummyLabel = new JLabel(" ");
            this.add((Component)this.dummyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.dummyLabel = new JLabel(" ");
            this.add((Component)this.dummyLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.dummyLabel = new JLabel(" ");
            this.add((Component)this.dummyLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.list = new MmDataList();
            this.list.setListData(this.param.getAllM4Objects().toArray());
            this.scrollPane = new JScrollPane(this.list);
            this.scrollPane.setPreferredSize(new Dimension(10, 10));
            this.add((Component)this.scrollPane, new GridBagConstraints(1, 0, 2, 4, 0.1, 0.1, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.addButton, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.removeButton, new GridBagConstraints(2, 4, 1, 1, 0.1, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.removeButton.addActionListener(this);
            this.addButton.addActionListener(this);
        } else {
            Iterator it;
            this.setLayout(new FlowLayout(2, 5, 0));
            this.label = new JLabel(this.param.getName());
            this.textField = new JTextField(this.param.getObjectName(), 20);
            this.add(this.label);
            this.add(this.textField);
            boolean exists = false;
            if (this.param.getParameterType() == 2) {
                it = ((AbstractList)this.param.genOperator.getAllParameterConstraint(this.param.getName())).iterator();
                while (it.hasNext() && !exists) {
                    Constraint c = (Constraint)it.next();
                    exists = c.getConstraintType().equals("ONE_OF");
                }
            }
            if (this.param.getIOType().equalsIgnoreCase("in") && (this.param.getParameterType() != 2 || exists)) {
                this.add(this.changeButton);
                this.changeButton.addActionListener(this);
                this.textField.setEditable(false);
                this.textField.setBackground(Color.white);
            } else if (this.param.getIOType().equalsIgnoreCase("OUT") && this.param.getParameterType() == 1) {
                it = ((AbstractList)this.param.genOperator.getAllParameterConstraint(this.param.getName())).iterator();
                Vector<String> inWhat = new Vector<String>();
                Collection opParamCol = null;
                while (it.hasNext()) {
                    Constraint c = (Constraint)it.next();
                    if (!c.getConstraintType().equals("IN") || c.getObject1() == null || c.getObject2() == null) continue;
                    String obj2 = c.getObject2();
                    inWhat.add(obj2);
                    if (opParamCol != null) continue;
                    opParamCol = c.getOperator().getAllOperatorParameters();
                }
                if (inWhat != null && opParamCol != null && !inWhat.isEmpty() && !opParamCol.isEmpty()) {
                    boolean hasInpConcept = false;
                    boolean hasOutConcept = false;
                    it = opParamCol.iterator();
                    while (!(!it.hasNext() || hasInpConcept && hasOutConcept)) {
                        OperatorParameter o = (OperatorParameter)it.next();
                        if (o == null || !o.getParameterType().equalsIgnoreCase("CON") || !inWhat.contains(o.getName())) continue;
                        if (o.getIoType().equalsIgnoreCase("IN")) {
                            hasInpConcept = true;
                            continue;
                        }
                        hasOutConcept = true;
                    }
                    if (hasInpConcept && hasOutConcept) {
                        this.add(this.changeButton);
                        this.changeButton.addActionListener(this);
                        this.textField.setEditable(false);
                        this.textField.setBackground(Color.white);
                    }
                }
            }
        }
        this.label.setFont(this.defFont);
        this.label.setPreferredSize(new Dimension(110, this.label.getPreferredSize().height));
        this.changeButton.setFont(this.defFont);
        this.addButton.setFont(this.defFont);
        this.removeButton.setFont(this.defFont);
    }

    public void updateView() {
        if (this.param.isArrayParameter()) {
            if (this.param.getParameterType() == 2 || this.param.getIOType().equals("OUT")) {
                this.list.setListData(this.param.getAllM4ObjectNames().toArray());
            } else {
                this.list.setListData(this.param.getAllM4Objects().toArray());
            }
        } else {
            this.textField.setText(this.param.getObjectName());
        }
    }

    public String getString() {
        if (!this.param.isArrayParameter()) {
            return this.textField.getText();
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.changeButton) {
            this.param.changeM4Object();
            this.updateView();
            return;
        }
        if (e.getSource() == this.addButton) {
            this.param.addM4ObjectToList();
            this.updateView();
            return;
        }
        if (e.getSource() == this.removeButton) {
            this.param.removeM4ObjectFromList(this.list.getSelectedValues());
            this.updateView();
            return;
        }
    }
}

