/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compilerInterface;

import edu.udo.miningmart.exception.M4CompilerError;

public class CompilerThreadControl {
    public static final short RESOURCE_FREE = 0;
    public static final short GARBAGE_COLLECTION = 1;
    public static final short STEP_COMPILATION = 2;
    private short state = 0;
    private int threadCount = 0;

    public void addThread(short type) throws M4CompilerError {
        while (!this.changeFields(true, type)) {
            Thread.yield();
        }
    }

    public void subThread(short type) throws M4CompilerError {
        while (!this.changeFields(false, type)) {
            Thread.yield();
        }
    }

    private synchronized boolean changeFields(boolean add, short type) throws M4CompilerError {
        if (!this.isValidType(type)) {
            throw new M4CompilerError("CompilerThreadControl: invalid type '" + type + "' !");
        }
        if (add) {
            return this.handleAdd(type);
        }
        return this.handleSub(type);
    }

    private boolean isValidType(short type) {
        return type == 1 || type == 2;
    }

    private boolean handleAdd(short type) {
        if (this.state == 0 || this.state == type && type == 2) {
            this.state = type;
            ++this.threadCount;
            return true;
        }
        return false;
    }

    private boolean handleSub(short type) throws M4CompilerError {
        if (type != this.state || this.threadCount <= 0) {
            String msg = "CompilerThreadControl.subThread(short):\nTrying to free resource, which is not allocated!\n";
            msg = this.threadCount == 0 ? String.valueOf(msg) + "Resource is currently free, but you tried to unregister parameter " + type + " !" : String.valueOf(msg) + "Current state is " + this.state + ", but found parameter " + type + " !";
            throw new M4CompilerError(msg);
        }
        --this.threadCount;
        if (this.threadCount <= 0) {
            this.threadCount = 0;
            this.state = 0;
        }
        return true;
    }
}

