/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compilerInterface;

import edu.udo.miningmart.m4.core.Case;
import edu.udo.miningmart.m4.utils.Print;
import java.io.IOException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compilerInterface.CompilerAccessLogic;
import miningmart.compilerInterface.CompilerAccessRemote;
import miningmart.compilerInterface.M4CompilerInterfaceError;

public class CompilerAccessImpl
extends UnicastRemoteObject
implements CompilerAccessRemote {
    private final String dbConfigFile;
    private final CompilerAccessLogic defaultCAL;
    private final Vector activeCALs = new Vector();

    public CompilerAccessImpl() throws IOException, SQLException {
        this(System.getProperty("DB_CONFIG_PATH"));
    }

    public CompilerAccessImpl(String myDbConfigFile) throws IOException, SQLException {
        this.dbConfigFile = myDbConfigFile;
        this.defaultCAL = new CompilerAccessLogic(myDbConfigFile);
    }

    public void compileStep(long stepID, boolean lazyMode, int verbosity) throws M4CompilerInterfaceError {
        CompilerAccessLogic c = this.getFreshLogic(verbosity);
        c.compileStep(stepID, lazyMode);
        this.releaseCAL(c);
    }

    public void compileStep(long stepID, boolean lazyMode) throws M4CompilerInterfaceError {
        CompilerAccessLogic c = this.getFreshLogic();
        c.compileStep(stepID, lazyMode);
        this.releaseCAL(c);
    }

    public void compileAll(long caseId, boolean lazyMode, int verbosity) throws M4CompilerInterfaceError {
        CompilerAccessLogic c = this.getFreshLogic(verbosity);
        c.compileAll(caseId, lazyMode);
        this.releaseCAL(c);
    }

    public void compileAll(long caseId, boolean lazyMode) throws M4CompilerInterfaceError {
        CompilerAccessLogic c = this.getFreshLogic();
        c.compileAll(caseId, lazyMode);
        this.releaseCAL(c);
    }

    public void compileStepFrom(long stepId, boolean lazyMode, int verbosity) throws M4CompilerInterfaceError {
        CompilerAccessLogic c = this.getFreshLogic(verbosity);
        c.compileStepFrom(stepId, lazyMode);
        this.releaseCAL(c);
    }

    public void compileStepFrom(long stepId, boolean lazyMode) throws M4CompilerInterfaceError {
        CompilerAccessLogic c = this.getFreshLogic();
        c.compileStepFrom(stepId, lazyMode);
        this.releaseCAL(c);
    }

    public void compileStep(String stepName, boolean lazyMode) throws M4CompilerInterfaceError {
        CompilerAccessLogic c = this.getFreshLogic();
        c.compileStep(stepName, lazyMode);
        this.releaseCAL(c);
    }

    public void updateColumnStatistics(long columnID) throws M4CompilerInterfaceError {
        this.defaultCAL.updateColumnStatistics(columnID);
    }

    public void updateColumnsetStatistics(long columnsetID) throws M4CompilerInterfaceError {
        this.defaultCAL.updateColumnsetStatistics(columnsetID);
    }

    public void updateStatisticsForConcept(long conceptID) throws M4CompilerInterfaceError {
        this.defaultCAL.updateStatisticsForConcept(conceptID);
    }

    public void deleteTrashForStep(long stepId) throws M4CompilerInterfaceError {
        CompilerAccessLogic c = this.getFreshLogic();
        c.deleteTrashForStep(stepId);
        this.releaseCAL(c);
    }

    public void deleteTrashForCase(long caseId) throws M4CompilerInterfaceError {
        CompilerAccessLogic c = this.getFreshLogic();
        c.deleteTrashForCase(caseId);
        this.releaseCAL(c);
    }

    public String getStatusMessage(long caseId, int numberOfLines) throws M4CompilerInterfaceError {
        return this.defaultCAL.getStatusMessage(caseId, numberOfLines);
    }

    public String getStatusFromLine(long caseId, int lineNumber) throws M4CompilerInterfaceError {
        return this.defaultCAL.getStatusFromLine(caseId, lineNumber);
    }

    public boolean isReadyForCompilation(long stepId) throws M4CompilerInterfaceError {
        return this.defaultCAL.isReadyForCompilation(stepId);
    }

    public boolean killCompilerThread(long caseId) {
        if (caseId == -1L) {
            this.killCompiler();
            System.exit(0);
            return true;
        }
        Iterator it = ((AbstractList)this.activeCALs).iterator();
        boolean ret = false;
        while (it.hasNext()) {
            CompilerAccessLogic cal = (CompilerAccessLogic)it.next();
            Case ca = cal.getCase();
            if (ca == null || ca.getId() != caseId) continue;
            cal.setStopRequest();
            ret = true;
        }
        return ret;
    }

    private void killCompiler() {
        Iterator it = ((AbstractList)this.activeCALs).iterator();
        while (it.hasNext()) {
            CompilerAccessLogic cal = (CompilerAccessLogic)it.next();
            cal.setStopRequest();
        }
        Print p = this.defaultCAL.getCasePrintObject();
        p.doPrint(20, "Sent kill signal to all compiler threads.");
        while (this.activeCALs.size() > 0) {
            Thread.yield();
        }
        p.doPrint(20, "All threads exited. Stopping default database connection.");
        this.defaultCAL.setStopRequest();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private CompilerAccessLogic getFreshLogic() throws M4CompilerInterfaceError {
        try {
            CompilerAccessLogic c = new CompilerAccessLogic(this.dbConfigFile);
            this.activeCALs.add(c);
            return c;
        }
        catch (Exception e) {
            throw new M4CompilerInterfaceError(e.getClass() + "caught in M4 Compiler Interface." + "\nMessage is:\n" + e.getMessage());
        }
    }

    private CompilerAccessLogic getFreshLogic(int verbosity) throws M4CompilerInterfaceError {
        try {
            CompilerAccessLogic c;
            if (this.dbConfigFile == null) {
                String dbConfig = System.getProperty("DB_CONFIG_PATH");
                c = new CompilerAccessLogic(dbConfig, verbosity);
            } else {
                c = new CompilerAccessLogic(this.dbConfigFile, verbosity);
            }
            this.activeCALs.add(c);
            return c;
        }
        catch (Exception e) {
            throw new M4CompilerInterfaceError(e.getClass() + "caught in M4 Compiler Interface." + "\nMessage is:\n" + e.getMessage());
        }
    }

    private boolean releaseCAL(CompilerAccessLogic cal) {
        return this.activeCALs.remove(cal);
    }
}

