/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.wrapper.dista;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.m4.core.Step;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Properties;
import miningmart.compiler.operator.ExecutableOperator;
import miningmart.compiler.wrapper.dista.DMException;
import miningmart.compiler.wrapper.dista.MetaData;
import miningmart.compilerInterface.SystemPropertyInterface;

public abstract class Wrapper {
    protected MetaData m_md;
    protected CompilerDatabaseService m4db;
    protected Properties m_properties;
    protected String m_result_name;
    protected long m_sample_size;
    protected boolean m_do_clean;
    protected OutputStream m_log;
    protected String m_ml_home;
    protected String m_os_name;
    private final Step step;
    private final ExecutableOperator exOp;

    public Wrapper(Step step, ExecutableOperator exOp) throws Exception {
        this.step = step;
        this.exOp = exOp;
        this.m_sample_size = 100000L;
        this.m_do_clean = false;
        this.m_ml_home = SystemPropertyInterface.getProperty("ML_HOME");
        this.m_properties = new Properties();
        this.m_properties.load(new FileInputStream(String.valueOf(this.m_ml_home) + File.separator + "etc" + File.separator + "wrapper_properties.txt"));
        this.m_result_name = "test";
        this.m_os_name = System.getProperty("os.name");
        if (this.m_os_name.substring(0, 3).equalsIgnoreCase("win")) {
            this.m_os_name = "Windows";
        }
        if (this.m_os_name.substring(0, 5).equalsIgnoreCase("linux")) {
            this.m_os_name = "Linux";
        }
    }

    public CompilerDatabaseService getM4Db() {
        return this.m4db;
    }

    public void setMetaData(MetaData md) throws Exception {
        this.m_md = md;
    }

    public void setConnection(CompilerDatabaseService m4db) {
        this.m4db = m4db;
    }

    public void setProperties(Properties p) {
        this.m_properties = p;
    }

    public void setResultName(String v) {
        this.m_result_name = v;
    }

    public void setSampleSize(long v) {
        this.m_sample_size = v;
    }

    public void run() throws Exception {
        if (this.m_md == null) {
            throw new DMException("Wrapper: MetaData Object is null.");
        }
        if (this.getM4Db() == null) {
            throw new DMException("Wrapper:DB Object is null.");
        }
        this.checkMetaData();
        this.exportTable();
        this.callTool();
        this.importResult();
        this.saveResult();
        if (this.m_do_clean) {
            this.clean();
        }
    }

    protected ExecutableOperator getExecutableOperator() {
        return this.exOp;
    }

    protected abstract void checkMetaData() throws Exception;

    protected abstract void exportTable() throws Exception;

    protected abstract void callTool() throws Exception;

    protected abstract void importResult() throws Exception;

    protected abstract void saveResult() throws Exception;

    protected abstract void clean() throws Exception;

    protected void callScript(String command) throws DMException {
        try {
            Runtime runtime = Runtime.getRuntime();
            String s = File.separator;
            String[] args = new String[3];
            String temporaryDir = SystemPropertyInterface.getProperty("TEMP_DIR");
            args[0] = this.m_properties.getProperty("shell");
            args[1] = "-c";
            args[2] = "PATH=\"$PATH:" + this.m_ml_home + s + "bin" + s + this.m_os_name + s + "\"; " + "export PATH; " + "cd " + temporaryDir + "; " + command;
            Process proc = runtime.exec(args, null);
            proc.waitFor();
            if (this.m_log == null) {
                this.m_log = new FileOutputStream(String.valueOf(temporaryDir) + s + "wrapper_script.log");
            }
            InputStream strm = proc.getInputStream();
            int c = strm.read();
            while (c != -1) {
                this.m_log.write(c);
                c = strm.read();
            }
            strm = proc.getErrorStream();
            c = strm.read();
            while (c != -1) {
                this.m_log.write(c);
                c = strm.read();
            }
            int ex = proc.exitValue();
            if (ex != 0) {
                proc.destroy();
                throw new DMException("Wrapper: Error calling script (returned with exit value " + ex + "): " + command);
            }
        }
        catch (Exception e) {
            throw new DMException("Wrapper: Error calling script " + command + " :" + e.getMessage());
        }
    }

    protected double getSampleRatio(long sampleSize, String tableName, String columnName) throws DMException, DbConnectionClosed {
        if (sampleSize <= 0L) {
            throw new DMException("Wrapper: Sample Size must be positive! Found: " + sampleSize + ".");
        }
        String sql_getNumberOfRecords = "SELECT count(*) FROM " + tableName;
        if (columnName != null) {
            sql_getNumberOfRecords = String.valueOf(sql_getNumberOfRecords) + " WHERE " + columnName + " is not null";
        }
        long count = 0L;
        try {
            Long countL = this.getM4Db().executeBusinessSingleValueSqlReadL(sql_getNumberOfRecords);
            if (countL == null) {
                throw new DMException("Wrapper: Could not read result  from query: " + sql_getNumberOfRecords);
            }
            count = countL;
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new DMException("Wrapper: Could not read result  from query: " + sql_getNumberOfRecords + ", Database problem: " + sqle.getMessage());
        }
        if (sampleSize > count) {
            sampleSize = count;
        }
        double sampleRatio = (double)sampleSize / (double)count;
        return sampleRatio;
    }

    protected String getArtificalColumnName(String otherColumns) {
        String artCol = "Z";
        while (otherColumns.indexOf(String.valueOf(artCol) + ",") > -1) {
            artCol = String.valueOf(artCol) + "1";
        }
        return artCol;
    }

    public Step getStep() {
        return this.step;
    }
}

