/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.wrapper.dista.C45;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import miningmart.compiler.wrapper.dista.C45.Attribute;
import miningmart.compiler.wrapper.dista.C45.Node;
import miningmart.compiler.wrapper.dista.C45.NominalAttribute;
import miningmart.compiler.wrapper.dista.C45.NominalNode;
import miningmart.compiler.wrapper.dista.C45.NumericAttribute;
import miningmart.compiler.wrapper.dista.C45.NumericNode;
import miningmart.compiler.wrapper.dista.C45.ReturnNode;
import miningmart.compiler.wrapper.dista.C45.Schema;
import miningmart.compiler.wrapper.dista.C45.Tree;
import miningmart.compiler.wrapper.dista.DLFTokenizer;
import miningmart.compiler.wrapper.dista.DMException;

public class TreeParser {
    DLFTokenizer m_st;
    Schema l_schema;

    public TreeParser(Reader r) {
        this.m_st = new DLFTokenizer(r);
    }

    protected Attribute parseAttr() throws Exception {
        Attribute attr = null;
        String ty = this.m_st.getWord();
        if (ty.equals("nom")) {
            this.m_st.checkBeginRecord();
            attr = new NominalAttribute();
            attr.setName(this.m_st.getString());
            this.m_st.checkEndRecord();
        } else if (ty.equals("num")) {
            this.m_st.checkBeginRecord();
            attr = new NumericAttribute();
            attr.setName(this.m_st.getString());
            this.m_st.checkEndRecord();
        } else {
            throw new DMException(this.m_st.errorMsg("expected nom/num words"));
        }
        return attr;
    }

    protected Node parseNominalNode() throws Exception {
        NominalNode n = new NominalNode();
        this.m_st.checkBeginRecord();
        n.setAttr(this.l_schema.findAttr(this.m_st.getString()));
        this.m_st.checkBeginList();
        while (!this.m_st.isEndList()) {
            this.m_st.checkBeginRecord();
            n.addValueName(this.m_st.getString());
            Node child = this.parseNode();
            n.addChild(child);
            this.m_st.checkEndRecord();
        }
        this.m_st.checkEndRecord();
        return n;
    }

    protected Node parseNumericNode() throws Exception {
        NumericNode n = new NumericNode();
        this.m_st.checkBeginRecord();
        if (!this.m_st.getWord().equals("le")) {
            throw new DMException(this.m_st.errorMsg("expected le word"));
        }
        n.setAttr(this.l_schema.findAttr(this.m_st.getString()));
        n.setValue(this.m_st.getNumber());
        n.addChild(this.parseNode());
        n.addChild(this.parseNode());
        this.m_st.checkEndRecord();
        return n;
    }

    protected Node parseReturnNode() throws Exception {
        ReturnNode n = new ReturnNode();
        this.m_st.checkBeginRecord();
        n.setValueName(this.m_st.getString());
        this.m_st.checkEndRecord();
        return n;
    }

    protected Node parseNode() throws Exception {
        Node n = null;
        String ty = this.m_st.getWord();
        if (ty.equals("nom")) {
            n = this.parseNominalNode();
        } else if (ty.equals("num")) {
            n = this.parseNumericNode();
        } else if (ty.equals("return")) {
            n = this.parseReturnNode();
        } else {
            throw new DMException(this.m_st.errorMsg("expected nom/num/return words"));
        }
        return n;
    }

    public Tree parse() throws Exception {
        Tree tree = new Tree();
        this.l_schema = new Schema();
        tree.setSchema(this.l_schema);
        this.m_st.nextToken();
        if (!this.m_st.getWord().equals("tree")) {
            throw new DMException(this.m_st.errorMsg("expected tree word"));
        }
        this.m_st.checkBeginRecord();
        this.m_st.checkBeginList();
        while (!this.m_st.isEndList()) {
            this.l_schema.addAttr(this.parseAttr());
        }
        tree.setRoot(this.parseNode());
        this.m_st.checkEndRecord();
        this.l_schema = null;
        this.m_st.checkEOF();
        return tree;
    }

    public static void main(String[] args) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            TreeParser tp = new TreeParser(r);
            Tree tree = tp.parse();
            BufferedWriter w = new BufferedWriter(new FileWriter(args[1]));
            PrintWriter pw = new PrintWriter(w);
            tree.dumpOn(pw);
            pw.close();
            ((Writer)w).close();
        }
        catch (Exception e) {
            System.out.print("Error= " + e);
        }
    }
}

