/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.dista;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Value;
import miningmart.compiler.operator.dista.DistaFeatureSelection;
import miningmart.compiler.operator.dista.FS;
import miningmart.compiler.operator.dista.GeneticFS;

public class GeneticFeatureSelection
extends DistaFeatureSelection {
    private GeneticFS myFSWrapper;
    protected BaseAttribute theTargetAttribute;
    protected Value popDim;
    protected Value stepNum;
    protected Value probMut;
    protected Value probCross;

    protected FS getWrapper() throws M4CompilerError {
        return this.myFSWrapper;
    }

    protected void loadParameters() throws M4CompilerError {
        this.theTargetAttribute = (BaseAttribute)this.getSingleParameter("TheTargetAttribute");
        this.popDim = (Value)this.getSingleParameter("PopDim");
        this.stepNum = (Value)this.getSingleParameter("StepNum");
        this.probMut = (Value)this.getSingleParameter("ProbMut");
        this.probCross = (Value)this.getSingleParameter("ProbCross");
        try {
            this.myFSWrapper.m_pop_size = (int)Long.parseLong(this.popDim.getValue());
            this.myFSWrapper.m_gen_num = (int)Long.parseLong(this.stepNum.getValue());
            this.myFSWrapper.m_prob_mut = Double.parseDouble(this.probMut.getValue());
            this.myFSWrapper.m_prob_cross = Double.parseDouble(this.probCross.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("GeneticFS: Error reading a parameter: " + nfe.getMessage());
        }
    }

    protected void initialiseWrapper() throws M4CompilerError {
        try {
            this.myFSWrapper = new GeneticFS(this.getM4Db(), this.getStep(), this);
        }
        catch (Exception e) {
            throw new M4CompilerError("GeneticFS Wrapper: Error initialising wrapper: " + e.getMessage());
        }
    }

    protected void callWrapper(BaseAttribute[] featuresToSelectFrom) throws M4CompilerError {
        try {
            this.myFSWrapper.call(this.getInputConcept(), featuresToSelectFrom, this.theTargetAttribute.getCurrentColumn(), this.sampleSize);
        }
        catch (Exception e) {
            throw new M4CompilerError("GeneticFS Wrapper: Error executing external algorithm: " + e.getMessage());
        }
    }
}

