/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.dista;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Step;
import miningmart.compiler.operator.ExecutableOperator;
import miningmart.compiler.wrapper.dista.ColumnInfo;
import miningmart.compiler.wrapper.dista.MetaData;
import miningmart.compiler.wrapper.dista.Wrapper;

public abstract class DistaTool {
    protected CompilerDatabaseService m4db;
    protected String m_nameForDatabaseUse;
    protected MetaData m_md;
    protected double myPruningConfidence;
    protected final ExecutableOperator exOp;
    private final Step step;

    public DistaTool(CompilerDatabaseService m4db, Step step, ExecutableOperator exOp) throws Exception {
        this.exOp = exOp;
        this.m4db = m4db;
        this.step = step;
    }

    protected ExecutableOperator getExecutableOperator() {
        return this.exOp;
    }

    protected abstract Wrapper getWrapperInstance() throws Exception;

    protected abstract String getPrefix();

    public CompilerDatabaseService getM4Db() {
        return this.m4db;
    }

    public Step getStep() {
        return this.step;
    }

    public void call(Concept theInputConcept, BaseAttribute[] thePredictingAttributes, Column colToFill, long sampleSize) throws M4CompilerError {
        Columnset theColumnSet;
        Wrapper wrapper = null;
        try {
            wrapper = this.getWrapperInstance();
            wrapper.setConnection(this.getM4Db());
        }
        catch (Exception e) {
            throw new M4CompilerError("Error creating wrapper: " + e);
        }
        try {
            theColumnSet = theInputConcept.getCurrentColumnSet();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in DistaTool: " + m4e.getMessage());
        }
        this.m_md = new MetaData();
        this.m_md.setTableName(String.valueOf(theColumnSet.getSchema()) + "." + theColumnSet.getName());
        try {
            int i = 0;
            while (i < thePredictingAttributes.length) {
                if (!thePredictingAttributes[i].isNew()) {
                    ColumnInfo ci = new ColumnInfo();
                    ci.setName(thePredictingAttributes[i].getCurrentColumn().getName());
                    ci.setDataType(thePredictingAttributes[i].getCurrentColumn().getColumnDataTypeName());
                    ci.setConceptType(thePredictingAttributes[i].getConceptualDataTypeName());
                    ci.setSqlName(thePredictingAttributes[i].getCurrentColumn().getSQLDefinition());
                    this.m_md.addColumnInfo(ci);
                }
                ++i;
            }
            if (colToFill != null) {
                ColumnInfo ci = new ColumnInfo();
                ci.setName(colToFill.getName());
                ci.setSqlName(colToFill.getSQLDefinition());
                ci.setDataType(colToFill.getColumnDataTypeName());
                ci.setConceptType(colToFill.getTheBaseAttribute().getConceptualDataTypeName());
                this.m_md.setColumnToLearn(ci);
            }
        }
        catch (Exception e) {
            throw new M4CompilerError("Error loading meta data: " + e);
        }
        String ss = "";
        if (colToFill != null) {
            ss = "_" + colToFill.getName();
        }
        this.m_nameForDatabaseUse = String.valueOf(this.getPrefix()) + "_" + theInputConcept.getId() + ss + theInputConcept.getCurrentSuffix();
        try {
            wrapper.setSampleSize(sampleSize);
            wrapper.setResultName(this.m_nameForDatabaseUse);
            wrapper.setMetaData(this.m_md);
            wrapper.run();
        }
        catch (Exception e) {
            throw new M4CompilerError("Error running wrapper: " + e);
        }
    }

    public String getNameForDBUse() {
        return this.m_nameForDatabaseUse;
    }

    public void setPruningConfidence(double newPC) {
        this.myPruningConfidence = newPC;
    }

    public String getNameFunction() {
        return String.valueOf(this.getNameForDBUse()) + "_FCT";
    }

    public String getNameFunctionCall() {
        String s = String.valueOf(this.getNameFunction()) + "(";
        int i = 0;
        while (i < this.m_md.getColumnInfos().size()) {
            if (i != 0) {
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + ((ColumnInfo)this.m_md.getColumnInfos().elementAt(i)).getSqlName();
            ++i;
        }
        s = String.valueOf(s) + ")";
        return s;
    }
}

