/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Step;
import edu.udo.miningmart.m4.core.Value;
import java.sql.SQLException;
import miningmart.compiler.operator.ManualDiscretization;

public class TimeIntervalManualDiscretization
extends ManualDiscretization {
    private String tableName;

    public Value getTimeFormat() {
        return (Value)this.getSingleParameter("TimeFormat", this.getCurrentLoopNumber());
    }

    public void load(Step st) throws M4CompilerError {
        super.load(st);
        if (this.getIntervalStart().length != this.getIntervalEnd().length || this.getIntervalEnd().length != this.getMapTo().length || this.getMapTo().length != this.getStartIncExc().length || this.getStartIncExc().length != this.getEndIncExc().length) {
            throw new M4CompilerError("TimeIntervalManualDiscretization: Parameters lists IntervalStart, IntervalEnd, MapTo, StartIncExc and EndIncExc sizes must be equal!");
        }
    }

    private void createTable(String schema) throws M4CompilerError {
        this.tableName = "M4_DT_" + this.getStep().getId() + "_" + this.getCurrentLoopNumber();
        try {
            this.getM4Db().executeBusinessSqlWrite("DROP TABLE " + this.tableName);
        }
        catch (SQLException e) {
            this.doPrint(20, "Discretization table for this step didn't exist. OK!");
        }
        String create_table = "CREATE TABLE " + this.tableName + " (int_start date, int_end date, value varchar2(100), left_b char(1), right_b char(1))";
        try {
            this.getM4Db().executeBusinessSqlWrite(create_table);
        }
        catch (SQLException e) {
            throw new M4CompilerError("Error trying to create the table " + this.tableName + ": " + e.getMessage());
        }
        String alter_table = "ALTER TABLE " + this.tableName + " ADD CONSTRAINT " + this.tableName + "_chk CHECK ((left_b IN ('I','E')) AND (right_b IN ('I','E')))";
        try {
            this.getM4Db().executeBusinessSqlWrite(alter_table);
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException e) {
            throw new M4CompilerError("Error trying to alter the table " + this.tableName + ": " + e.getMessage());
        }
        this.getM4Db().addTableToTrash(this.tableName, schema, this.getStep().getId());
        String insert_query = null;
        int i = 0;
        while (i < this.getIntervalStart().length) {
            insert_query = "INSERT INTO " + schema + "." + this.tableName + " VALUES (to_date('" + this.getIntervalStart()[i].getValue() + "','" + this.getTimeFormat().getValue() + "'),to_date('" + this.getIntervalEnd()[i].getValue() + "','" + this.getTimeFormat().getValue() + "'),'" + this.getMapTo()[i].getValue() + "', '" + this.getStartIncExc()[i].getValue() + "','" + this.getEndIncExc()[i].getValue() + "')";
            try {
                this.getM4Db().executeBusinessSqlWrite(insert_query);
                this.getM4Db().commitBusinessTransactions();
            }
            catch (SQLException e) {
                throw new M4CompilerError("Error trying to fill the discretization table " + this.tableName + ": " + e.getMessage());
            }
            ++i;
        }
    }

    public String generateSQL(Column theTargetAttributeColumn) throws M4CompilerError {
        this.createTable(theTargetAttributeColumn.getColumnset().getSchema());
        String return_query = null;
        return_query = "time_interv_to_cat(" + theTargetAttributeColumn.getSQLDefinition() + ",'" + this.getTimeFormat().getValue() + "'," + "'" + theTargetAttributeColumn.getColumnset().getSchema() + "." + this.tableName + "'," + "'" + this.getDefaultValue().getValue() + "')";
        this.doPrint(12, "generatedSQL: " + return_query);
        return return_query;
    }
}

