/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Value;
import miningmart.compiler.operator.RowSelection;

public final class RowSelectionByQuery
extends RowSelection {
    public String generateConditionForOp() throws M4CompilerError {
        try {
            String sqlCondition = "";
            int i = 0;
            while (i < this.getNumberOfLoops()) {
                Value rightCond = this.getTheRightCondition(i);
                String rightExpr = rightCond.isLong() || !this.getTheConditionOperator(i).equalsIgnoreCase("=") ? rightCond.getValue() : DB.quote(rightCond.getValue());
                sqlCondition = String.valueOf(sqlCondition) + "(" + this.getTheLeftCondition(i).getCurrentColumn().getSQLDefinition() + " " + this.getTheConditionOperator(i) + " " + rightExpr + ") AND ";
                ++i;
            }
            sqlCondition = sqlCondition.substring(0, sqlCondition.length() - 4);
            return sqlCondition;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public BaseAttribute getTheLeftCondition(int loopNr) {
        return (BaseAttribute)this.getSingleParameter("TheLeftCondition", loopNr);
    }

    public String getTheConditionOperator(int loopNr) {
        return ((Value)this.getSingleParameter("TheConditionOperator", loopNr)).getValue();
    }

    public Value getTheRightCondition(int loopNr) {
        return (Value)this.getSingleParameter("TheRightCondition", loopNr);
    }
}

