/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Value;
import java.sql.SQLException;
import java.util.Vector;
import miningmart.compiler.operator.MissingValues;
import miningmart.compiler.wrapper.DB_SVM_RG;
import miningmart.compiler.wrapper.SVM_RG;
import miningmart.compiler.wrapper.SVM_Wrapper;

public class MissingValuesWithRegressionSVM
extends MissingValues {
    private SVM_Wrapper svm;
    private boolean useDatabaseSVM = false;

    public String generateValueForOp(Column columnWithMissingValues) throws M4CompilerError {
        this.callStatement(columnWithMissingValues);
        String fctCall = String.valueOf(this.svm.getDecisionFunctionName()) + "(";
        try {
            int i = 0;
            while (i < this.getThePredictingAttributes().length) {
                fctCall = String.valueOf(fctCall) + this.getThePredictingAttributes()[i].getCurrentColumn().getSQLDefinition() + ", ";
                ++i;
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        fctCall = String.valueOf(fctCall.substring(0, fctCall.length() - 2)) + ")";
        return fctCall;
    }

    private void callStatement(Column columnWithMissingValues) throws M4CompilerError {
        Columnset theColumnSet;
        this.svm = null;
        long sample = this.getSampleSize();
        try {
            if (this.useDatabaseSVM) {
                BaseAttribute keyBA = this.getKey();
                String key = null;
                if (keyBA != null) {
                    key = keyBA.getCurrentColumn().getName();
                }
                this.svm = sample == -1L ? new DB_SVM_RG(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), key, this.getLossFunctionPos(), this.getLossFunctionNeg()) : new DB_SVM_RG(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), key, sample, this.getLossFunctionPos(), this.getLossFunctionNeg());
            } else {
                this.svm = new SVM_RG(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), sample, this.getLossFunctionPos(), this.getLossFunctionPos());
            }
        }
        catch (InterruptedException e) {
            this.doPrint(20, "Error while constructing SVM: " + e.getMessage());
        }
        catch (Exception e) {
            this.doPrint(20, "Error with MissingValuesWithRegressionSVM: " + e.getMessage());
        }
        Vector<Column> theCols = new Vector<Column>();
        try {
            theColumnSet = this.getTheInputConcept().getCurrentColumnSet();
            String fctSchema = theColumnSet.getSchema();
            if (fctSchema.length() == 0) {
                fctSchema = null;
            }
            int i = 0;
            while (i < this.getThePredictingAttributes().length) {
                theCols.add(this.getThePredictingAttributes()[i].getCurrentColumn());
                ++i;
            }
            theCols.trimToSize();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        this.svm.callSVM(theColumnSet, columnWithMissingValues, this.getTheInputConcept().getId(), this.getC(), this.getKernelType(), this.getEpsilon(), theCols);
        try {
            this.getM4Db().commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SVM-Wrapper: could not commit DB updates: " + sqle.getMessage());
        }
    }

    private String getPrefixForDatabaseObjects() throws M4CompilerError {
        try {
            String loopIdentification = "";
            if (this.getHighestLoopNr() > 1) {
                loopIdentification = "L" + this.getCurrentLoopNumber();
            }
            return String.valueOf(this.getTheInputConcept().getCurrentColumnSet().getName()) + loopIdentification;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public String getC() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("C", this.getCurrentLoopNumber());
        if (v == null) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: Parameter C not found in loop " + this.getCurrentLoopNumber());
        }
        return v.getValue();
    }

    public String getEpsilon() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("Epsilon", this.getCurrentLoopNumber());
        if (v == null) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: Parameter Epsilon not found in loop " + this.getCurrentLoopNumber());
        }
        return v.getValue();
    }

    public String getKernelType() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("KernelType", this.getCurrentLoopNumber());
        if (v == null) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: Parameter KernelType not found in loop " + this.getCurrentLoopNumber());
        }
        return v.getValue();
    }

    public String getLossFunctionNeg() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("LossFunctionNeg", this.getCurrentLoopNumber());
        if (v == null) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: Parameter LossFunctionNeg not found in loop " + this.getCurrentLoopNumber());
        }
        return v.getValue();
    }

    public String getLossFunctionPos() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("LossFunctionPos", this.getCurrentLoopNumber());
        if (v == null) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: Parameter LossFunctionPos not found in loop " + this.getCurrentLoopNumber());
        }
        return v.getValue();
    }

    public long getSampleSize() throws M4CompilerError {
        long sample;
        Value v = (Value)this.getSingleParameter("SampleSize", this.getCurrentLoopNumber());
        if (v == null) {
            return -1L;
        }
        try {
            sample = Long.parseLong(v.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: SampleSize must be an integer! Found: " + v.getValue());
        }
        return sample;
    }

    public BaseAttribute[] getThePredictingAttributes() {
        return (BaseAttribute[])this.getParameter("ThePredictingAttributes", this.getCurrentLoopNumber());
    }

    public BaseAttribute getKey() {
        return (BaseAttribute)this.getSingleParameter("TheKey", this.getCurrentLoopNumber());
    }

    public void setToDatabaseSVM() {
        this.useDatabaseSVM = true;
    }

    public void setToStandardSVM() {
        this.useDatabaseSVM = false;
    }
}

