/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Value;
import miningmart.compiler.operator.Scaling;

public class LinearScaling
extends Scaling {
    public Value getNewRangeMax() {
        return (Value)this.getSingleParameter("NewRangeMax", this.getCurrentLoopNumber());
    }

    public Value getNewRangeMin() {
        return (Value)this.getSingleParameter("NewRangeMin", this.getCurrentLoopNumber());
    }

    public String generateSQL(Column targetAttributeColumn) throws M4CompilerError {
        try {
            String actMin = targetAttributeColumn.readOrComputeMinimum();
            String actMax = targetAttributeColumn.readOrComputeMaximum();
            return "( ((" + targetAttributeColumn.getSQLPlusLocation() + " - " + actMin + ") / " + "(" + actMax + " - " + actMin + ")) * " + "(" + this.getNewRangeMax().getValue() + " - " + this.getNewRangeMin().getValue() + ") + " + this.getNewRangeMin().getValue() + ")";
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
    }
}

