/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.MultiColumnFeature;
import edu.udo.miningmart.m4.core.Value;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compiler.operator.FeatureSelection;
import miningmart.compiler.wrapper.DB_SVM_CL;
import miningmart.compiler.wrapper.SVM_CL;
import miningmart.compiler.wrapper.SVM_Wrapper;

public class FeatureSelectionWithSVM
extends FeatureSelection {
    private SVM_Wrapper mysvm = null;
    private boolean useDatabaseSVM = false;

    protected Collection computeListOfAttributes(Feature[] theSuperset) throws M4CompilerError {
        this.useDatabaseSVM = this.mustUseDatabaseSVM();
        this.prepareSVM();
        Feature[] bestSubset = this.search(theSuperset);
        Vector<Feature> v = new Vector<Feature>();
        int i = 0;
        while (i < bestSubset.length) {
            v.add(bestSubset[i]);
            ++i;
        }
        v.trimToSize();
        return v;
    }

    private void prepareSVM() {
        block8: {
            try {
                long sample;
                Value v;
                BaseAttribute keyBA = this.getKey();
                String key = null;
                if (keyBA != null) {
                    key = keyBA.getCurrentColumn().getName();
                }
                if ((v = this.getPositiveTarget()) == null) {
                    throw new M4CompilerError("Operator FeatureSelectionWithSVM: Need parameter 'PositiveTargetValue'!");
                }
                String positiveTargetValue = v.getValue();
                Value sa = this.getSampleSize();
                if (sa == null) {
                    if (!this.useDatabaseSVM) {
                        throw new M4CompilerError("FeatureSelectionWithSVM: parameter 'SampleSize' must be specified if SVM outside database is used!");
                    }
                    this.mysvm = new DB_SVM_CL(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), key, positiveTargetValue);
                    break block8;
                }
                try {
                    sample = Long.parseLong(sa.getValue());
                }
                catch (NumberFormatException nfe) {
                    throw new M4CompilerError("FeatureSelectionWithSVM: SampleSize must be an integer! Found: " + v.getValue());
                }
                this.mysvm = this.useDatabaseSVM ? new DB_SVM_CL(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), key, sample, positiveTargetValue) : new SVM_CL(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), sample, positiveTargetValue);
            }
            catch (Exception e) {
                this.doPrint(20, "Error with SVM for FeatureSelection: " + e.getMessage());
            }
        }
    }

    private String getPrefixForDatabaseObjects() throws M4CompilerError {
        try {
            return this.getInputConcept().getCurrentColumnSet().getName();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private Feature[] search(Feature[] theSet) throws M4CompilerError {
        Vector best;
        Vector<Feature> all = new Vector<Feature>();
        int i = 0;
        while (i < theSet.length) {
            all.add(theSet[i]);
            ++i;
        }
        all.trimToSize();
        if (this.getDirection().getValue().equalsIgnoreCase("forward")) {
            Vector empty = new Vector(0);
            best = this.searchForward(empty, all, -1.0);
        } else {
            best = this.searchBackward(all, -1.0);
        }
        Feature[] bestSubset = new Feature[best.size()];
        String theNames = "";
        int i2 = 0;
        while (i2 < bestSubset.length) {
            bestSubset[i2] = (Feature)best.get(i2);
            theNames = String.valueOf(theNames) + bestSubset[i2].getName() + ", ";
            ++i2;
        }
        theNames = theNames.substring(0, theNames.length() - 2);
        this.doPrint(12, "FSwithSVM: selected the following features: " + theNames);
        return bestSubset;
    }

    private Vector searchBackward(Vector current, double currentPerformance) throws M4CompilerError {
        if (current.size() == 1) {
            return current;
        }
        if (currentPerformance == -1.0) {
            this.doPrint(12, "FSwithSVM: evaluating all features...");
            currentPerformance = this.getSVMEstimation(current);
        }
        Vector bestDaughter = current;
        double bestPerformance = -1.0;
        this.doPrint(12, "Trying all sets of " + (current.size() - 1) + " features.");
        int i = 0;
        while (i < current.size()) {
            Vector daughter = this.removeIndexedFeature(current, i);
            double daughterPerformance = this.getSVMEstimation(daughter);
            if (daughterPerformance > bestPerformance) {
                bestPerformance = daughterPerformance;
                bestDaughter = daughter;
            }
            ++i;
        }
        if (bestPerformance >= currentPerformance) {
            return this.searchBackward(bestDaughter, bestPerformance);
        }
        return current;
    }

    private Vector searchForward(Vector current, Vector all, double currentPerformance) throws M4CompilerError {
        if (current.size() == all.size()) {
            return current;
        }
        if (currentPerformance == -1.0 && !current.isEmpty()) {
            currentPerformance = this.getSVMEstimation(current);
        }
        Vector bestDaughter = current;
        double bestPerformance = -1.0;
        this.doPrint(12, "FSwithSVM: forward search on level " + current.size() + "...");
        int i = 0;
        while (i < all.size()) {
            double daughterPerformance;
            Vector daughter = this.addIndexedFeature(current, all, i);
            if (daughter != null && (daughterPerformance = this.getSVMEstimation(daughter)) > bestPerformance) {
                bestPerformance = daughterPerformance;
                bestDaughter = daughter;
            }
            ++i;
        }
        if (bestPerformance > currentPerformance) {
            this.doPrint(12, "FSwithSVM: best performance on this level was estimated: " + bestPerformance);
            return this.searchForward(bestDaughter, all, bestPerformance);
        }
        this.doPrint(12, "FSwithSVM: returned from this level with estimation: " + currentPerformance);
        return current;
    }

    private double getSVMEstimation(Vector theFeatures) throws M4CompilerError {
        try {
            Columnset theColumnSet = this.getInputConcept().getCurrentColumnSet();
            Vector<Column> theCols = new Vector<Column>();
            int i = 0;
            while (i < theFeatures.size()) {
                Feature f = (Feature)theFeatures.get(i);
                if (f instanceof BaseAttribute) {
                    BaseAttribute ba = (BaseAttribute)f;
                    theCols.add(ba.getCurrentColumn());
                } else {
                    MultiColumnFeature mcf = (MultiColumnFeature)f;
                    Collection theBAs = mcf.getBaseAttributes();
                    Iterator it = theBAs.iterator();
                    while (it.hasNext()) {
                        theCols.add(((BaseAttribute)it.next()).getCurrentColumn());
                    }
                }
                ++i;
            }
            theCols.trimToSize();
            Column theTargetAttributeColumn = this.getTheTargetAttribute().getCurrentColumn();
            this.mysvm.callSVM(theColumnSet, theTargetAttributeColumn, this.getInputConcept().getId(), this.getC().getValue(), this.getKernelType().getValue(), this.getEpsilon().getValue(), theCols);
            return this.mysvm.getXiAlphaEstimation();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private Vector addIndexedFeature(Vector to, Vector from, int index) {
        Object o = from.get(index);
        if (to.contains(o)) {
            return null;
        }
        Vector v = new Vector();
        int i = 0;
        while (i < to.size()) {
            v.add(to.get(i));
            ++i;
        }
        v.add(o);
        v.trimToSize();
        return v;
    }

    private Vector removeIndexedFeature(Vector from, int index) {
        Vector v = new Vector();
        int i = 0;
        while (i < from.size()) {
            if (i != index) {
                v.add(from.get(i));
            }
            ++i;
        }
        v.trimToSize();
        return v;
    }

    private Value getDirection() {
        return (Value)this.getSingleParameter("SearchDirection");
    }

    private Value getPositiveTarget() {
        return (Value)this.getSingleParameter("PositiveTargetValue");
    }

    private Value getSampleSize() {
        return (Value)this.getSingleParameter("SampleSize");
    }

    private Value getC() {
        return (Value)this.getSingleParameter("C");
    }

    private BaseAttribute getKey() {
        return (BaseAttribute)this.getSingleParameter("TheKey");
    }

    private BaseAttribute getTheTargetAttribute() {
        return (BaseAttribute)this.getSingleParameter("TheTargetAttribute");
    }

    private Value getEpsilon() {
        return (Value)this.getSingleParameter("Epsilon");
    }

    private Value getKernelType() {
        return (Value)this.getSingleParameter("KernelType");
    }

    private Value getLossFunctionNeg() {
        return (Value)this.getSingleParameter("LossFunctionNeg");
    }

    private Value getLossFunctionPos() {
        return (Value)this.getSingleParameter("LossFunctionPos");
    }

    private boolean mustUseDatabaseSVM() {
        Value v = (Value)this.getSingleParameter("UseDB_SVM");
        boolean b = false;
        if (v != null) {
            b = v.getValue().equalsIgnoreCase("true");
        }
        return b;
    }
}

