/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Feature;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import miningmart.compiler.operator.SingleCSOperator;

public class FeatureConstructionWithTFIDF
extends SingleCSOperator {
    private String colNames;
    private String colNamesWithDefs;
    private final String NEW_COLDT_NAME = "NUMBER";
    private final short NEW_COL_DT = (short)12;
    private Feature[] outputF = null;

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        String timeStamp;
        String key;
        String inputConcept;
        String columnSetName;
        try {
            this.makeListsOfColumns();
            columnSetName = this.getNewCSName();
            inputConcept = this.getInputConcept().getCurrentColumnSet().getName();
            key = this.getTheKey().getCurrentColumn().getName();
            timeStamp = this.getTheTimeStamp().getCurrentColumn().getName();
        }
        catch (M4Exception e) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF.generateSQLDefinition(String):\n" + e.getMessage());
        }
        Feature[] features = this.getTheSelectedAttributes();
        Hashtable indexes = new Hashtable();
        int total = 0;
        ResultSet ergebnis = null;
        try {
            try {
                String query = "SELECT " + this.colNames + " FROM " + inputConcept + " ORDER BY " + key + ", " + timeStamp;
                ergebnis = this.getM4Db().executeBusinessSqlRead(query);
                while (ergebnis.next()) {
                    String colName;
                    int i;
                    String[] werte;
                    int id = ergebnis.getInt(key);
                    if (!indexes.containsKey(new Integer(id))) {
                        Vector<String[]> liste = new Vector<String[]>();
                        werte = new String[features.length];
                        i = 0;
                        while (i < features.length) {
                            try {
                                colName = ((BaseAttribute)features[i]).getCurrentColumn().getName();
                                werte[i] = ergebnis.getString(colName);
                            }
                            catch (M4Exception e) {
                                throw new M4CompilerError("FeatureConstructionWithTFIDF.generateSQLDefinition(String):\n" + e.getMessage());
                            }
                            ++i;
                        }
                        liste.add(werte);
                        indexes.put(new Integer(id), liste);
                        continue;
                    }
                    Vector werteListe = (Vector)indexes.get(new Integer(id));
                    werte = new String[features.length];
                    i = 0;
                    while (i < features.length) {
                        try {
                            colName = ((BaseAttribute)features[i]).getCurrentColumn().getName();
                            werte[i] = ergebnis.getString(colName);
                        }
                        catch (M4Exception e) {
                            throw new M4CompilerError("FeatureConstructionWithTFIDF.generateSQLDefinition(String):\n" + e.getMessage());
                        }
                        ++i;
                    }
                    werteListe.add(werte);
                }
                ergebnis.close();
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("EvaluateAdvantageOFTFIDFTransformation: An error occurred: " + sqle.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var20_32 = null;
            DB.closeResultSet(ergebnis);
            throw throwable;
        }
        Object var20_33 = null;
        DB.closeResultSet(ergebnis);
        Hashtable<Integer, int[]> tfidf = new Hashtable<Integer, int[]>();
        int[] df = new int[features.length];
        Enumeration e = indexes.keys();
        while (e.hasMoreElements()) {
            Integer index = (Integer)e.nextElement();
            Vector aktuell = (Vector)indexes.get(index);
            int[] frequencies = new int[features.length];
            tfidf.put(index, frequencies);
            if (aktuell.size() <= 1) continue;
            int i = 1;
            while (i < aktuell.size()) {
                String[] currentValues = (String[])aktuell.get(i);
                String[] previousValues = (String[])aktuell.get(i - 1);
                int j = 0;
                while (j < features.length) {
                    if (!currentValues[j].equals(previousValues[j])) {
                        int n = j;
                        frequencies[n] = frequencies[n] + 1;
                    }
                    ++j;
                }
                ++i;
            }
            int k = 0;
            while (k < features.length) {
                if (frequencies[k] > 0) {
                    int n = k;
                    df[n] = df[n] + 1;
                }
                ++k;
            }
        }
        try {
            this.createTable(columnSetName, this.colNamesWithDefs);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("FeatureConstructionByTFIDF: could not create table: " + sqle.getMessage());
        }
        try {
            total = this.getM4Db().executeBusinessSingleValueSqlReadL("SELECT COUNT(DISTINCT " + key + ") FROM " + inputConcept).intValue();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("FeatureConstructionByTFIDF: An errror occurred: " + sqle.getMessage());
        }
        Enumeration en = tfidf.keys();
        while (en.hasMoreElements()) {
            Integer aktuelleId = (Integer)en.nextElement();
            double[] tfidfValues = new double[features.length];
            int[] frequencyValues = (int[])tfidf.get(aktuelleId);
            String insertValues = "(" + aktuelleId + ", ";
            int i = 0;
            while (i < frequencyValues.length) {
                tfidfValues[i] = (double)frequencyValues[i] * Math.log(total / df[i]);
                insertValues = String.valueOf(insertValues) + tfidfValues[i] + ", ";
                ++i;
            }
            insertValues = insertValues.substring(0, insertValues.length() - 2);
            insertValues = String.valueOf(insertValues) + ")";
            String updateTable = "INSERT INTO " + columnSetName + " VALUES " + insertValues;
            try {
                this.getM4Db().executeBusinessSqlWrite(updateTable);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("FeatureConstructionByTFIDF: could not insert values: " + sqle.getMessage());
            }
        }
        try {
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("FeatureConstructionByTFIDF: could not commit to business: " + sqle.getMessage());
        }
        try {
            this.getM4Db().addTableToTrash(this.getNewCSName(), this.getInputConcept().getCurrentColumnSet().getSchema(), this.getStep().getId());
        }
        catch (M4Exception e2) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF.generateSQLDefinition(String):\n" + e2.getMessage());
        }
        try {
            this.getM4Db().commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF: could not commit to M4: " + sqle.getMessage());
        }
        return columnSetName;
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return false;
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        Column keyColumn;
        try {
            keyColumn = this.getTheKey().getCurrentColumn().copyColTo(csForOutputConcept);
        }
        catch (M4Exception e) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF.generategenerateColumns(Columnset):\n" + e.getMessage());
        }
        String columnExpr = String.valueOf(keyColumn.getSQLDefinition()) + ", ";
        try {
            Feature[] selectedFeatures = this.getTheSelectedAttributes();
            int i = 0;
            while (i < selectedFeatures.length) {
                BaseAttribute ba = (BaseAttribute)selectedFeatures[i];
                Column col = this.createM4Column(ba, csForOutputConcept, String.valueOf(ba.getCurrentColumn().getName()) + "_tfidf");
                columnExpr = String.valueOf(columnExpr) + col.getName() + ", ";
                ++i;
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF: SQL error: " + sqle.getMessage());
        }
        catch (M4Exception e) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF.generategenerateColumns(Columnset):\n" + e.getMessage());
        }
        if (columnExpr.equals("")) {
            throw new M4CompilerError("ConceptOperator (" + this.getName() + "): No columns for output concept created!");
        }
        columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
        return columnExpr;
    }

    protected Column createM4Column(BaseAttribute outputBA, Columnset newCS, String newColumnName) throws SQLException, M4CompilerError, M4Exception {
        Column newColumn = new Column(this.getM4Db());
        newColumn.setId(0L);
        newColumn.setName(newColumnName);
        newColumn.setColumnset(newCS);
        newColumn.setBaseAttribute(outputBA);
        newColumn.setColumnDataType(12L);
        newColumn.setColumnDataTypeName("NUMBER");
        newColumn.setSQLDefinition(newColumnName);
        outputBA.addColumn(newColumn);
        newCS.addColumn(newColumn);
        return newColumn;
    }

    private void makeListsOfColumns() throws M4CompilerError, M4Exception {
        this.colNames = String.valueOf(this.getTheKey().getCurrentColumn().getSQLDefinition()) + ", ";
        this.colNamesWithDefs = String.valueOf(this.getTheKey().getCurrentColumn().getSQLDefinition()) + " " + this.getTheKey().getCurrentColumn().getColumnDataTypeName() + ", ";
        Feature[] outF = this.getTheSelectedAttributes();
        int i = 0;
        while (i < outF.length) {
            BaseAttribute ba = (BaseAttribute)outF[i];
            Column col = ba.getCurrentColumn();
            this.colNames = String.valueOf(this.colNames) + col.getName() + ", ";
            this.colNamesWithDefs = String.valueOf(this.colNamesWithDefs) + col.getName() + "_tfidf " + "NUMBER" + ", ";
            ++i;
        }
        this.colNames = this.colNames.substring(0, this.colNames.length() - 2);
        this.colNamesWithDefs = this.colNamesWithDefs.substring(0, this.colNamesWithDefs.length() - 2);
    }

    private void createTable(String tableName, String columnDefs) throws SQLException, M4CompilerError {
        this.getM4Db().dropBusinessTable(tableName);
        String cmd = "CREATE TABLE " + tableName + " (" + columnDefs + ")";
        this.getM4Db().executeBusinessSqlWrite(cmd);
    }

    protected Feature[] getTheSelectedAttributes() throws M4CompilerError {
        return (Feature[])this.getParameter("TheSelectedAttributes");
    }

    public BaseAttribute getTheTimeStamp() {
        return (BaseAttribute)this.getSingleParameter("TheTimeStamp");
    }

    public BaseAttribute getTheKey() {
        return (BaseAttribute)this.getSingleParameter("TheKey");
    }
}

