/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.ParameterDeselectedError;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.OpParam;
import edu.udo.miningmart.m4.core.Step;
import java.sql.SQLException;
import miningmart.compiler.operator.ExecutableOperator;

public abstract class FeatureConstruction
extends ExecutableOperator {
    private Column[] theOutputColumns;
    private String[] generatedSQLDefinitions;
    private int numberOfLoops;
    private int currentLoopNr = 0;
    private boolean targetAttribDeselected = false;
    static /* synthetic */ Class class$0;

    /*
     * Unable to fully structure code
     */
    public void load(Step st) throws M4CompilerError {
        block3: {
            try {
                super.load(st);
                break block3;
            }
            catch (ParameterDeselectedError e) {
                violated = e.getViolatedOpParams();
                it = violated.iterator();
                ** while (it.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                op = (OpParam)it.next();
                if (this.handleParameterDeselected(op)) continue;
                throw new M4CompilerError("FeatureConstruction: Parameter " + op.getName() + " is missing / deselected, but is obligatory!");
            }
        }
        this.currentLoopNr = 0;
        this.theOutputColumns = new Column[this.getNumberOfLoops()];
        this.generatedSQLDefinitions = new String[this.getNumberOfLoops()];
    }

    private boolean handleParameterDeselected(OpParam op) {
        this.targetAttribDeselected = op.getName().equals("TheTargetAttribute");
        return this.targetAttribDeselected;
    }

    public void execute(boolean lazy) throws M4CompilerError, SQLException {
        if (this.targetAttribDeselected) {
            this.print();
        } else {
            super.execute(lazy);
        }
    }

    public void createStatement(boolean lazy) throws SQLException, M4CompilerError {
        this.currentLoopNr = 0;
        while (this.currentLoopNr < this.getNumberOfLoops()) {
            this.theOutputColumns[this.currentLoopNr] = this.generateColumnForOp();
            this.generatedSQLDefinitions[this.currentLoopNr] = this.theOutputColumns[this.currentLoopNr].getSQLDefinition();
            ++this.currentLoopNr;
        }
    }

    public void compileStatement() throws SQLException, M4CompilerError {
        int i = 0;
        while (i < this.getNumberOfLoops()) {
            long oldDataType = this.theOutputColumns[i].getColumnDataType();
            long newDataType = this.getM4Db().testSQLColumn(this.theOutputColumns[i]);
            if (newDataType != oldDataType) {
                this.doPrint(12, "Warning: FeatureConstruction: OutputAttribute Column is of different datatype than TargetAttribute Column.");
                try {
                    this.theOutputColumns[i].setColumnDataTypeName(this.getNameForColumnDataType(newDataType));
                }
                catch (M4Exception e) {
                    throw new M4CompilerError("Error setting column datatype by name (type was: " + newDataType + ")!\n" + e.getMessage());
                }
            }
            this.theOutputColumns[i].setColumnDataType(newDataType);
            ++i;
        }
    }

    public void writeResults() {
    }

    public Column generateColumnForOp() throws M4CompilerError {
        try {
            Column theTargetAttributeColumn = this.getTheTargetAttribute().getCurrentColumn();
            String newColSqlDef = this.generateSQL(theTargetAttributeColumn);
            CompilerDatabaseService compilerDatabaseService = this.getM4Db();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Column");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Column newCol = (Column)compilerDatabaseService.createNewInstance(clazz);
            newCol.setId(0L);
            BaseAttribute theBA = this.getTheOutputAttribute();
            newCol.setBaseAttribute(theBA);
            newCol.setName(this.getTheOutputAttribute().getName());
            newCol.setColumnset(theTargetAttributeColumn.getColumnset());
            newCol.setColumnDataType(theTargetAttributeColumn.getColumnDataType());
            newCol.setColumnDataTypeName(theTargetAttributeColumn.getColumnDataTypeName());
            newCol.setSQLDefinition(newColSqlDef);
            this.getStep().addToTrash(newCol);
            return newCol;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public abstract String generateSQL(Column var1) throws M4CompilerError;

    public int getNumberOfLoops() {
        int loops = this.getHighestLoopNr();
        return loops > 0 ? loops : 1;
    }

    public int getCurrentLoopNumber() {
        return this.currentLoopNr;
    }

    public Concept getTheInputConcept() {
        return (Concept)this.getSingleParameter("TheInputConcept");
    }

    public BaseAttribute getTheOutputAttribute() {
        return this.getTheOutputAttribute(this.getCurrentLoopNumber());
    }

    public BaseAttribute getTheTargetAttribute() {
        return this.getTheTargetAttribute(this.getCurrentLoopNumber());
    }

    public BaseAttribute getTheOutputAttribute(int loopNr) {
        return (BaseAttribute)this.getSingleParameter("TheOutputAttribute", loopNr);
    }

    public BaseAttribute getTheTargetAttribute(int loopNr) {
        return (BaseAttribute)this.getSingleParameter("TheTargetAttribute", loopNr);
    }

    private String getNameForColumnDataType(long type) throws M4CompilerError {
        if (type == 12L) {
            return "NUMBER";
        }
        if (type == 13L) {
            return "STRING";
        }
        if (type == 14L) {
            return "DATE";
        }
        if (type == 15L) {
            return "KEY";
        }
        throw new M4CompilerError("FeatureConstruction: Found unknown column data type number: " + type);
    }
}

