/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.MultiColumnFeature;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import miningmart.compiler.operator.ExecutableOperator;

public abstract class ConceptOperator
extends ExecutableOperator {
    private Columnset[] myOutputColumnSets;
    static /* synthetic */ Class class$0;

    public void compileStatement() throws SQLException, M4CompilerError {
        if (this.myOutputColumnSets != null) {
            int i = 0;
            while (i < this.myOutputColumnSets.length) {
                if (this.myOutputColumnSets[i].getType().equalsIgnoreCase("V")) {
                    this.getM4Db().createSQLView(this.myOutputColumnSets[i], this.getStep());
                }
                if (this.myOutputColumnSets[i].getType().equalsIgnoreCase("SN")) {
                    throw new M4CompilerError("ConceptOperator.compileStatement(): found output ColumnSet of type 'Snapshot' (SN). This is not supported yet!");
                }
                if (this.myOutputColumnSets[i].getType().equalsIgnoreCase("MV")) {
                    throw new M4CompilerError("ConceptOperator.compileStatement(): found output ColumnSet of type 'Materialized View' (MV). This is not supported yet!");
                }
                ++i;
            }
        }
    }

    public void createStatement(boolean lazy) throws M4CompilerError {
        this.myOutputColumnSets = this.generateColumnSetsForOp(lazy);
        if (this.myOutputColumnSets == null) {
            throw new M4CompilerError("Operator '" + this.getName() + "' did not create a new Columnset!");
        }
        this.generatedSQLDefinitions = new String[this.myOutputColumnSets.length];
        int i = 0;
        while (i < this.myOutputColumnSets.length) {
            String type = this.myOutputColumnSets[i].getType().toUpperCase();
            if (type.equals("V")) {
                type = "VIEW";
            }
            if (type.equals("T")) {
                type = "TABLE";
            }
            this.generatedSQLDefinitions[i] = String.valueOf(type) + " " + this.myOutputColumnSets[i].getName() + " AS " + this.myOutputColumnSets[i].getSQLDefinition();
            ++i;
        }
        try {
            i = 0;
            while (i < this.myOutputColumnSets.length) {
                this.getOutputConcept().addColumnSet(this.myOutputColumnSets[i]);
                ++i;
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public abstract Columnset[] generateColumnSetsForOp(boolean var1) throws M4CompilerError;

    public Concept getInputConcept() {
        return (Concept)this.getSingleParameter("TheInputConcept");
    }

    public Concept getOutputConcept() {
        return (Concept)this.getSingleParameter("TheOutputConcept");
    }

    public void writeResults() {
    }

    protected Columnset createSingleColumnSet(int index) throws M4CompilerError {
        Columnset newCS;
        String newName = this.getNewCSName(index);
        try {
            CompilerDatabaseService compilerDatabaseService = this.getM4Db();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            newCS = (Columnset)compilerDatabaseService.createNewInstance(clazz);
            this.getStep().addToTrash(newCS);
        }
        catch (M4Exception e) {
            throw new M4CompilerError("M4Exception while trying to add newly created Columnset to trash of Step " + this.getStep().getId() + " in method ConceptOperator.createSingleColumnSet(int)!\n" + e.getMessage());
        }
        newCS.setName(newName);
        try {
            newCS.setId(0L);
            Columnset inputColumnSet = this.getInputConcept().getCurrentColumnSet();
            if (inputColumnSet == null) {
                throw new M4CompilerError("The Input Concept ('" + this.getInputConcept().getName() + "') of Step '" + this.getStep().getName() + "' has no Columnsets!");
            }
            newCS.setSchema(inputColumnSet.getSchema());
            String type = this.getTypeOfNewColumnSet(index).toUpperCase();
            if (!type.equals("V") && !type.equals("T")) {
                throw new M4CompilerError("ConceptOperator: found unknown type for new ColumnSet: '" + type + "'!");
            }
            newCS.setType(type);
            newCS.setTheConcept(this.getOutputConcept());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        String columnExpr = this.generateColumns(newCS);
        newCS.setSQLDefinition(this.generateSQLDefinition(columnExpr, index));
        this.setNewCSMultiStepBranch(newCS, index);
        return newCS;
    }

    protected void setNewCSMultiStepBranch(Columnset newCS, int index) throws M4CompilerError {
        try {
            Columnset inputColumnSet = this.getInputConcept().getCurrentColumnSet();
            newCS.setMultiStepBranch(inputColumnSet.getMultiStepBranch());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public abstract String getTypeOfNewColumnSet(int var1);

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        String columnExpr = "";
        Feature inF = null;
        int iIn = 0;
        Feature outF = null;
        int iOut = 0;
        try {
            iOut = 0;
            while (iOut < this.getOutputConcept().getFeatures().size()) {
                outF = this.getOutputConcept().getFeature(iOut);
                if (this.mustCopyFeature(outF.getName())) {
                    Column outputColumn;
                    Column inputColumn;
                    BaseAttribute outBA;
                    BaseAttribute inBA;
                    iIn = 0;
                    do {
                        inF = this.getInputConcept().getFeature(iIn);
                    } while (++iIn < this.getInputConcept().getFeatures().size() && !outF.correspondsTo(inF));
                    if (!outF.correspondsTo(inF)) {
                        this.doPrint(12, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because no corresponding input feature was found.");
                    } else if (this.isDeselectedParameter(inF)) {
                        this.doPrint(6, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because the corresponding input feature was deselected by " + "a FeatureSelection operator.");
                    } else if (outF instanceof BaseAttribute) {
                        inBA = (BaseAttribute)inF;
                        outBA = (BaseAttribute)outF;
                        inputColumn = inBA.getCurrentColumn();
                        outputColumn = inputColumn.copyColTo(csForOutputConcept);
                        this.getStep().addToTrash(outputColumn);
                        outputColumn.setBaseAttribute(outBA);
                        outBA.addColumn(outputColumn);
                        outputColumn.setSQLDefinition(inputColumn.getName());
                        String nextAttrib = inputColumn.getSQLDefinition();
                        if (!inputColumn.getName().equals(nextAttrib)) {
                            nextAttrib = String.valueOf(nextAttrib) + " " + inputColumn.getName();
                        }
                        columnExpr = String.valueOf(columnExpr) + nextAttrib + ", ";
                    } else {
                        if (!(outF instanceof MultiColumnFeature)) {
                            throw new M4CompilerError("Unknown Feature type found in Concept with id: " + this.getOutputConcept().getId() + "; Feature id: " + outF.getId());
                        }
                        MultiColumnFeature outMCF = (MultiColumnFeature)outF;
                        MultiColumnFeature inMCF = (MultiColumnFeature)inF;
                        Collection theBAs = outMCF.getBaseAttributes();
                        if (theBAs != null) {
                            try {
                                Iterator it = theBAs.iterator();
                                while (it.hasNext()) {
                                    outBA = (BaseAttribute)it.next();
                                    inBA = inMCF.getBaseAttributeByName(outBA.getName());
                                    inputColumn = inBA.getCurrentColumn();
                                    outputColumn = inputColumn.copyColTo(csForOutputConcept);
                                    this.getStep().addToTrash(outputColumn);
                                    outputColumn.setBaseAttribute(outBA);
                                    outBA.addColumn(outputColumn);
                                    outputColumn.setSQLDefinition(inputColumn.getName());
                                    columnExpr = String.valueOf(columnExpr) + inputColumn.getSQLDefinition() + " " + outputColumn.getSQLDefinition() + ", ";
                                }
                            }
                            catch (NullPointerException nfe) {
                                throw new M4CompilerError("ConceptOperator: Mismatch between MultiColumnFeatures in in- and output concept!");
                            }
                            catch (ArrayIndexOutOfBoundsException aie) {
                                throw new M4CompilerError("ConceptOperator: Mismatch between MultiColumnFeatures in in- and output concept!");
                            }
                        }
                    }
                }
                ++iOut;
            }
            if (columnExpr.equals("")) {
                throw new M4CompilerError("ConceptOperator (" + this.getName() + "): No columns for output concept created!");
            }
            columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
            return columnExpr;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public String getNewCSName(int index) {
        String name = "CS_" + this.getStep().getId() + this.getInputConcept().getCurrentSuffix();
        if (index > -1) {
            name = String.valueOf(name) + "_" + index;
        }
        return name;
    }

    protected abstract boolean mustCopyFeature(String var1) throws M4CompilerError;

    public abstract String generateSQLDefinition(String var1, int var2) throws M4CompilerError;
}

