/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;

public class Print
implements Serializable {
    private static final String MLHOME = "ML_HOME";
    private static final String LOGFILES = "LOG_FILES";
    private static final String DEF_VERB_SYS_PROP = "DEFAULT_VERBOSITY";
    public static final int MAX = 20;
    public static final int CASE_CONTROL = 18;
    public static final int STEP_CONTROL = 16;
    public static final int OP_CONTROL = 14;
    public static final int OPERATOR = 12;
    public static final int PARAM = 6;
    public static final int M4_OBJECT = 4;
    public static final int CACHE = 8;
    public static final int DB_WRITE = 10;
    public static final int DB_READ = 2;
    public static final int MIN = 0;
    private static final int DEFAULT_VERBOSITY = 11;
    private static final int LINESIZE = 500;
    private final FileWriter file;
    private final String fileName;
    private final int currVerbosity;
    private final boolean onlyOneLevel = false;

    public Print() {
        this.file = null;
        this.fileName = "<stdout>";
        String defVerbProperty = System.getProperty(DEF_VERB_SYS_PROP);
        if (defVerbProperty != null && defVerbProperty.length() > 0) {
            int vb;
            try {
                vb = Integer.parseInt(defVerbProperty);
            }
            catch (NumberFormatException e) {
                System.err.println("Warning: System property 'DEFAULT_VERBOSITY' set to '" + defVerbProperty + "'.\nCould not parse this value to integer!\n" + "Using default verbosity " + 11 + " instead.");
                vb = 11;
            }
            this.currVerbosity = vb;
        } else {
            this.currVerbosity = 11;
        }
    }

    public Print(int verbosity) {
        this.file = null;
        this.fileName = "<stdout>";
        this.currVerbosity = verbosity;
    }

    public Print(long caseId) throws IOException {
        this.fileName = this.getFileNameForCase(caseId);
        this.file = new FileWriter(this.fileName);
        this.currVerbosity = 11;
    }

    public Print(long caseId, int verbosity) throws IOException {
        this.fileName = this.getFileNameForCase(caseId);
        this.file = new FileWriter(this.fileName);
        this.currVerbosity = verbosity;
    }

    public String getFileNameForCase(long caseId) {
        String logs = System.getProperty(LOGFILES);
        if (logs == null || logs.equals("")) {
            logs = String.valueOf(System.getProperty(MLHOME)) + "log" + File.separator + "m4c.log";
        }
        if (caseId > 0L) {
            logs = String.valueOf(logs) + "_" + caseId;
        }
        return logs;
    }

    private void printToStdout(String line) {
        System.out.println(line);
    }

    private void printToFile(String line) {
        try {
            this.file.write(String.valueOf(line) + "\n");
            this.file.flush();
        }
        catch (IOException e) {
            System.err.println("\nCould not write to logfile " + this.fileName + " !");
            System.err.println("\nException is:\n" + e.getMessage());
            this.printToStdout(line);
        }
    }

    private void doPrint(String printString) {
        if (printString == null) {
            printString = "<null>";
        }
        int length = printString.length();
        int i = 0;
        while (i < length) {
            int end = i + 500;
            if (end > length) {
                end = length;
            }
            String oneLine = printString.substring(i, end);
            if (this.file == null) {
                this.printToStdout(oneLine);
            } else {
                this.printToFile(oneLine);
            }
            i += 500;
        }
    }

    public void doPrint(int verbosity, String printString) {
        if (verbosity >= this.currVerbosity) {
            this.doPrint(printString);
        }
    }

    public void doPrint(Exception ex) {
        this.doPrint(20, ex.getMessage());
    }
}

