/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.utils;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.XmlException;
import edu.udo.miningmart.m4.core.Case;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.core.M4Object;
import edu.udo.miningmart.m4.utils.CoordinatesContext;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class M4Xml {
    private static final boolean EXPORT_RELATIONAL = false;
    private static final HashMap xmlIds = new HashMap();
    private static long nextXmlId;
    private static Class[] M4_DATA_RELATIONAL_CLASSES;
    private static Class[] M4_DATA_SYSTEM_CLASSES;
    private static final HashMap xmlObjects;
    private static final HashMap xmlTagToClass;
    private static final String TAG_VERSION = "Version";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;

    static {
        Class[] classArray = new Class[7];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Column");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("edu.udo.miningmart.m4.core.ColumnsetStatistics");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("edu.udo.miningmart.m4.core.ColumnStatistics1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("edu.udo.miningmart.m4.core.ColumnStatistics2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("edu.udo.miningmart.m4.core.Key");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[5] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("edu.udo.miningmart.m4.core.KeyMember");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[6] = clazz7;
        M4_DATA_RELATIONAL_CLASSES = classArray;
        Class[] classArray2 = new Class[5];
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("edu.udo.miningmart.m4.core.Operator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz8;
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("edu.udo.miningmart.m4.core.Assertion");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz9;
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("edu.udo.miningmart.m4.core.Condition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[2] = clazz10;
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("edu.udo.miningmart.m4.core.Constraint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[3] = clazz11;
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("edu.udo.miningmart.m4.core.OpParam");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[4] = clazz12;
        M4_DATA_SYSTEM_CLASSES = classArray2;
        xmlObjects = new HashMap();
        xmlTagToClass = new HashMap();
    }

    public static Long getExistingXmlId(XmlInfo object) {
        return (Long)xmlIds.get(object);
    }

    public static long setNewXmlId(XmlInfo object) {
        long theId = nextXmlId++;
        xmlIds.put(object, new Long(theId));
        return theId;
    }

    public static synchronized void exportCase(Case m4Case, Writer writer) throws IOException {
        nextXmlId = 1L;
        String dataTag = "Data";
        writer.write(String.valueOf(M4Xml.createOpeningTag("Data")) + "\n");
        M4Xml.writeVersion(writer);
        HashSet<Case> open = new HashSet<Case>();
        open.add(m4Case);
        while (!open.isEmpty()) {
            Iterator it = ((AbstractList)new Vector(open)).iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof XmlInfo) {
                    M4Xml.export((XmlInfo)obj, writer, open);
                    open.remove(obj);
                    continue;
                }
                throw new IOException("Internal Error: Class " + obj.getClass().getName() + " found during M4Xml.exportCase(Case, writer),\n" + " which does not implement the interface XMlInfo!\n");
            }
        }
        writer.write(String.valueOf(M4Xml.createClosingTag("Data")) + "\n");
        writer.flush();
        writer.close();
        xmlIds.clear();
    }

    public static long export(XmlInfo m4d, Writer out, Collection dependent) throws IOException {
        if (m4d == null || out == null || dependent == null) {
            throw new IOException("<Null> parameter found in M4Xml.export(M4Data, Writer, Collection) !");
        }
        if (M4Xml.isRelationalObject(m4d)) {
            return 0L;
        }
        Long idL = M4Xml.getExistingXmlId(m4d);
        if (idL != null) {
            return idL;
        }
        long xmlId = M4Xml.setNewXmlId(m4d);
        Collection attribDescriptions = M4Xml.exportContainedObjects(m4d, out, dependent);
        if (M4Xml.isM4SystemObject(m4d)) {
            long m4Id = ((M4Data)((Object)m4d)).getId();
            attribDescriptions.clear();
            String m4IdXml = M4Xml.putInXmlTags(Long.toString(m4Id), "M4Id");
            attribDescriptions.add(m4IdXml);
        }
        String myTag = m4d.getObjectTag();
        String lev1Space = "  ";
        String lev2Space = "    ";
        out.write(String.valueOf(lev1Space) + M4Xml.createOpeningTag(myTag) + "\n");
        out.write(String.valueOf(lev2Space) + M4Xml.putInXmlTags(Long.toString(xmlId), "XmlId") + "\n");
        Iterator it = attribDescriptions.iterator();
        while (it.hasNext()) {
            String attribXml = (String)it.next();
            if (attribXml == null) continue;
            out.write(String.valueOf(lev2Space) + attribXml + "\n");
        }
        out.write(String.valueOf(lev1Space) + M4Xml.createClosingTag(myTag) + "\n");
        try {
            it = m4d.getDependentObjects().iterator();
            while (it.hasNext()) {
                XmlInfo xmli;
                Object obj = it.next();
                if (!(obj instanceof XmlInfo) || M4Xml.getExistingXmlId(xmli = (XmlInfo)obj) != null || M4Xml.isM4SystemObject(xmli)) continue;
                dependent.add(xmli);
            }
        }
        catch (M4Exception e) {
            m4d.doPrint(20, "Error when trying to receive the dependent objects of an " + m4d.getClass().getName() + "-object");
            if (m4d instanceof M4Object) {
                m4d.doPrint(20, "(ID: " + ((M4Object)((Object)m4d)).getId() + ")");
            }
            m4d.doPrint(20, "while trying to export that object.\nMessage was:\n");
            m4d.doPrint(e);
        }
        return xmlId;
    }

    private static boolean isRelationalObject(XmlInfo m4d) {
        int i = 0;
        while (i < M4_DATA_RELATIONAL_CLASSES.length) {
            if (M4_DATA_RELATIONAL_CLASSES[i].isInstance(m4d)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isM4SystemObject(XmlInfo m4d) {
        int i = 0;
        while (i < M4_DATA_SYSTEM_CLASSES.length) {
            if (M4_DATA_SYSTEM_CLASSES[i].isInstance(m4d)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Collection exportContainedObjects(XmlInfo m4d, Writer out, Collection dependent) throws IOException {
        M4Info m4i = m4d.getXmlInfo();
        Iterator it = m4i.getInfos().iterator();
        Vector<String> ret = new Vector<String>();
        String error = "\nError while exporting dependent objects of an object of class " + m4d.getClass().getName() + "!\nException message was:\n";
        while (it.hasNext()) {
            M4InfoEntry entry = (M4InfoEntry)it.next();
            try {
                String xmlDescription = M4Xml.createXmlDescription(m4d, entry, out, dependent);
                ret.add(xmlDescription);
            }
            catch (M4Exception e) {
                m4d.doPrint(20, String.valueOf(error) + e.getMessage() + "\n");
            }
        }
        try {
            Collection col = m4d.exportLocal(out, dependent);
            if (col != null) {
                ret.addAll(col);
            }
        }
        catch (M4Exception e) {
            m4d.doPrint(20, String.valueOf(error) + e.getMessage() + "\n");
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String createXmlDescription(XmlInfo m4o, M4InfoEntry entry, Writer out, Collection dependent) throws M4Exception, IOException {
        void var5_7;
        String value;
        Class objClass;
        Object object;
        block47: {
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        object = m4o.genericGetter(entry.getGetter());
                                        if (object == null) {
                                            return null;
                                        }
                                        objClass = entry.getTheObjectClass();
                                        Class<?> clazz = class$12;
                                        if (clazz == null) {
                                            try {
                                                clazz = class$12 = Class.forName("edu.udo.miningmart.m4.utils.XmlInfo");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz.isAssignableFrom(objClass) || object instanceof XmlInfo) {
                                            long objId = M4Xml.export((XmlInfo)object, out, dependent);
                                            if (objId == 0L) {
                                                return null;
                                            }
                                            value = M4Xml.putInXmlTags(Long.toString(objId), "XmlId");
                                            return M4Xml.putInXmlTags((String)var5_7, entry.getDbAttribute());
                                        }
                                        Class<?> clazz2 = class$13;
                                        if (clazz2 == null) {
                                            try {
                                                clazz2 = class$13 = Class.forName("java.lang.String");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (objClass.equals(clazz2)) {
                                            value = M4Xml.putInXmlTags(M4Xml.escapeXmlString((String)object), "String");
                                            return M4Xml.putInXmlTags((String)var5_7, entry.getDbAttribute());
                                        }
                                        if (objClass.equals(Long.TYPE)) break block40;
                                        Class<?> clazz3 = class$15;
                                        if (clazz3 == null) {
                                            try {
                                                clazz3 = class$15 = Class.forName("java.lang.Long");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (!objClass.equals(clazz3)) break block41;
                                    }
                                    value = M4Xml.putInXmlTags(((Long)object).toString(), "Long");
                                    return M4Xml.putInXmlTags((String)var5_7, entry.getDbAttribute());
                                }
                                if (objClass.equals(Integer.TYPE)) break block42;
                                Class<?> clazz = class$17;
                                if (clazz == null) {
                                    try {
                                        clazz = class$17 = Class.forName("java.lang.Integer");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (!objClass.equals(clazz)) break block43;
                            }
                            value = M4Xml.putInXmlTags(((Integer)object).toString(), "Integer");
                            return M4Xml.putInXmlTags((String)var5_7, entry.getDbAttribute());
                        }
                        if (objClass.equals(Short.TYPE)) break block44;
                        Class<?> clazz = class$19;
                        if (clazz == null) {
                            try {
                                clazz = class$19 = Class.forName("java.lang.Short");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!objClass.equals(clazz)) break block45;
                    }
                    value = M4Xml.putInXmlTags(((Short)object).toString(), "Short");
                    return M4Xml.putInXmlTags((String)var5_7, entry.getDbAttribute());
                }
                if (objClass.equals(Double.TYPE)) break block46;
                Class<?> clazz = class$21;
                if (clazz == null) {
                    try {
                        clazz = class$21 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!objClass.equals(clazz)) break block47;
            }
            value = M4Xml.putInXmlTags(((Double)object).toString(), "Double");
            return M4Xml.putInXmlTags((String)var5_7, entry.getDbAttribute());
        }
        Class<?> clazz = class$22;
        if (clazz == null) {
            try {
                clazz = class$22 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!objClass.equals(clazz)) throw new M4Exception("Unsupported object type in M4InfoEntry for attribute " + entry.getDbAttribute() + " found: " + objClass.getName() + "\nClass to be exported is " + m4o.getClass().getName());
        value = M4Xml.serializeM4DataCollection((Collection)object, out, dependent);
        if (value != null) return M4Xml.putInXmlTags((String)var5_7, entry.getDbAttribute());
        return null;
    }

    public static String serializeM4DataCollection(Collection col, Writer out, Collection dependent) throws M4Exception, IOException {
        if (col == null || col.isEmpty()) {
            return null;
        }
        Iterator it = col.iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            Object m4d = it.next();
            if (m4d instanceof XmlInfo) {
                long xmlId = M4Xml.export((XmlInfo)m4d, out, dependent);
                if (xmlId == 0L) continue;
                String xmlTag = M4Xml.putInXmlTags(Long.toString(xmlId), "XmlId");
                buf.append(xmlTag);
                continue;
            }
            throw new M4Exception("Found class not implementing XmlInfo in Collection for static method M4Xml.serializeM4DataCollection(Collection, Writer, Collection)!\nClass was: " + m4d.getClass().getName() + "\n");
        }
        return M4Xml.putInXmlTags(buf.toString(), "Collection");
    }

    public static String putInXmlTags(String text, String xmlTag) {
        if (text == null) {
            text = "";
        }
        return String.valueOf(M4Xml.createOpeningTag(xmlTag)) + text + M4Xml.createClosingTag(xmlTag);
    }

    public static String createOpeningTag(String tagName) {
        if (tagName == null) {
            tagName = "";
        }
        return "<" + tagName.trim() + ">";
    }

    public static String createClosingTag(String tagName) {
        if (tagName == null) {
            tagName = "";
        }
        return "</" + tagName.trim() + ">";
    }

    private static XmlInfo getXmlObject(Long xmlId) {
        return (XmlInfo)xmlObjects.get(xmlId);
    }

    private static void storeXmlObject(Long xmlId, XmlInfo object) {
        xmlObjects.put(xmlId, object);
    }

    public static synchronized Case importCase(InputStream in, DB db, String xmlVersion) throws IOException, XmlException, M4Exception {
        db.clearM4Cache();
        nextXmlId = 100000L;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
        Case m4case = null;
        String line = M4Xml.skipDataAndVersion(reader, xmlVersion);
        String tag = null;
        do {
            String[] tlt;
            if ((tlt = M4Xml.findTopLevelTag(line, reader)) == null) continue;
            tag = tlt[0];
            String embedded = tlt[1];
            line = tlt[2];
            if (tag.equals("")) {
                tag = null;
                continue;
            }
            Class<?> classObj = (Class<?>)xmlTagToClass.get(tag = tag.trim());
            if (classObj == null) {
                try {
                    String className = tag.equals(CoordinatesContext.TAG_MAIN) ? "edu.udo.miningmart.m4.utils.CoordinatesContext" : "edu.udo.miningmart.m4.core." + tag;
                    classObj = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new XmlException("Unknown tag! Could not find a class matching the XML tag " + tag + "!");
                }
                xmlTagToClass.put(tag, classObj);
                Class<?> clazz = class$12;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("edu.udo.miningmart.m4.utils.XmlInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(classObj)) {
                    throw new XmlException("Found an incompatible Class in method importCase(InputStream, DB)!\nClass found according to tag in InputStream is " + classObj.getName() + ", but this class does not implement the XmlInfo interface!\n");
                }
            }
            XmlInfo object = (XmlInfo)((Object)db.createNewInstance(classObj));
            object.doPrint(2, "\nImporting " + classObj.getName() + ":\n" + embedded + "\n");
            Long xmlId = M4Xml.xmlImport(object, embedded);
            if (xmlId == null) {
                throw new XmlException("The following object description for a " + tag + " does not contain the mandatory tag " + "XmlId" + "!");
            }
            if (!(object instanceof Case)) continue;
            if (m4case != null) {
                throw new XmlException("M4Xml.importCase(InputStream, DB, String):\nFound multiple cases in the specified export file!\nName of the first is: " + m4case.getName() + "\nName of the second is: " + ((Case)object).getName() + "\n");
            }
            m4case = (Case)object;
        } while (tag != null);
        reader.close();
        xmlIds.clear();
        if (m4case == null) {
            throw new XmlException("M4Xml.importCase(InputStream, DB, String):\nNo case found in the specified export file!\n");
        }
        return m4case;
    }

    private static String skipDataAndVersion(LineNumberReader reader, String xmlVersion) throws IOException, XmlException {
        String line = "";
        int index = -1;
        while (line != null && index == -1) {
            line = reader.readLine();
            int n = index = line == null ? -1 : line.toLowerCase().indexOf("<data>");
        }
        if (line == null) {
            throw new XmlException("Found <EOF> but no XML data in import file!");
        }
        if ((line = line.substring(index + "<data>".length())).indexOf("</data>") != -1) {
            throw new XmlException("Found closing data tag before any data in XML import file!");
        }
        return M4Xml.checkVersion(reader, xmlVersion, line);
    }

    private static void writeVersion(Writer writer) throws IOException {
        String versionTag = M4Xml.putInXmlTags("M4-XML V0.5", TAG_VERSION);
        String versionText = "  " + versionTag + "\n";
        writer.write(versionText);
    }

    private static String checkVersion(LineNumberReader reader, String version, String line) throws IOException, XmlException {
        String[] tagInfo = M4Xml.findTopLevelTag(line, reader);
        if (tagInfo == null) {
            throw new XmlException("Could not find version information in XML input file!");
        }
        if (!tagInfo[0].equals(TAG_VERSION)) {
            throw new XmlException("Corrupted version information in XML input file! Expected tag 'Version', but found '" + tagInfo[0] + "'!");
        }
        String versionInfoFromFile = tagInfo[1].trim();
        if (!versionInfoFromFile.equals(version)) {
            throw new XmlException("Import file was created with XML version " + versionInfoFromFile + ", but expected was " + version + "!");
        }
        return reader.readLine();
    }

    private static String[] findTopLevelTag(String line, LineNumberReader reader) throws IOException {
        int startIndex = line == null ? -1 : line.indexOf("<");
        while (line != null && startIndex == -1) {
            line = reader.readLine();
            int n = startIndex = line == null ? -1 : line.indexOf("<");
        }
        if (line == null) {
            return null;
        }
        line = line.substring(startIndex);
        String[] ret = new String[3];
        int tagEnd = line.indexOf(">");
        if (tagEnd == -1) {
            return null;
        }
        String tag = line.substring(1, tagEnd);
        if (tag.equalsIgnoreCase("/data")) {
            ret[0] = "";
            return ret;
        }
        line = line.substring(tagEnd + 1);
        String closeTag = "</" + tag + ">";
        StringBuffer buf = new StringBuffer();
        int endIndex = line == null ? -1 : line.indexOf(closeTag);
        while (line != null && endIndex == -1) {
            buf.append(String.valueOf(line) + "\n");
            line = reader.readLine();
            int n = endIndex = line == null ? -1 : line.indexOf(closeTag);
        }
        if (line == null) {
            return null;
        }
        buf.append(line.substring(0, endIndex));
        line = line.substring(endIndex + closeTag.length());
        ret[0] = tag;
        ret[1] = buf.toString();
        ret[2] = line;
        return ret;
    }

    public static Long xmlImport(XmlInfo m4d, String description) throws M4Exception, XmlException {
        String[] array;
        M4Info m4Info = m4d.getXmlInfo();
        Long xmlId = null;
        while ((array = M4Xml.stripOuterTag(description)) != null) {
            String tag = array[0];
            String embedded = array[1];
            description = array[2];
            M4InfoEntry entry = m4Info.getInfo(tag);
            if (entry == null) {
                if (tag.equals("XmlId")) {
                    xmlId = (Long)M4Xml.createObjectFromXml("Long", embedded);
                    M4Xml.storeXmlObject(xmlId, m4d);
                    continue;
                }
                if (tag.equals("M4Id")) {
                    if (!(m4d instanceof M4Data)) {
                        throw new XmlException("Found tag " + tag + " with '" + embedded + "' as the embedded String.\n" + "Problem: The class representing " + tag + " is no sub-class of M4Data,\n" + "so we don't know how to load it from an M4 table!");
                    }
                    Long m4Id = (Long)M4Xml.createObjectFromXml("Long", embedded);
                    if (m4Id == null || m4Id == 0L) {
                        throw new XmlException(tag, embedded);
                    }
                    ((M4Data)((Object)m4d)).load(m4Id);
                    return xmlId;
                }
                m4d.importLocal(tag, embedded);
                continue;
            }
            String[] innerArray = M4Xml.stripOuterTag(embedded);
            if (innerArray == null) {
                throw new XmlException("Found no information for " + tag + " in embedded description:\n" + embedded + "\n");
            }
            String innerTag = innerArray[0];
            String innerEmb = innerArray[1];
            Object object = M4Xml.createObjectFromXml(innerTag, innerEmb);
            String setter = entry.getSetter();
            Class objClass = entry.getTheObjectClass();
            m4d.genericSetter(setter, objClass, object);
        }
        return xmlId;
    }

    public static String[] stripOuterTag(String xml) {
        if (xml == null) {
            return null;
        }
        int index = xml.indexOf(60);
        if (index != -1 && (index = (xml = xml.substring(index + 1)).indexOf(62)) != -1) {
            String closingTag;
            String tag = xml.substring(0, index);
            if ((index = (xml = xml.substring(index + 1)).indexOf(closingTag = "</" + tag + ">")) != -1) {
                String embedded = xml.substring(0, index);
                String rest = xml.substring(index + closingTag.length());
                String[] ret = new String[]{tag, embedded, rest.trim()};
                return ret;
            }
        }
        return null;
    }

    public static Object createObjectFromXml(String tag, String embedded) throws XmlException {
        if (tag == null || embedded == null) {
            throw new XmlException("Null argument found in createObjectFromXml(String tag, String embedded)!");
        }
        if (tag.equals("XmlId")) {
            Long xmlId = (Long)M4Xml.createObjectFromXml("Long", embedded);
            return M4Xml.getXmlObject(xmlId);
        }
        if (tag.equals("Collection")) {
            String[] array;
            Vector<Object> ret = new Vector<Object>();
            while ((array = M4Xml.stripOuterTag(embedded)) != null) {
                String innerTag = array[0];
                String innerEmb = array[1];
                embedded = array[2];
                Object obj = M4Xml.createObjectFromXml(innerTag, innerEmb);
                if (obj == null) continue;
                ret.add(obj);
            }
            return ret;
        }
        if (tag.equals("String")) {
            return M4Xml.unEscapeXmlString(embedded);
        }
        embedded = embedded.trim();
        if (tag.equals("Long")) {
            return new Long(embedded);
        }
        if (tag.equals("Integer")) {
            return new Integer(embedded);
        }
        if (tag.equals("Short")) {
            return new Short(embedded);
        }
        throw new XmlException(tag, embedded);
    }

    private static String escapeXmlString(String text) {
        StringBuffer sbuf = new StringBuffer();
        while (text != null && text.length() > 0) {
            int index = M4Xml.min(text.indexOf(60), text.indexOf(62), text.indexOf(38));
            if (index > -1) {
                String replaceWith;
                char c = text.charAt(index);
                switch (c) {
                    case '<': {
                        replaceWith = "&lt;";
                        break;
                    }
                    case '>': {
                        replaceWith = "&gt;";
                        break;
                    }
                    default: {
                        replaceWith = "&amp;";
                    }
                }
                sbuf.append(text.substring(0, index));
                sbuf.append(replaceWith);
                text = text.substring(index + 1);
                continue;
            }
            sbuf.append(text);
            text = null;
        }
        return sbuf.toString();
    }

    private static String unEscapeXmlString(String text) {
        StringBuffer sbuf = new StringBuffer();
        while (text != null && text.length() > 0) {
            int index = M4Xml.min(text.indexOf("&lt;"), text.indexOf("&gt;"), text.indexOf("&amp;"));
            if (index > -1) {
                char replaceWith;
                char c = text.charAt(index + 1);
                switch (c) {
                    case 'l': {
                        replaceWith = '<';
                        break;
                    }
                    case 'g': {
                        replaceWith = '>';
                        break;
                    }
                    default: {
                        replaceWith = '&';
                    }
                }
                sbuf.append(text.substring(0, index));
                sbuf.append(replaceWith);
                index = text.indexOf(59, index) + 1;
                text = text.substring(index);
                continue;
            }
            sbuf.append(text);
            text = null;
        }
        return sbuf.toString();
    }

    private static int min(int a, int b, int c) {
        int minab = a < b || b == -1 ? a : b;
        return minab < c || c == -1 ? minab : c;
    }
}

