/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.utils;

import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.M4NameExistsException;
import edu.udo.miningmart.m4.core.M4Object;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class InterM4Communicator {
    abstract Object getSingleRef(M4Object var1) throws M4Exception;

    abstract Collection getCollection(Object var1) throws M4Exception;

    abstract void setSingleRefPrimitive(M4Object var1, Object var2) throws M4Exception;

    public void add(Object container, M4Object m4o) throws M4Exception {
        if (m4o == null || container == null) {
            return;
        }
        this.updateReferenceTo(m4o, container);
    }

    public boolean remove(Object container, M4Object m4o) throws M4Exception {
        if (m4o == null || container == null) {
            return false;
        }
        if (this.getSingleRef(m4o) == container) {
            this.updateReferenceTo(m4o, null);
            return true;
        }
        Collection collection = this.getCollection(container);
        if (collection != null) {
            return collection.remove(m4o);
        }
        return false;
    }

    public void setCollectionTo(Object container, Collection collection) throws M4Exception {
        Iterator it;
        Collection oldCollection = this.getCollection(container);
        if (collection == oldCollection) {
            return;
        }
        if (oldCollection != null) {
            it = ((AbstractList)new Vector(oldCollection)).iterator();
            while (it.hasNext()) {
                this.remove(container, (M4Object)it.next());
            }
        }
        if (collection != null) {
            it = ((AbstractList)new Vector(collection)).iterator();
            while (it.hasNext()) {
                this.updateReferenceTo((M4Object)it.next(), container);
            }
        }
    }

    public void updateReferenceTo(M4Object m4o, Object container) throws M4Exception {
        Collection m4oCol;
        Collection oldRefCol;
        if (m4o == null) {
            return;
        }
        Object oldRef = this.getSingleRef(m4o);
        if (oldRef == container) {
            if (container != null) {
                Collection theCollection = this.getCollection(container);
                if (theCollection == null) {
                    throw new M4Exception("A container object of type " + container.getClass().getName() + "had a <null> reference to its Collection, although there was " + "a valid back-reference from a " + m4o.getClass().getName() + "-object !!\n" + "This problem could be shipped around by InterM4Communicator, " + "bit you should rather init the Collection from the beginning " + "with a 'final' field modifier!");
                }
                if (!theCollection.contains(m4o)) {
                    theCollection.add(m4o);
                }
            }
            return;
        }
        if (oldRef != null && (oldRefCol = this.getCollection(oldRef)) != null) {
            oldRefCol.remove(m4o);
        }
        if (m4o != null && container != null && (m4oCol = this.getCollection(container)) != null) {
            m4oCol.add(m4o);
        }
        this.setSingleRefPrimitive(m4o, container);
    }

    public void checkNameExists(M4Object m4o, Object container) throws M4Exception {
        if (container == null) {
            return;
        }
        Collection collection = this.getCollection(container);
        if (m4o == null || collection == null || collection.size() == 0 || collection.contains(m4o)) {
            return;
        }
        String m4oName = m4o.getName();
        if (m4oName != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                M4Object element = (M4Object)it.next();
                if (element == null || element == m4o || !m4oName.equals(element.getName())) continue;
                throw new M4NameExistsException("Found an M4Object with name " + m4oName + " in the given container object of type " + container.getClass().getName() + "!");
            }
        }
    }
}

