/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.hciImpl;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Value;
import edu.udo.miningmart.m4.hciImpl.DomainDatatypeImpl;
import edu.udo.miningmart.m4.hciImpl.ParameterImpl;
import java.util.Collection;
import java.util.Iterator;
import miningmart.m4.Parameter;
import miningmart.m4.Step;
import miningmart.m4.StorageException;

public class ValueImpl
extends Value
implements miningmart.m4.Value {
    public ValueImpl(DB db) {
        super(db);
    }

    public String getDatatype() {
        long type = super.getType();
        int conDtId = (int)type;
        return DomainDatatypeImpl.getDatatypeNameForId(conDtId);
    }

    public void setDatatype(String datatype) {
        int conDtId = DomainDatatypeImpl.getIdForDatatypeName(datatype);
        super.setType(conDtId);
    }

    public void addParameter(Parameter parameter) throws StorageException {
        try {
            super.addParameterReference((ParameterImpl)parameter);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public Parameter getParameter(String stepName, String parameterName) {
        Collection col;
        try {
            col = super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
        if (col == null || stepName == null || parameterName == null) {
            return null;
        }
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Parameter par = (Parameter)it.next();
            if (par == null) continue;
            String parName = par.getParameterName();
            Step step = par.getStep();
            if (step == null || !stepName.equals(step.getName()) || !parameterName.equals(parName)) continue;
            return par;
        }
        return null;
    }

    public Collection getAllParameters() {
        try {
            return super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public void removeParameter(String stepName, String parameterName) throws StorageException {
        Parameter par = this.getParameter(stepName, parameterName);
        try {
            super.removeParameterReference((ParameterImpl)par);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void removeAllParameters() throws StorageException {
        Collection params = this.getAllParameters();
        if (params == null) {
            return;
        }
        Iterator it = params.iterator();
        while (it.hasNext()) {
            ParameterImpl parImpl = (ParameterImpl)it.next();
            try {
                super.removeParameterReference(parImpl);
            }
            catch (M4Exception e) {
                throw new StorageException(e.getMessage());
            }
        }
    }

    public void setDocumentation(String text) {
        try {
            super.setDocumentation(text);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public String getDocumentation() {
        try {
            return super.getDocumentation();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public void delete() throws StorageException {
        try {
            super.deleteSoon();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void store() throws StorageException {
        try {
            super.getM4Db().updateDatabase();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public boolean isChanged() {
        return super.isDirty();
    }
}

