/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.hciImpl;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.hciImpl.AssertionImpl;
import edu.udo.miningmart.m4.hciImpl.ConditionImpl;
import edu.udo.miningmart.m4.hciImpl.ConstraintImpl;
import edu.udo.miningmart.m4.hciImpl.OperatorParameterImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import miningmart.m4.Assertion;
import miningmart.m4.Condition;
import miningmart.m4.Constraint;
import miningmart.m4.CreateException;
import miningmart.m4.NameExistsException;
import miningmart.m4.Operator;
import miningmart.m4.OperatorParameter;
import miningmart.m4.StorageException;

public class OperatorImpl
extends edu.udo.miningmart.m4.core.Operator
implements Operator {
    public OperatorImpl(DB db) {
        super(db);
    }

    public boolean isMultiStepable() {
        return super.isStepable();
    }

    public void setMultiStepable(boolean multiStepable) {
        super.setStepable(multiStepable);
    }

    public String getRealizes() {
        return super.getRealize();
    }

    public void setRealizes(String realizes) {
        super.setRealize(realizes);
    }

    public Assertion createAssertion(String type, String object1, String object2, String text) throws CreateException {
        AssertionImpl assertion = new AssertionImpl(this.getM4Db());
        assertion.setAssertionType(type);
        assertion.setObject1(object1);
        assertion.setObject2(object2);
        assertion.setShortDescription(text);
        try {
            this.addAssertion(assertion);
        }
        catch (M4Exception e) {
            throw new CreateException("Could not add new assertion (" + type + ", " + object1 + ", " + object2 + ", " + text + ") to operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
        return assertion;
    }

    public Collection getAllAssertions() {
        try {
            return super.getAssertions();
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public Collection getAssertionsByType(String type) {
        Collection col = this.getAllAssertions();
        Vector<Assertion> result = new Vector<Assertion>();
        if (col != null && type != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Assertion assertion = (Assertion)it.next();
                if (assertion == null || !type.equals(assertion.getAssertionType())) continue;
                result.add(assertion);
            }
        }
        return result;
    }

    public void removeAllAssertions() throws StorageException {
        Collection col = this.getAllAssertions();
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                AssertionImpl assertion = (AssertionImpl)it.next();
                this.removeAssertionByAssertion(assertion);
            }
        }
    }

    public void removeAssertionsByType(String type) throws StorageException {
        Collection col = this.getAssertionsByType(type);
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                AssertionImpl assertion = (AssertionImpl)it.next();
                this.removeAssertionByAssertion(assertion);
            }
        }
    }

    private void removeAssertionByAssertion(AssertionImpl assertion) throws StorageException {
        try {
            super.removeAssertion(assertion);
        }
        catch (M4Exception e) {
            throw new StorageException("Could not remove all assertions from operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
    }

    public Condition createCondition(String type, String object1, String object2, String text) throws CreateException {
        ConditionImpl condition = new ConditionImpl(this.getM4Db());
        condition.setConditionType(type);
        condition.setObject1(object1);
        condition.setObject2(object2);
        condition.setShortDescription(text);
        try {
            this.addCondition(condition);
        }
        catch (M4Exception e) {
            throw new CreateException("Could not add new condition (" + type + ", " + object1 + ", " + object2 + ", " + text + ") to operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
        return condition;
    }

    public Collection getAllConditions() {
        try {
            return super.getConditions();
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public Collection getConditionsByType(String type) {
        Collection col = this.getAllConditions();
        Vector<Condition> result = new Vector<Condition>();
        if (col != null && type != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Condition condition = (Condition)it.next();
                if (condition == null || !type.equals(condition.getConditionType())) continue;
                result.add(condition);
            }
        }
        return result;
    }

    public void removeAllConditions() throws StorageException {
        Collection col = this.getAllConditions();
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                ConditionImpl condition = (ConditionImpl)it.next();
                this.removeConditionByCondition(condition);
            }
        }
    }

    public void removeConditionsByType(String type) throws StorageException {
        Collection col = this.getConditionsByType(type);
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                ConditionImpl condition = (ConditionImpl)it.next();
                this.removeConditionByCondition(condition);
            }
        }
    }

    private void removeConditionByCondition(ConditionImpl condition) throws StorageException {
        try {
            super.removeCondition(condition);
        }
        catch (M4Exception e) {
            throw new StorageException("Could not remove all conditions from operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
    }

    public Constraint createConstraint(String type, String object1, String object2, String text) throws CreateException {
        ConstraintImpl constraint = new ConstraintImpl(this.getM4Db());
        constraint.setConstraintType(type);
        constraint.setObject1(object1);
        constraint.setObject2(object2);
        constraint.setShortDescription(text);
        try {
            this.addConstraint(constraint);
        }
        catch (M4Exception e) {
            throw new CreateException("Could not add new constraint (" + type + ", " + object1 + ", " + object2 + ", " + text + ") to operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
        return constraint;
    }

    public Collection getAllConstraints() {
        try {
            return super.getConstraints();
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public Collection getConstraintsByType(String type) {
        Collection col = this.getAllConstraints();
        Vector<Constraint> result = new Vector<Constraint>();
        if (col != null && type != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Constraint constraint = (Constraint)it.next();
                if (constraint == null || !type.equals(constraint.getConstraintType())) continue;
                result.add(constraint);
            }
        }
        return result;
    }

    public void removeAllConstraints() throws StorageException {
        Collection col = this.getAllConstraints();
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                ConstraintImpl constraint = (ConstraintImpl)it.next();
                this.removeConstraintByConstraint(constraint);
            }
        }
    }

    public void removeConstraintsByType(String type) throws StorageException {
        Collection col = this.getConstraintsByType(type);
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                ConstraintImpl constraint = (ConstraintImpl)it.next();
                this.removeConstraintByConstraint(constraint);
            }
        }
    }

    private void removeConstraintByConstraint(ConstraintImpl constraint) throws StorageException {
        try {
            super.removeConstraint(constraint);
        }
        catch (M4Exception e) {
            throw new StorageException("Could not remove all constraints from operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
    }

    public OperatorParameter createOperatorParameter(String name, int minNrOfArgs, int maxNrOfArgs, String ioType, String parameterType, String text) throws CreateException, NameExistsException {
        OperatorParameterImpl opParam = new OperatorParameterImpl(this.getM4Db());
        opParam.setName(name);
        opParam.setMinNrOfArgs(minNrOfArgs);
        opParam.setMaxNrOfArgs(maxNrOfArgs);
        opParam.setIoType(ioType);
        opParam.setParameterType(parameterType);
        opParam.setShortDescription(text);
        try {
            this.addOpParam(opParam);
        }
        catch (M4Exception e) {
            throw new CreateException("Could not add new OperatorParameter (" + name + ", " + minNrOfArgs + ", " + maxNrOfArgs + ", " + ioType + ", " + parameterType + ", " + text + ") to operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
        return opParam;
    }

    public OperatorParameter getOperatorParameter(String name) {
        Iterator it = null;
        try {
            it = super.getOpParamsIterator();
            if (it != null && name != null) {
                while (it.hasNext()) {
                    OperatorParameter opParam = (OperatorParameter)it.next();
                    if (opParam == null || !name.equals(opParam.getName())) continue;
                    return opParam;
                }
            }
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
        return null;
    }

    public Collection getAllOperatorParameters() {
        try {
            return super.getOpParams();
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public Collection getAllInputOperatorParameters() {
        Iterator it = null;
        try {
            it = super.getOpParamsIterator();
            if (it != null) {
                Vector<OperatorParameterImpl> results = new Vector<OperatorParameterImpl>();
                while (it.hasNext()) {
                    OperatorParameterImpl opParam = (OperatorParameterImpl)it.next();
                    if (opParam == null || !opParam.isInput()) continue;
                    results.add(opParam);
                }
                return results;
            }
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
        return null;
    }

    public Collection getAllOutputOperatorParameters() {
        Iterator it = null;
        try {
            it = super.getOpParamsIterator();
            if (it != null) {
                Vector<OperatorParameterImpl> results = new Vector<OperatorParameterImpl>();
                while (it.hasNext()) {
                    OperatorParameterImpl opParam = (OperatorParameterImpl)it.next();
                    if (opParam == null || opParam.isInput()) continue;
                    results.add(opParam);
                }
                return results;
            }
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
        return null;
    }

    public Collection getOperatorParametersByType(String type) {
        Iterator it = null;
        try {
            it = super.getOpParamsIterator();
            if (it != null && type != null) {
                Vector<OperatorParameter> results = new Vector<OperatorParameter>();
                while (it.hasNext()) {
                    OperatorParameter opParam = (OperatorParameter)it.next();
                    if (opParam == null || !type.equals(opParam.getParameterType())) continue;
                    results.add(opParam);
                }
                return results;
            }
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
        return null;
    }

    public void removeOperatorParameter(String name) throws StorageException {
        OperatorParameterImpl opParam = (OperatorParameterImpl)this.getOperatorParameter(name);
        if (opParam != null) {
            this.removeOpParByOpPar(opParam);
        }
    }

    public void removeAllOperatorParameters() throws StorageException {
        Collection col = this.getAllOperatorParameters();
        if (col == null) {
            return;
        }
        Iterator it = col.iterator();
        while (it.hasNext()) {
            OperatorParameterImpl opPar = (OperatorParameterImpl)it.next();
            this.removeOpParByOpPar(opPar);
        }
    }

    public void removeOperatorParameterByType(String type) throws StorageException {
        Collection col = this.getOperatorParametersByType(type);
        if (col == null) {
            return;
        }
        Iterator it = col.iterator();
        while (it.hasNext()) {
            OperatorParameterImpl opPar = (OperatorParameterImpl)it.next();
            this.removeOpParByOpPar(opPar);
        }
    }

    private void removeOpParByOpPar(OperatorParameterImpl opPar) throws StorageException {
        try {
            super.removeOpParam(opPar);
        }
        catch (M4Exception e) {
            super.doPrint(e);
            throw new StorageException(e.getMessage());
        }
    }

    public void setDocumentation(String text) {
        try {
            super.setDocumentation(text);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public String getDocumentation() {
        try {
            return super.getDocumentation();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public void delete() throws StorageException {
        try {
            super.deleteSoon();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void store() throws StorageException {
        try {
            super.getM4Db().updateDatabase();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public boolean isChanged() {
        return super.isDirty();
    }
}

