/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.hciImpl;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.hciImpl.ColumnImpl;
import edu.udo.miningmart.m4.hciImpl.ColumnSetStatisticsImpl;
import edu.udo.miningmart.m4.hciImpl.ConceptImpl;
import edu.udo.miningmart.m4.hciImpl.ForeignKeyImpl;
import edu.udo.miningmart.m4.hciImpl.PrimaryKeyImpl;
import edu.udo.miningmart.m4.hciImpl.RelationshipImpl;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.ColumnSetStatistics;
import miningmart.m4.Concept;
import miningmart.m4.CreateException;
import miningmart.m4.ForeignKey;
import miningmart.m4.NameExistsException;
import miningmart.m4.PrimaryKey;
import miningmart.m4.Relationship;
import miningmart.m4.StorageException;

public class ColumnsetImpl
extends Columnset
implements ColumnSet {
    private Vector myForeignKeys;
    private PrimaryKey myPrimaryKey;

    public ColumnsetImpl(DB db) {
        super(db);
    }

    public String getFile() {
        return null;
    }

    public void setFile(String file) {
    }

    public String getUser() {
        return null;
    }

    public void setUser(String user) {
    }

    public String getConnectString() {
        return null;
    }

    public void setConnectString(String connectString) {
    }

    public String getColumnSetType() {
        return super.getType();
    }

    public void setColumnSetType(String columnSetType) {
        try {
            super.setType(columnSetType);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public String getSqlString() {
        return super.getSQLDefinition();
    }

    public void setSqlString(String sqlString) {
        super.setSQLDefinition(sqlString);
    }

    public Column createColumn(String name, String datatype) throws CreateException, NameExistsException {
        if (name == null || datatype == null) {
            throw new CreateException("ColumnsetImpl.createColumn: got <null> for name or datatype!");
        }
        ColumnImpl newColumn = new ColumnImpl(this.getM4Db());
        try {
            newColumn.setColumnDatatype(datatype);
            newColumn.setName(name);
            newColumn.setColumnSet(this);
        }
        catch (StorageException se) {
            throw new CreateException("Could not create Column for Columnset " + this.getId() + ": " + se.getMessage());
        }
        return newColumn;
    }

    public void addColumn(Column col) {
        try {
            super.addColumn((ColumnImpl)col);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public void setConcept(Concept con) {
        try {
            super.setTheConcept((ConceptImpl)con);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public Column getColumn(String name) {
        Collection columns = this.getAllColumns();
        if (name != null && columns != null) {
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column col = (Column)it.next();
                if (col == null || !name.equals(col.getName())) continue;
                return col;
            }
        }
        return null;
    }

    public Collection getAllColumns() {
        try {
            return super.getColumns();
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public void removeColumn(String name) throws StorageException {
        Column col = this.getColumn(name);
        if (col != null) {
            try {
                super.removeColumn((ColumnImpl)col);
            }
            catch (M4Exception e) {
                super.doPrint(e);
            }
        }
    }

    public void removeAllColumns() throws StorageException {
        try {
            super.setColumns(new Vector());
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public Concept getConcept() {
        return (ConceptImpl)super.getTheConcept();
    }

    public ColumnSetStatistics createColumnSetStatistics() throws CreateException {
        ColumnSetStatisticsImpl theCSS = new ColumnSetStatisticsImpl(this.getM4Db());
        try {
            theCSS.setColumnSet(this);
        }
        catch (StorageException se) {
            throw new CreateException("Could not create Statistics object for Columnset " + this.getId() + ": " + se.getMessage());
        }
        try {
            theCSS.setNrOfNominalAttributes(super.getStatisticsNominal());
            theCSS.setNrOfOrdinalAttributes(super.getStatisticsOrdinal());
            theCSS.setNrOfRows(super.getStatisticsAll());
            theCSS.setNrOfTimeAttributes(super.getStatisticsTime());
        }
        catch (M4Exception e) {
            throw new CreateException("Could not load statistics:\n" + e.getMessage());
        }
        return theCSS;
    }

    public ColumnSetStatistics getColumnSetStatistics() {
        try {
            return this.createColumnSetStatistics();
        }
        catch (CreateException ce) {
            super.doPrint(ce);
            return null;
        }
    }

    public void setColumnSetStatistics(ColumnSetStatistics columnSetStatistics) throws StorageException {
        try {
            super.setStatisticsAll(columnSetStatistics.getNrOfRows());
            super.setStatisticsNominal(columnSetStatistics.getNrOfNominalAttributes());
            super.setStatisticsOrdinal(columnSetStatistics.getNrOfOrdinalAttributes());
            super.setStatisticsTime(columnSetStatistics.getNrOfTimeAttributes());
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void removeColumnSetStatistics() throws StorageException {
    }

    public Relationship getRelationship() {
        return (RelationshipImpl)super.getRelation();
    }

    public void setRelationship(Relationship relationship) throws StorageException {
        try {
            RelationshipImpl rel = (RelationshipImpl)relationship;
            super.setRelation(rel);
        }
        catch (M4Exception m4e) {
            throw new StorageException(m4e.getMessage());
        }
    }

    public ForeignKey createForeignKey(String name) throws CreateException, NameExistsException {
        if (name == null) {
            throw new CreateException("ColumnsetImpl.createForeignKey: got <null> as a name!");
        }
        if (this.myForeignKeys == null) {
            this.myForeignKeys = new Vector();
        }
        Iterator it = ((AbstractList)this.myForeignKeys).iterator();
        while (it.hasNext()) {
            ForeignKey fk = (ForeignKey)it.next();
            if (!fk.getName().equals(name)) continue;
            throw new NameExistsException("ColumnsetImpl.createForeignKey: a foreign key with the given name '" + name + "' exists already!");
        }
        ForeignKeyImpl newFK = new ForeignKeyImpl(this.getM4Db());
        try {
            newFK.setColumnSet(this);
        }
        catch (StorageException se) {
            throw new CreateException("Could not link new ForeignKey '" + name + "' to Columnset " + this.getId() + ": " + se.getMessage());
        }
        newFK.setName(name);
        return newFK;
    }

    public ForeignKey getForeignKey(String name) {
        if (this.myForeignKeys == null) {
            return null;
        }
        Iterator it = ((AbstractList)this.myForeignKeys).iterator();
        while (it.hasNext()) {
            ForeignKey fk = (ForeignKey)it.next();
            if (!fk.getName().equals(name)) continue;
            return fk;
        }
        return null;
    }

    public void addForeignKey(ForeignKey fk) {
        if (this.myForeignKeys == null) {
            this.myForeignKeys = new Vector();
        }
        this.myForeignKeys.add(fk);
    }

    public Collection getAllForeignKeys() {
        return this.myForeignKeys;
    }

    public void removeForeignKey(String name) throws StorageException {
        if (this.myForeignKeys == null) {
            return;
        }
        Vector<ForeignKey> newFKeys = new Vector<ForeignKey>();
        Iterator it = ((AbstractList)this.myForeignKeys).iterator();
        while (it.hasNext()) {
            ForeignKey fk = (ForeignKey)it.next();
            if (fk.getName().equals(name)) continue;
            newFKeys.add(fk);
        }
        if (newFKeys.isEmpty()) {
            newFKeys = null;
        } else {
            newFKeys.trimToSize();
        }
        this.myForeignKeys = newFKeys;
    }

    public void removeAllForeignKeys() throws StorageException {
        this.myForeignKeys = null;
    }

    public PrimaryKey createPrimaryKey(String name) throws CreateException, NameExistsException {
        this.myPrimaryKey = new PrimaryKeyImpl(this.getM4Db());
        try {
            this.myPrimaryKey.setColumnSet(this);
        }
        catch (StorageException se) {
            throw new CreateException("Could not link new PrimaryKey '" + name + "' to Columnset " + this.getId() + ": " + se.getMessage());
        }
        this.myPrimaryKey.setName(name);
        return this.myPrimaryKey;
    }

    public PrimaryKey getPrimaryKey() {
        return this.myPrimaryKey;
    }

    public void setPrimaryKey(PrimaryKey primKey) throws StorageException {
        this.myPrimaryKey = primKey;
    }

    public void removePrimaryKey() throws StorageException {
        this.myPrimaryKey = null;
    }

    public ColumnSet copy(Concept newConcept) throws CreateException, NameExistsException {
        ColumnsetImpl theCopy = new ColumnsetImpl(this.getM4Db());
        try {
            theCopy.setTheConcept((ConceptImpl)newConcept);
            theCopy.setColumns(this.getAllColumns());
            theCopy.setColumnSetStatistics(this.getColumnSetStatistics());
            theCopy.setColumnSetType(this.getColumnSetType());
            theCopy.setConnectString(this.getConnectString());
            theCopy.setFile(this.getFile());
            theCopy.setMultiStepBranch(this.getMultiStepBranch());
            theCopy.setName(this.getName());
            theCopy.setPrimaryKey(this.getPrimaryKey());
            theCopy.setRelationship(this.getRelationship());
            theCopy.setSchema(this.getSchema());
            theCopy.setSQLDefinition(this.getSQLDefinition());
            theCopy.setSqlString(this.getSqlString());
            theCopy.setStatisticsAll(this.getStatisticsAll());
            theCopy.setStatisticsNominal(this.getStatisticsNominal());
            theCopy.setStatisticsOrdinal(this.getStatisticsOrdinal());
            theCopy.setStatisticsTime(this.getStatisticsTime());
            theCopy.setType(this.getType());
            theCopy.setUser(this.getUser());
        }
        catch (M4Exception m4e) {
            throw new CreateException("Could not create copy of Column " + this.getId() + ": " + m4e.getMessage());
        }
        catch (StorageException se) {
            throw new CreateException("Could not create copy of Column " + this.getId() + ": " + se.getMessage());
        }
        return theCopy;
    }

    public void setDocumentation(String text) {
        try {
            super.setDocumentation(text);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public String getDocumentation() {
        try {
            return super.getDocumentation();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public void delete() throws StorageException {
        try {
            super.deleteSoon();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void store() throws StorageException {
        try {
            super.getM4Db().updateDatabase();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public boolean isChanged() {
        return super.isDirty();
    }
}

