/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class RelationalDatatypes
implements Serializable {
    public static final String M4_TABLE_NAME = "col_datatype_t";
    public static final String ATTRIB_DATATYPE_ID = "coldt_id";
    public static final String ATTRIB_DATATYPE_NAME = "coldt_name";
    private HashMap idToName = new HashMap();
    private HashMap nameToId = new HashMap();

    public RelationalDatatypes(DB db) throws M4Exception, DbConnectionClosed {
        String query = "SELECT coldt_id, coldt_name FROM col_datatype_t";
        ResultSet rs = null;
        try {
            try {
                rs = db.executeM4SqlRead(query);
                while (rs.next()) {
                    Integer id = new Integer(rs.getInt(ATTRIB_DATATYPE_ID));
                    if (rs.wasNull()) continue;
                    String name = rs.getString(ATTRIB_DATATYPE_NAME);
                    this.idToName.put(id, name);
                    this.nameToId.put(name, id);
                }
            }
            catch (SQLException e) {
                throw new M4Exception("SQLException when trying to read the relational datatypes:\n" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var7_9 = null;
        DB.closeResultSet(rs);
    }

    public long getIdForName(String name) {
        Integer id = (Integer)this.nameToId.get(name);
        if (id != null) {
            return id.longValue();
        }
        return 0L;
    }

    public String getNameForId(long id) {
        Integer idI = new Integer((int)id);
        return (String)this.idToName.get(idI);
    }
}

