/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.utils.Print;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class M4Object
implements Serializable,
Comparable {
    protected String myName = null;
    protected long myId = 0L;
    private final DB m4Db;
    private boolean isNew;

    public M4Object(DB db) {
        this.m4Db = db;
        this.isNew = true;
    }

    public Print getCasePrintObject() {
        return this.getM4Db().getCasePrintObject();
    }

    public M4Object load(long id) throws M4Exception {
        this.isNew = false;
        this.setId(id);
        this.readFromDb();
        return this;
    }

    public abstract void readFromDb() throws M4Exception;

    public abstract void print();

    public long getId() {
        return this.myId;
    }

    public void setId(long newId) throws M4Exception {
        long oldId = this.getId();
        if (oldId != 0L && oldId != newId) {
            throw new M4Exception("Cannot change the ID of M4Object which has it ID already set!Old ID: " + this.getId() + ", New ID: " + newId + ", Object class: " + this.getClass().getName());
        }
        this.myId = newId;
    }

    public DB getM4Db() {
        return this.m4Db;
    }

    public void doPrint(int verbosity, String printString) {
        this.getCasePrintObject().doPrint(verbosity, printString);
    }

    public void doPrint(Exception ex) {
        this.getCasePrintObject().doPrint(ex);
    }

    public void setName(String n) {
        this.myName = n;
    }

    public String replaceSpacesInName(String name) {
        if (name != null && name.indexOf(32) > -1) {
            StringBuffer newName = new StringBuffer();
            while (name.length() > 0) {
                int index = name.indexOf(32);
                if (index == -1) {
                    newName.append(name);
                    break;
                }
                newName.append(name.substring(0, index));
                newName.append('_');
                name = name.substring(index + 1);
            }
            name = newName.toString();
        }
        return name;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isNew() {
        return this.isNew;
    }

    private void noPrintObjectError(String message) {
        System.err.println("Print object unreachable from object of " + this.getClass() + "!\n" + message);
    }

    public M4Object getM4ObjectFromCache(long Id) {
        return this.getM4Db().getM4ObjectFromCache(Id);
    }

    public void putM4ObjectToCache(M4Object m4o) throws M4Exception {
        this.getM4Db().putM4ObjectToCache(m4o);
    }

    public void executeM4SqlWrite(String query) throws M4Exception {
        try {
            this.getM4Db().executeM4SqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + d.getMessage());
        }
    }

    public void executeBusinessSqlWrite(String query) throws M4Exception {
        try {
            this.getM4Db().executeBusinessSqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + d.getMessage());
        }
    }

    public ResultSet executeM4SqlRead(String query) throws M4Exception {
        try {
            return this.getM4Db().executeM4SqlRead(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + d.getMessage());
        }
    }

    public ResultSet executeBusinessSqlRead(String query) throws M4Exception {
        try {
            return this.getM4Db().executeBusinessSqlRead(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + d.getMessage());
        }
    }

    public Long executeM4SingleValueSqlReadL(String query) throws M4Exception {
        try {
            return this.getM4Db().executeM4SingleValueSqlReadL(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + d.getMessage());
        }
    }

    public Long executeBusinessSingleValueSqlReadL(String query) throws M4Exception {
        try {
            return this.getM4Db().executeBusinessSingleValueSqlReadL(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + d.getMessage());
        }
    }

    public String executeM4SingleValueSqlRead(String query) throws M4Exception {
        try {
            return this.getM4Db().executeM4SingleValueSqlRead(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + d.getMessage());
        }
    }

    public String executeBusinessSingleValueSqlRead(String query) throws M4Exception {
        try {
            return this.getM4Db().executeBusinessSingleValueSqlRead(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB error executing query for M4 object " + this.getId() + " ('" + this.getName() + "'): " + d.getMessage());
        }
    }

    public long getNextM4SequenceValue() throws M4Exception {
        long m4id = -1L;
        try {
            m4id = this.getM4Db().getNextM4SequenceValue();
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error reading next M4 Id from Sequence: DB connection closed: " + d.getMessage());
        }
        return m4id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof M4Object) || this.getId() == 0L) {
            return false;
        }
        M4Object m4o = (M4Object)obj;
        return this.getId() == m4o.getId();
    }

    public int compareTo(Object anM4Object) throws ClassCastException {
        M4Object toCompare = null;
        try {
            toCompare = (M4Object)anM4Object;
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("M4Object.compareTo: got an object that was no M4Object: " + cce.getMessage());
        }
        String thisName = this.getName();
        String otherName = toCompare.getName();
        if (thisName == null) {
            return otherName == null ? 0 : -1;
        }
        return thisName.compareTo(otherName);
    }
}

