/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.utils.Coordinates;
import edu.udo.miningmart.m4.utils.CoordinatesContext;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.awt.Point;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class GraphicalM4Object
extends M4Data
implements XmlInfo {
    private Coordinates myCoordinates;
    private boolean allCoordinatesLoaded = false;

    public GraphicalM4Object(DB m4Db) {
        super(m4Db);
    }

    protected abstract boolean hasCoordinates();

    public void print() {
        Collection c = null;
        try {
            if (this.hasCoordinates()) {
                c = this.getCoordinates().getAllLocations();
            }
        }
        catch (M4Exception m4e) {
            this.doPrint(m4e);
            return;
        }
        if (c == null || c.isEmpty()) {
            this.doPrint(4, "M4 Object '" + this.getName() + "' has no graphical info stored with it.");
        } else {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Point p = (Point)it.next();
                this.doPrint(4, "Graphical info for M4 object '" + this.getName() + "': X: " + p.x + ", Y: " + p.y + ".");
            }
        }
    }

    public void setName(String name) {
        boolean duringLoad;
        String oldName = this.getName();
        super.setName(name);
        boolean bl = duringLoad = oldName == null;
        if (!duringLoad) {
            this.setCoordinatesDirty();
            try {
                Coordinates coord;
                if (this.hasCoordinates() && (coord = this.getCoordinates()) != null) {
                    coord.changeM4ObjectName(name);
                }
            }
            catch (M4Exception e) {
                this.doPrint(20, "Warning: Exception caught while trying to update graphical context information after name changed from " + oldName + " to " + this.getName() + " for object of class " + this.getClass().getName());
            }
            Collection col = null;
            try {
                col = this.getGraphicallyEmbeddedObjects();
            }
            catch (M4Exception e) {
                this.doPrint(20, "Warning: Exception caught while trying to update graphical context information after name changed from " + oldName + " to " + this.getName() + " for object of class " + this.getClass().getName());
            }
            if (col != null) {
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    GraphicalM4Object gmo = (GraphicalM4Object)it.next();
                    gmo.setCoordinatesDirty();
                }
            }
        }
    }

    protected Collection getGraphicallyEmbeddedObjects() throws M4Exception {
        return null;
    }

    public void setCoordinatesDirty() {
        if (this.hasCoordinates()) {
            this.setDirty();
            Coordinates coord = null;
            try {
                coord = this.getCoordinates();
            }
            catch (M4Exception e) {
                this.doPrint(20, "Exception caught when trying to get coordinates for object (" + this.getClass().getName() + ", ID: " + this.getId() + ", name: " + (this.getName() == null ? "<null>" : this.getName()) + ")\n" + e.getMessage());
            }
            if (coord != null && !coord.isDirty()) {
                coord.setDirty();
            }
        }
    }

    protected void storeLocal() throws M4Exception {
        Coordinates c;
        if (this.hasCoordinates() && (c = this.getCoordinates()) != null && c.isDirty()) {
            c.store();
        }
    }

    protected void deleteLocal() throws M4Exception {
        if (this.hasCoordinates()) {
            this.getCoordinates().delete();
        }
    }

    public void addContext(CoordinatesContext theContext) throws M4Exception {
        if (!this.hasCoordinates()) {
            throw new M4Exception("Attempt to add coordinates to an Object where this is not applicable!");
        }
        if (!this.isNew()) {
            throw new M4Exception("Attempt to use method GraphicalM4Object.addContext() outside importing!");
        }
        this.getCoordinates().addContextObject(theContext);
    }

    public Point getPointForContext(GraphicalM4Object context) throws M4Exception {
        if (this.hasCoordinates()) {
            return this.getCoordinates().getLocationForContext(context);
        }
        return null;
    }

    public Point getPointForContextFromMap(Map points, GraphicalM4Object context) throws M4Exception {
        if (this.hasCoordinates()) {
            return this.getCoordinates().getLocationFromMap(context, points);
        }
        return null;
    }

    public Map getPointsWhereContextIsThis() throws M4Exception {
        if (this.hasCoordinates()) {
            return this.getCoordinates().getLocationsForContext(this);
        }
        return null;
    }

    public Point getPointForContextAndName(GraphicalM4Object context, String name) throws M4Exception {
        if (this.hasCoordinates()) {
            return this.getCoordinates().getLocationUsingName(name, context);
        }
        return null;
    }

    public Point getPointForContextAndNameFromMap(Map points, GraphicalM4Object context, String name) throws M4Exception {
        if (this.hasCoordinates()) {
            return this.getCoordinates().getLocationFromMapUsingName(name, context, points);
        }
        return null;
    }

    public void setPointForContext(GraphicalM4Object context, Point location) throws M4Exception {
        if (this.hasCoordinates()) {
            this.getCoordinates().setLocation(context, location);
        }
    }

    public void setPointForContextUsingName(GraphicalM4Object context, String name, Point location) throws M4Exception {
        if (this.hasCoordinates()) {
            this.getCoordinates().setLocationUsingName(name, context, location);
        }
    }

    public void removePointsForContextAndName(GraphicalM4Object context, String name) throws M4Exception {
        if (this.hasCoordinates()) {
            this.getCoordinates().removePointsInContextUsingName(name, context);
        }
    }

    public void removePointsForContext(GraphicalM4Object context) throws M4Exception {
        if (this.hasCoordinates()) {
            this.getCoordinates().removePointsInContext(context);
        }
    }

    public void removeAllPoints() throws M4Exception {
        if (this.hasCoordinates()) {
            this.getCoordinates().removeAllPoints();
        }
    }

    private Coordinates getCoordinates() throws M4Exception {
        if (!this.hasCoordinates()) {
            return null;
        }
        if (!this.allCoordinatesLoaded) {
            this.allCoordinatesLoaded = true;
            boolean loadCoordinatesFromDB = !this.isNew();
            this.myCoordinates = new Coordinates(this.getM4Db(), this, loadCoordinatesFromDB);
        }
        return this.myCoordinates;
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        if (this.hasCoordinates()) {
            ret.addAll(this.getCoordinates().getContextObjects());
        }
        return ret;
    }

    public abstract M4Info getXmlInfo();
}

