/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Iterator;

public class ColumnsetStatistics
extends M4Data
implements XmlInfo {
    public static final String M4_TABLE_NAME = "csstatist_t";
    public static final String ATTRIB_CSSTAT_ID = "csst_id";
    public static final String ATTRIB_CSSTAT_CS = "csst_csid";
    public static final String ATTRIB_CSSTAT_ALL = "csst_all";
    public static final String ATTRIB_CSSTAT_ORD = "csst_ord";
    public static final String ATTRIB_CSSTAT_NOM = "csst_nom";
    public static final String ATTRIB_CSSTAT_TIME = "csst_time";
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private Columnset myColumnset;
    private Integer noOfRows;
    private Integer noOfOrdAttr;
    private Integer noOfNomAttr;
    private Integer noOfTimeAttr;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_CSSTAT_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[6];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_CSSTAT_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_CSSTAT_CS, "getTheColumnset", "primitiveSetColumnset", clazz, "NN");
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_CSSTAT_ALL, "getNrOfAllTuples", "setNrOfAllTuples", clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry(ATTRIB_CSSTAT_ORD, "getNrOfOrdAttribs", "setNrOfOrdAttribs", clazz3);
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry(ATTRIB_CSSTAT_NOM, "getNrOfNomAttribs", "setNrOfNomAttribs", clazz4);
            Class<?> clazz5 = class$2;
            if (clazz5 == null) {
                try {
                    clazz5 = class$2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry(ATTRIB_CSSTAT_TIME, "getNrOfTimeAttribs", "setNrOfTimeAttribs", clazz5);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[5];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Columnset", "getTheColumnset", "setTheColumnset", clazz);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("NrOfTuples", "getNrOfAllTuples", "setNrOfAllTuples", clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry("OrdinalAttr", "getNrOfOrdAttribs", "setNrOfOrdAttribs", clazz3);
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry("NominalAttr", "getNrOfNomAttribs", "setNrOfNomAttribs", clazz4);
            Class<?> clazz5 = class$2;
            if (clazz5 == null) {
                try {
                    clazz5 = class$2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry("TimeAttr", "getNrOfTimeAttribs", "setNrOfTimeAttribs", clazz5);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public ColumnsetStatistics(DB db) {
        super(db);
    }

    public Columnset getTheColumnset() {
        return this.myColumnset;
    }

    public void setTheColumnset(Columnset columnset) throws M4Exception {
        Columnset.csstat.updateReferenceTo(this, columnset);
    }

    public void primitiveSetColumnset(Columnset columnset) {
        this.setDirty();
        this.myColumnset = columnset;
    }

    public void print() {
    }

    public void removeAllM4References() throws M4Exception {
        this.setTheColumnset(null);
    }

    public Integer getNrOfAllTuples() {
        return this.noOfRows;
    }

    public void setNrOfAllTuples(Integer nrOfRows) {
        this.noOfRows = nrOfRows;
    }

    public Integer getNrOfOrdAttribs() {
        return this.noOfOrdAttr;
    }

    public void setNrOfOrdAttribs(Integer nrOfOrdinalAttributes) {
        this.noOfOrdAttr = nrOfOrdinalAttributes;
    }

    public Integer getNrOfNomAttribs() {
        return this.noOfNomAttr;
    }

    public void setNrOfNomAttribs(Integer nrOfNominalAttributes) {
        this.noOfNomAttr = nrOfNominalAttributes;
    }

    public Integer getNrOfTimeAttribs() {
        return this.noOfTimeAttr;
    }

    public void setNrOfTimeAttribs(Integer nrOfTimeAttributes) {
        this.noOfTimeAttr = nrOfTimeAttributes;
    }

    public void update() throws M4Exception {
        Columnset myCS = this.getTheColumnset();
        if (myCS == null) {
            return;
        }
        String csstAll = this.executeBusinessSingleValueSqlRead("SELECT COUNT(*) FROM " + myCS.getSchemaPlusName());
        String pre = "SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = ";
        String post = " AND col_csid = " + myCS.getId();
        String csstOrd = this.executeM4SingleValueSqlRead("SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = 12" + post);
        String csstNom = this.executeM4SingleValueSqlRead("SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = 13" + post);
        String csstTime = this.executeM4SingleValueSqlRead("SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = 14" + post);
        if (csstAll == null || csstOrd == null || csstNom == null || csstTime == null) {
            throw new M4Exception("Columnset.updateStatistics for ColumnSet with ID " + myCS.getId() + ":\nReceived a null value from query.");
        }
        try {
            this.setNrOfAllTuples(csstAll == null ? null : new Integer(csstAll));
            this.setNrOfOrdAttribs(csstOrd == null ? null : new Integer(csstOrd));
            this.setNrOfNomAttribs(csstNom == null ? null : new Integer(csstNom));
            this.setNrOfTimeAttribs(csstTime == null ? null : new Integer(csstTime));
        }
        catch (NumberFormatException e) {
            throw new M4Exception("Columnset.updateStatistics for ColumnSet with ID " + myCS.getId() + ":\nStatistic calculation yielded a String not parseable to Integer.");
        }
        Collection cols = myCS.getColumns();
        Iterator it = cols.iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            BaseAttribute ba = column.getTheBaseAttribute();
            if (ba == null) continue;
            long conceptualDT = ba.getConceptualDataType();
            column.updateStatistics(conceptualDT);
        }
    }
}

