/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Chain;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.core.Step;
import edu.udo.miningmart.m4.utils.InterM4CaseChain;
import edu.udo.miningmart.m4.utils.InterM4CaseConcept;
import edu.udo.miningmart.m4.utils.InterM4CaseStep;
import edu.udo.miningmart.m4.utils.InterM4Communicator;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class Case
extends M4Data
implements XmlInfo {
    public static final String M4_TABLE_NAME = "case_t";
    public static final String ATTRIB_CASE_ID = "ca_id";
    public static final String ATTRIB_CASE_NAME = "ca_name";
    public static final String ATTRIB_CASE_MODE = "ca_mode";
    public static final String TESTMODE = "TEST";
    public static final String FINALMODE = "FINAL";
    static final InterM4Communicator case2con = new InterM4CaseConcept();
    static final InterM4Communicator case2step = new InterM4CaseStep();
    static final InterM4Communicator case2chain = new InterM4CaseChain();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private final Vector myChains = new Vector();
    private final Vector mySteps = new Vector();
    private final Vector myConcepts = new Vector();
    private boolean allConceptsLoaded = false;
    private boolean allStepsLoaded = false;
    private boolean allChainsLoaded = false;
    private String myMode = "TEST";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_CASE_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[3];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_CASE_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_CASE_NAME, "getName", "setName", clazz, "NN");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_CASE_MODE, "getTheMode", "setTheMode", clazz2, "NN");
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[3];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Name", "getName", "setName", clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", clazz2);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry("Mode", "getTheMode", "setTheMode", clazz3);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Case(DB m4Db) {
        super(m4Db);
    }

    public void addStepDependency(Step before, Step after) throws M4Exception {
        if (before == null || after == null) {
            throw new M4Exception("Trying to enter null-values in step dependency graph! Case: " + this.getId());
        }
        Vector steps = this.getTheSteps();
        int beforeIndex = steps.indexOf(before);
        int afterIndex = steps.indexOf(after);
        if (beforeIndex == -1 || afterIndex == -1) {
            throw new M4Exception("Trying to enter dependency for unknown step! Step ID:" + (beforeIndex == -1 ? "<" + before.getId() + ">" : "") + (afterIndex == -1 ? "<" + after.getId() + ">" : "") + ", Case ID: " + this.getId());
        }
        before.addSuccessor(after);
        if (beforeIndex > afterIndex) {
            int i = afterIndex;
            while (i < beforeIndex) {
                steps.set(i, steps.get(i + 1));
                ++i;
            }
            steps.set(beforeIndex, after);
        }
    }

    public boolean containsDependency(Step before, Step after) throws M4Exception {
        if (this.getTheSteps().contains(before)) {
            return before.getSuccessors().contains(after);
        }
        return false;
    }

    public boolean removeStepDependency(Step before, Step after) throws M4Exception {
        if (before == null || after == null) {
            throw new M4Exception("Trying to remove null-entries in step dependency graph! Case: " + this.getId());
        }
        return before.removeSuccessor(after);
    }

    public void setTheMode(String newMode) throws M4Exception {
        this.setDirty();
        if (!newMode.equals(TESTMODE) && !newMode.equals(FINALMODE)) {
            throw new M4Exception("Case.setTheMode: constant TEST or FINAL expected; found '" + newMode + "'!");
        }
        this.myMode = newMode;
    }

    public String getTheMode() {
        return this.myMode;
    }

    public void print() {
        this.doPrint(4, "Step (Id = " + this.getId() + ";" + "      Name = " + this.getName() + ";" + "      Steps: ");
        try {
            Iterator it = this.getStepIterator();
            while (it.hasNext()) {
                Step s = (Step)it.next();
                if (s == null) continue;
                this.doPrint(4, "Step " + s.getId());
            }
        }
        catch (M4Exception e) {
            this.doPrint(4, "Warning: Error loading steps in Case.print(): " + e.getMessage());
        }
        this.doPrint(4, ")");
    }

    public Step getStepIdNo(int i) throws M4Exception {
        Vector steps = this.getTheSteps();
        if (i < 0 || i >= steps.size()) {
            return null;
        }
        return (Step)steps.get(i);
    }

    public int getNumberOfSteps() throws M4Exception {
        return this.getTheSteps().size();
    }

    public Step getPredecessorIdOf(Step step) throws M4Exception {
        Iterator it = this.getStepIterator();
        Step predecessor = null;
        while (it.hasNext()) {
            Step next = (Step)it.next();
            if (next.equals(step)) {
                return predecessor;
            }
            predecessor = next;
        }
        return null;
    }

    public Step getSuccessorOf(Step step) throws M4Exception {
        Iterator it = this.getStepIterator();
        while (it.hasNext() && !((Step)it.next()).equals(step)) {
        }
        if (it.hasNext()) {
            return (Step)it.next();
        }
        return null;
    }

    public int indexOfStep(Step step) throws M4Exception {
        Vector col = this.getTheSteps();
        return col.indexOf(step);
    }

    public Iterator getStepIterator() throws M4Exception {
        return ((AbstractList)this.getTheSteps()).iterator();
    }

    public Iterator getReverseIterator() throws M4Exception {
        LinkedList rev = new LinkedList();
        Iterator it = this.getStepIterator();
        while (it.hasNext()) {
            rev.addFirst(it.next());
        }
        return rev.iterator();
    }

    public Collection getDependentStepsFor(Step step) throws M4Exception {
        if (step == null) {
            return null;
        }
        if (!this.getTheSteps().contains(step)) {
            throw new M4Exception("Case.getDependentStepIdsFor(Step):\nStep with ID: " + step.getId() + " not part of Case " + this.getId() + "!");
        }
        HashMap openDict = new HashMap();
        LinkedList<Step> path = new LinkedList<Step>();
        LinkedList<Step> closed = new LinkedList<Step>();
        HashSet<Step> closedDict = new HashSet<Step>();
        path.addLast(step);
        openDict.put(step, new LinkedList(step.getSuccessors()));
        while (!path.isEmpty()) {
            Step last = (Step)path.getLast();
            LinkedList successors = (LinkedList)openDict.get(last);
            Step next = null;
            while (next == null && !successors.isEmpty()) {
                next = (Step)successors.removeFirst();
                if (openDict.containsKey(next)) {
                    throw new M4Exception("Case.getDependentStepIdsFor(long):\nCase " + this.getId() + " has cyclic dependencies between Steps!");
                }
                if (!closedDict.contains(next)) continue;
                next = null;
            }
            if (next == null && successors.isEmpty()) {
                path.remove(last);
                openDict.remove(last);
                closedDict.add(last);
                closed.addFirst(last);
                continue;
            }
            path.addLast(next);
            openDict.put(next, new LinkedList(next.getSuccessors()));
        }
        return closed;
    }

    public Collection getDirectlyDependentSteps(Step step) throws M4Exception {
        if (step != null && this.getTheSteps().contains(step)) {
            return step.getSuccessors();
        }
        return null;
    }

    public Collection getConcepts() throws M4Exception {
        if (!this.allConceptsLoaded && !this.isNew()) {
            this.allConceptsLoaded = true;
            this.readConceptsForCaseFromDb();
        }
        return this.myConcepts;
    }

    public void addConcept(Concept con) throws M4Exception {
        case2con.checkNameExists(con, this);
        case2con.add(this, con);
    }

    public boolean removeConcept(Concept con) throws M4Exception {
        return case2con.remove(this, con);
    }

    public Collection getChains() throws M4Exception {
        if (!this.allChainsLoaded && !this.isNew()) {
            this.allChainsLoaded = true;
            this.readChainsForCaseFromDb();
        }
        return this.myChains;
    }

    public void addChain(Chain chain) throws M4Exception {
        case2chain.checkNameExists(chain, this);
        case2chain.add(this, chain);
    }

    public boolean removeChain(Chain chain) throws M4Exception {
        return case2chain.remove(this, chain);
    }

    public Step getStepByName(String name) throws M4Exception {
        if (name == null) {
            return null;
        }
        Iterator it = ((AbstractList)this.getTheSteps()).iterator();
        while (it.hasNext()) {
            Step step = (Step)it.next();
            if (step == null || !name.equals(step.getName())) continue;
            return step;
        }
        return null;
    }

    public Vector getTheSteps() throws M4Exception {
        if (!this.allStepsLoaded && !this.isNew()) {
            this.allStepsLoaded = true;
            this.readStepsFromDb();
        }
        return this.mySteps;
    }

    public void addStep(Step step) throws M4Exception {
        case2step.checkNameExists(step, this);
        case2step.add(this, step);
    }

    public boolean removeStep(Step step) throws M4Exception {
        return case2step.remove(this, step);
    }

    private void readConceptsForCaseFromDb() throws M4Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("edu.udo.miningmart.m4.core.Concept");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addConcept((Concept)it.next());
        }
    }

    private void readChainsForCaseFromDb() throws M4Exception {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.Chain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addChain((Chain)it.next());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readStepsFromDb() throws M4Exception {
        Iterator sequentialIterator;
        Vector stepsOfCase;
        DB dB = this.getM4Db();
        Class<?> clazz = class$4;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("edu.udo.miningmart.m4.core.Step");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$4 = clazz2;
        }
        Step artificialStep = (Step)dB.createNewInstance(clazz);
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("edu.udo.miningmart.m4.core.Step");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz3 = class$4 = clazz4;
        }
        Collection theSteps = this.getObjectsReferencingMe(clazz3);
        Iterator it = theSteps.iterator();
        while (true) {
            if (!it.hasNext()) {
                stepsOfCase = this.getTheSteps();
                stepsOfCase.add(artificialStep);
                sequentialIterator = this.getDependentStepsFor(artificialStep).iterator();
                stepsOfCase.clear();
                artificialStep.getSuccessors().clear();
                artificialStep.deleteSoon();
                if (sequentialIterator.next() == artificialStep) break;
                throw new M4Exception("Sequentializer error in Case.readStepsFromDb():\nMethod getDependentStepsFor(Step) returns invalid Collection!");
            }
            Step currentStep = (Step)it.next();
            this.addStep(currentStep);
            artificialStep.addSuccessor(currentStep);
        }
        while (sequentialIterator.hasNext()) {
            stepsOfCase.add((Step)sequentialIterator.next());
        }
        return;
    }

    protected void removeAllM4References() throws M4Exception {
        Vector empty = new Vector();
        case2chain.setCollectionTo(this, empty);
        case2con.setCollectionTo(this, empty);
        case2step.setCollectionTo(this, empty);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getChains());
        ret.addAll(this.getConcepts());
        ret.addAll(this.getTheSteps());
        return ret;
    }
}

