/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.db;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.db.DbCore;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.M4InterfaceContext;
import edu.udo.miningmart.m4.core.Parameter;
import edu.udo.miningmart.m4.core.ParameterObject;
import edu.udo.miningmart.m4.core.Step;
import edu.udo.miningmart.m4.core.Value;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compiler.utils.DrawSample;

public class CompilerDatabaseService
extends DB {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CompilerDatabaseService(String m4Url, String m4DbName, String m4User, String m4Passwd, String dataUrl, String dataDbName, String dataUser, String dataPasswd, boolean computeStatistics, M4InterfaceContext cal) throws SQLException {
        super(m4Url, m4DbName, m4User, m4Passwd, dataUrl, dataDbName, dataUser, dataPasswd, computeStatistics, cal);
    }

    public CompilerDatabaseService(DB db, M4InterfaceContext m4i) {
        super(db, m4i);
    }

    public void createSQLView(Columnset cs, Step step) throws M4CompilerError {
        try {
            long stepId = step.getId();
            boolean materialized = this.hasToBeMaterialized(cs, step);
            this.getBusinessDbCore().createSQLView(cs, stepId, materialized);
            if (materialized) {
                this.addTableToTrash(cs.getName(), cs.getSchema(), stepId);
            } else {
                this.addViewToTrash(cs.getName(), cs.getSchema(), stepId);
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when creating view for Columnset " + cs.getName() + ": " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when creating view for Columnset " + cs.getName() + ": " + dbe.getMessage());
        }
    }

    public void addTableToTrash(String tableName, String schemaName, long stepId) throws M4CompilerError {
        this.addDatabaseObjectToTrash(tableName, schemaName, "T", stepId);
    }

    public void addFunctionToTrash(String functionName, String schemaName, long stepId) throws M4CompilerError {
        this.addDatabaseObjectToTrash(functionName, schemaName, "F", stepId);
    }

    public void addIndexToTrash(String indexName, String schemaName, long stepId) throws M4CompilerError {
        this.addDatabaseObjectToTrash(indexName, schemaName, "I", stepId);
    }

    public void addViewToTrash(String viewName, String schemaName, long stepId) throws M4CompilerError {
        this.addDatabaseObjectToTrash(viewName, schemaName, "V", stepId);
    }

    private void addDatabaseObjectToTrash(String objectName, String schemaName, String objectType, long stepId) throws M4CompilerError {
        Step theStep = null;
        String msg = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Step");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            theStep = (Step)this.getM4Object(stepId, clazz);
        }
        catch (M4Exception e) {
            msg = e.getMessage();
        }
        if (theStep == null) {
            throw new M4CompilerError("Could not add database object to trash of step with ID" + stepId + "!\n" + (msg == null ? " Step not found!" : "Exception: " + msg));
        }
        try {
            theStep.addDatabaseObjectToTrash(objectName, schemaName, objectType);
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
    }

    public Connection getDatabaseConnectionForData() throws M4CompilerError {
        try {
            return this.getBusinessDbCore().getExternalDatabaseConnection();
        }
        catch (SQLException e) {
            throw new M4CompilerError("DB.getDatabaseConnectionForData(): Could not create new Connection for external usage:\n" + e.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed: " + dbe.getMessage());
        }
    }

    public boolean dropBusinessTable(String tableName) throws M4CompilerError {
        ResultSet rs;
        boolean tableExists;
        block10: {
            String sql_test = "SELECT * FROM " + tableName + " WHERE ROWNUM=1";
            tableExists = true;
            rs = null;
            try {
                try {
                    rs = this.executeBusinessSqlRead(sql_test);
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("does not exist") > -1 || sqle.getMessage().startsWith("ORA-00942:")) {
                        tableExists = false;
                        break block10;
                    }
                    throw new M4CompilerError("Error trying to access business table '" + tableName + "': " + sqle.getMessage());
                }
                catch (DbConnectionClosed dbe) {
                    throw new M4CompilerError("DB Connection closed when deleting table '" + tableName + "':\n" + dbe.getMessage());
                }
            }
            catch (Throwable dbe) {
                Object var7_9 = null;
                DB.closeResultSet(rs);
                throw dbe;
            }
        }
        Object var7_10 = null;
        DB.closeResultSet(rs);
        if (tableExists) {
            String sql_drop = "DROP TABLE " + tableName;
            try {
                this.executeBusinessSqlWrite(sql_drop);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error trying to remove the business table '" + tableName + "':\n" + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4CompilerError("DB Connection closed when deleting table '" + tableName + "':\n" + dbe.getMessage());
            }
        }
        return tableExists;
    }

    private boolean hasToBeMaterialized(Columnset cs, Step step) {
        return false;
    }

    public long readCaseIdForStepId(long stepId) throws M4CompilerError {
        try {
            String query = "SELECT st_caid FROM step_t WHERE st_id = " + stepId;
            Long caseId = this.executeM4SingleValueSqlReadL(query);
            if (caseId == null) {
                throw new M4CompilerError("M4 Database: Case not found");
            }
            return caseId;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL error when reading case info for step " + stepId + ":\n" + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when reading case info for step " + stepId + ":\n" + dbe.getMessage());
        }
    }

    public String computeSum(Column col) throws M4CompilerError {
        try {
            Columnset cs = col.getColumnset();
            String query = "SELECT SUM(" + col.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
            String sum = this.executeBusinessSingleValueSqlRead(query);
            return sum;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL Error trying to compute sum for column " + col.getId() + ":\n" + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when computing sum in column " + col.getId() + ":\n" + dbe.getMessage());
        }
    }

    public String computeNumberOfDistinctElements(Column col) throws M4CompilerError {
        try {
            Columnset cs = col.getColumnset();
            String query = "SELECT COUNT(DISTINCT(" + col.getSQLDefinition() + ")) FROM " + cs.getSchemaPlusName();
            String sum = this.executeBusinessSingleValueSqlRead(query);
            return sum;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL Error trying to compute no of elements for column " + col.getId() + ":\n" + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when computing element number in column " + col.getId() + ":\n" + dbe.getMessage());
        }
    }

    public long testSQLColumn(Column col) throws M4CompilerError {
        String dataType = null;
        ResultSet rs = null;
        try {
            try {
                String query = "SELECT " + col.getSQLDefinition() + " FROM " + col.getColumnset().getSchema() + "." + col.getColumnset().getName() + " WHERE rownum < 1";
                rs = this.executeBusinessSqlRead(query);
                ResultSetMetaData md = rs.getMetaData();
                dataType = md.getColumnTypeName(1);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("SQL Error testing SQL definition for column " + col.getId() + ": " + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4CompilerError("DB Connection closed when testing definition for column " + col.getId() + ": " + dbe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var7_10 = null;
        DB.closeResultSet(rs);
        if (dataType != null) {
            if (dataType.startsWith("NUM")) {
                return 12L;
            }
            if (dataType.startsWith("VARCHAR")) {
                return 13L;
            }
            if (dataType.startsWith("DATE")) {
                return 14L;
            }
            if (dataType.startsWith("CHAR")) {
                return 13L;
            }
        }
        throw new M4CompilerError("SQL-Datatype returned for column not known: Got " + dataType + " but expected NUMBER/NUMERIC or VARCHAR or DATE or CHAR");
    }

    public Value[] getCountOfElements(Column col) throws M4CompilerError {
        Vector<Value> theElements = new Vector<Value>();
        ResultSet rs = null;
        try {
            try {
                String query = "SELECT " + col.getName() + ", COUNT(" + col.getName() + ") AS ItemsCount " + "FROM " + col.getColumnset().getName() + " GROUP BY " + col.getName() + " ORDER BY " + col.getName();
                rs = this.executeBusinessSqlRead(query);
                while (rs.next()) {
                    Value v;
                    try {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("edu.udo.miningmart.m4.core.Value");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        v = (Value)this.createNewInstance(clazz);
                    }
                    catch (M4Exception e) {
                        throw new M4CompilerError("Could not create Value:\n" + e.getMessage());
                    }
                    v.setValue(String.valueOf(rs.getString("ItemsCount")) + "," + rs.getString(col.getName()));
                    theElements.add(v);
                }
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error trying to read distinct values in column " + col.getName() + ":\n" + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4CompilerError("DB Connection closed when counting elements in column " + col.getId() + ": " + dbe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var8_12 = null;
        DB.closeResultSet(rs);
        theElements.trimToSize();
        Value[] El = new Value[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            El[i] = (Value)theElements.get(i);
            ++i;
        }
        return El;
    }

    public Value[] getCountOfElements(Column colCA, Column colTA) throws M4CompilerError {
        Vector<Value> theElements = new Vector<Value>();
        ResultSet rs = null;
        try {
            try {
                String query = "SELECT " + colTA.getName() + ", " + colCA.getName() + ", COUNT(" + colTA.getName() + ") AS ItemsCount " + "FROM " + colTA.getColumnset().getName() + " GROUP BY " + colTA.getName() + ", " + colCA.getName() + " ORDER BY " + colTA.getName();
                this.doPrint(2, "DB Query: " + query);
                rs = this.executeBusinessSqlRead(query);
                while (rs.next()) {
                    Value v;
                    try {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("edu.udo.miningmart.m4.core.Value");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        v = (Value)this.createNewInstance(clazz);
                    }
                    catch (M4Exception e) {
                        throw new M4CompilerError("Could not create Value:\n" + e.getMessage());
                    }
                    v.setValue(String.valueOf(rs.getString("ItemsCount")) + "," + rs.getString(colCA.getName()) + "," + rs.getString(colTA.getName()));
                    theElements.add(v);
                }
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error trying to read distinct values in column " + colTA.getName() + "," + colCA.getName() + ": " + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4CompilerError("DB Connection closed when counting elements in column " + colCA.getId() + ": " + dbe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var9_13 = null;
        DB.closeResultSet(rs);
        theElements.trimToSize();
        Value[] El = new Value[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            El[i] = (Value)theElements.get(i);
            ++i;
        }
        return El;
    }

    public Value[] getCountOfElements(Column colCA, Column colTA, long sampleSize) throws DbConnectionClosed, M4CompilerError {
        Vector<Value> theElements = new Vector<Value>();
        ResultSet rs = null;
        try {
            try {
                Columnset cs = colTA.getColumnset();
                String tableName = cs.getSchemaPlusName();
                String query = "SELECT COUNT(*) FROM " + tableName;
                String rowcount = this.executeBusinessSingleValueSqlRead(query);
                this.doPrint(12, "Sample " + sampleSize + " of " + rowcount);
                double sampleRatio = (double)sampleSize / (double)Long.parseLong(rowcount) * 100.0;
                this.doPrint(12, "SampleRatio:" + sampleRatio + "%");
                if (sampleRatio < 100.0) {
                    Vector<String> selectedCols = new Vector<String>();
                    selectedCols.add(colCA.getName().toUpperCase());
                    selectedCols.add(colTA.getName().toUpperCase());
                    tableName = "SAMPLE_" + cs.getId();
                    String tmpTableName = "TMP_" + cs.getId();
                    new DrawSample(colCA.getColumnset(), selectedCols, tableName, tmpTableName, new Long(rowcount), sampleSize, null, this);
                    query = "SELECT " + colTA.getName() + ", " + colCA.getName() + ", COUNT(" + colTA.getName() + ") AS ItemsCount " + " FROM " + tableName + " GROUP BY " + colTA.getName() + ", " + colCA.getName() + " ORDER BY " + colTA.getName();
                } else {
                    query = "SELECT " + colTA.getSQLDefinition() + " " + colTA.getName() + ", " + colCA.getSQLDefinition() + " " + colCA.getName() + ", COUNT(" + colTA.getSQLDefinition() + ") AS ItemsCount " + " FROM " + tableName + " GROUP BY " + colTA.getSQLDefinition() + ", " + colCA.getSQLDefinition() + " ORDER BY " + colTA.getSQLDefinition();
                }
                this.doPrint(2, "DB Query: " + query);
                rs = this.executeBusinessSqlRead(query);
                while (rs.next()) {
                    Value v;
                    try {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("edu.udo.miningmart.m4.core.Value");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        v = (Value)this.createNewInstance(clazz);
                    }
                    catch (M4Exception e) {
                        throw new M4CompilerError("Could not create Value:\n" + e.getMessage());
                    }
                    v.setValue(String.valueOf(rs.getString("ItemsCount")) + "," + rs.getString(colCA.getName()) + "," + rs.getString(colTA.getName()));
                    theElements.add(v);
                }
                this.dropBusinessTable(tableName);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error trying to read distinct values in column " + colTA.getName() + "," + colCA.getName() + ": " + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4CompilerError("DB Connection closed when counting elements in column " + colCA.getId() + ": " + dbe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var16_19 = null;
        DB.closeResultSet(rs);
        theElements.trimToSize();
        Value[] El = new Value[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            El[i] = (Value)theElements.get(i);
            ++i;
        }
        return El;
    }

    /*
     * Unable to fully structure code
     */
    public Value[][] getFrquencyTable(Column theClassAttribute, Feature[] theAttributes, Value[] classValues) throws M4CompilerError, M4Exception {
        block41: {
            CA = classValues;
            Attr = new ArrayList<String>();
            AVal = new ArrayList<long[]>();
            query = "SELECT * FROM ";
            t = "";
            i = 0;
            while (i < theAttributes.length) {
                t = i == 0 ? theAttributes[i].getName() : String.valueOf(t) + ", " + theAttributes[i].getName();
                s = "SELECT DISTINCT " + theAttributes[i].getName() + " FROM " + theClassAttribute.getColumnset().getName() + " ORDER BY " + theAttributes[i].getName();
                if (i != 0) {
                    query = String.valueOf(query) + ", ";
                }
                query = String.valueOf(query) + "(" + s + ")";
                ++i;
            }
            query = String.valueOf(query) + " ORDER BY " + t;
            rs = null;
            try {
                try {
                    rs = this.executeBusinessSqlRead(query);
                    while (rs.next()) {
                        s = rs.getString(theAttributes[0].getName());
                        i = 1;
                        while (i < theAttributes.length) {
                            s = String.valueOf(s) + ", " + rs.getString(theAttributes[i].getName());
                            ++i;
                        }
                        Attr.add(s);
                        AVal.add(new long[CA.length + 1]);
                    }
                    Attr.add("Total");
                    AVal.add(new long[CA.length + 1]);
                    break block41;
                }
                catch (SQLException sqle) {
                    s = "Error trying to read distinct values in columns " + theAttributes[0].getName();
                    i = 1;
                    ** while (i < theAttributes.length)
                }
lbl-1000:
                // 1 sources

                {
                    s = String.valueOf(s) + ", " + theAttributes[i].getName();
                    ++i;
                    continue;
                }
lbl44:
                // 1 sources

                s = String.valueOf(s) + ": " + sqle.getMessage();
                throw new M4CompilerError(s);
                catch (DbConnectionClosed dbe) {
                    throw new M4CompilerError("DB Connection closed when computing frequency table: " + dbe.getMessage());
                }
            }
            catch (Throwable s) {
                var17_22 = null;
                DB.closeResultSet(rs);
                throw s;
            }
        }
        var17_23 = null;
        DB.closeResultSet(rs);
        try {
            try {
                i = 0;
                while (i < CA.length) {
                    s = theAttributes[0].getName();
                    n = 1;
                    while (n < theAttributes.length) {
                        s = String.valueOf(s) + " || ', ' || " + theAttributes[n].getName();
                        ++n;
                    }
                    query = "SELECT (" + s + ") AS Label, Count(*) as Freq " + " FROM " + theClassAttribute.getColumnset().getName() + " WHERE " + theClassAttribute.getName() + " = '" + CA[i].getValue() + "'" + " GROUP BY ";
                    s = theAttributes[0].getName();
                    n = 1;
                    while (n < theAttributes.length) {
                        s = String.valueOf(s) + ", " + theAttributes[n].getName();
                        ++n;
                    }
                    query = String.valueOf(query) + s;
                    rs = this.executeBusinessSqlRead(query);
                    n = 0;
                    while (rs.next()) {
                        s = rs.getString("Label");
                        while (!s.equals(Attr.get(n))) {
                            ++n;
                        }
                        ((long[])AVal.get((int)n))[i] = Long.parseLong(rs.getString("Freq"));
                    }
                    ++i;
                }
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("SQL Error when accessing frequency table: " + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4CompilerError("DB Connection closed when accessing frequency table: " + dbe.getMessage());
            }
        }
        catch (Throwable var13_24) {
            var18_27 = null;
            DB.closeResultSet(rs);
            throw var13_24;
        }
        var18_28 = null;
        DB.closeResultSet(rs);
        retVal = new Value[Attr.size()][CA.length + 2];
        sumCA = new long[CA.length + 1];
        i = 0;
        while (i < Attr.size() - 1) {
            v0 = retVal[i];
            v1 = CompilerDatabaseService.class$1;
            if (v1 == null) {
                try {
                    v1 = Class.forName("edu.udo.miningmart.m4.core.Value");
                }
                catch (ClassNotFoundException v2) {
                    throw new NoClassDefFoundError(v2.getMessage());
                }
            }
            v0[0] = (Value)this.createNewInstance(v1);
            retVal[i][0].setValue((String)Attr.get(i));
            val = (long[])AVal.get(i);
            sum = 0L;
            n = 0;
            while (n < CA.length) {
                v3 = retVal[i];
                v4 = CompilerDatabaseService.class$1;
                if (v4 == null) {
                    try {
                        v4 = Class.forName("edu.udo.miningmart.m4.core.Value");
                    }
                    catch (ClassNotFoundException v5) {
                        throw new NoClassDefFoundError(v5.getMessage());
                    }
                }
                v3[n + 1] = (Value)this.createNewInstance(v4);
                sum += val[n];
                retVal[i][n + 1].setValue(Long.toString(val[n]));
                sumCA[n] = sumCA[n] + val[n];
                ++n;
            }
            v6 = retVal[i];
            v7 = CA.length + 1;
            v8 = CompilerDatabaseService.class$1;
            if (v8 == null) {
                try {
                    v8 = Class.forName("edu.udo.miningmart.m4.core.Value");
                }
                catch (ClassNotFoundException v9) {
                    throw new NoClassDefFoundError(v9.getMessage());
                }
            }
            v6[v7] = (Value)this.createNewInstance(v8);
            retVal[i][CA.length + 1].setValue(Long.toString(sum));
            ++i;
        }
        i = Attr.size() - 1;
        v10 = retVal[i];
        v11 = CompilerDatabaseService.class$1;
        if (v11 == null) {
            try {
                v11 = CompilerDatabaseService.class$1 = Class.forName("edu.udo.miningmart.m4.core.Value");
            }
            catch (ClassNotFoundException v12) {
                throw new NoClassDefFoundError(v12.getMessage());
            }
        }
        v10[0] = (Value)this.createNewInstance(v11);
        retVal[i][0].setValue((String)Attr.get(i));
        sum = 0L;
        n = 0;
        while (n < CA.length) {
            v13 = retVal[i];
            v14 = CompilerDatabaseService.class$1;
            if (v14 == null) {
                try {
                    v14 = Class.forName("edu.udo.miningmart.m4.core.Value");
                }
                catch (ClassNotFoundException v15) {
                    throw new NoClassDefFoundError(v15.getMessage());
                }
            }
            v13[n + 1] = (Value)this.createNewInstance(v14);
            sum += sumCA[n];
            retVal[i][n + 1].setValue(Long.toString(sumCA[n]));
            ++n;
        }
        v16 = retVal[i];
        v17 = CA.length + 1;
        v18 = CompilerDatabaseService.class$1;
        if (v18 == null) {
            try {
                v18 = CompilerDatabaseService.class$1 = Class.forName("edu.udo.miningmart.m4.core.Value");
            }
            catch (ClassNotFoundException v19) {
                throw new NoClassDefFoundError(v19.getMessage());
            }
        }
        v16[v17] = (Value)this.createNewInstance(v18);
        retVal[i][CA.length + 1].setValue(Long.toString(sum));
        return retVal;
    }

    public String computeNumberOfElementsForValue(Column col, String value) throws M4CompilerError {
        try {
            Columnset cs = col.getColumnset();
            String valueForQuery = col.getColumnDataType() == 13L ? DB.quote(value) : value;
            String query = "SELECT COUNT(*) FROM " + cs.getSchemaPlusName() + " WHERE " + col.getSQLDefinition() + " = " + valueForQuery;
            String sum = this.executeBusinessSingleValueSqlRead(query);
            return sum;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL error when computing no of elements per Value for column " + col.getId() + ": " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when computing no of elements per Value for column " + col.getId() + ": " + dbe.getMessage());
        }
    }

    public void executeDBProcedure(String procedureName, String[] parameters, boolean businessDb) throws M4CompilerError {
        try {
            DbCore dbc = businessDb ? this.getBusinessDbCore() : this.getM4DbCore();
            dbc.executeDBProcedure(procedureName, parameters);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL error executing a stored procedure: " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when executing a stored procedure: " + dbe.getMessage());
        }
    }

    public Value[] getDistinctElements(Column col) throws M4CompilerError {
        Vector<Value> theElements = new Vector<Value>();
        ResultSet rs = null;
        try {
            try {
                String query = "SELECT distinct(" + col.getName() + ") " + "FROM " + col.getColumnset().getName();
                rs = this.executeBusinessSqlRead(query);
                while (rs.next()) {
                    Value v;
                    try {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("edu.udo.miningmart.m4.core.Value");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        v = (Value)this.createNewInstance(clazz);
                    }
                    catch (M4Exception e) {
                        throw new M4CompilerError("Could not create Value:\n" + e.getMessage());
                    }
                    v.setValue(rs.getString(col.getName()));
                    theElements.add(v);
                }
                rs.close();
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error trying to read distinct values in column " + col.getName() + ": " + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4CompilerError("DB Connection closed when reading distinct values for column " + col.getId() + ": " + dbe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var8_12 = null;
        DB.closeResultSet(rs);
        theElements.trimToSize();
        Value[] distEl = new Value[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            distEl[i] = (Value)theElements.get(i);
            ++i;
        }
        return distEl;
    }

    public Value[] getDistinctElements(long columnId) throws M4CompilerError {
        try {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("edu.udo.miningmart.m4.core.Column");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.getDistinctElements((Column)this.getM4Object(columnId, clazz));
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 error when reading distinct elements for Column with Id " + columnId + ": " + m4e.getMessage());
        }
    }

    public Value[] getDistinctElementsWithoutNull(Column col) throws M4CompilerError {
        Vector<Value> theElements = new Vector<Value>();
        ResultSet rs = null;
        try {
            try {
                String query = "SELECT distinct(" + col.getName() + ") " + "FROM " + col.getColumnset().getName();
                rs = this.executeBusinessSqlRead(query);
                while (rs.next()) {
                    Value v;
                    String s = rs.getString(col.getName());
                    if (rs.wasNull()) continue;
                    try {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("edu.udo.miningmart.m4.core.Value");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        v = (Value)this.createNewInstance(clazz);
                    }
                    catch (M4Exception e) {
                        throw new M4CompilerError("Could not create Value:\n" + e.getMessage());
                    }
                    v.setValue(s);
                    theElements.add(v);
                }
                rs.close();
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error trying to read distinct values in column " + col.getName() + ": " + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4CompilerError("DB Connection closed when reading distinct values for column " + col.getId() + ": " + dbe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var9_13 = null;
        DB.closeResultSet(rs);
        theElements.trimToSize();
        Value[] distEl = new Value[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            distEl[i] = (Value)theElements.get(i);
            ++i;
        }
        return distEl;
    }

    private static String nullToNULL(String s) {
        return s == null ? "NULL" : s;
    }

    private static String nullToNULLquote(String s) {
        return s == null ? "NULL" : "'" + s.trim() + "'";
    }

    public Collection getInputConceptsFor(Step step) throws M4Exception {
        Vector<ParameterObject> ret = new Vector<ParameterObject>();
        Iterator it = step.getParameters().iterator();
        while (it.hasNext()) {
            ParameterObject parObj;
            Parameter parameter = (Parameter)it.next();
            if (!parameter.isInputParam() || !((parObj = parameter.getTheParameterObject()) instanceof Concept)) continue;
            ret.add(parObj);
        }
        return ret;
    }

    private DbCore getM4DbCore() throws DbConnectionClosed {
        if (this.cal.getStopRequest()) {
            this.stopDbThreads();
        }
        return this.m4Dbc;
    }

    private DbCore getBusinessDbCore() throws DbConnectionClosed {
        if (this.cal.getStopRequest()) {
            this.stopDbThreads();
        }
        return this.busiDbc;
    }

    private void stopDbThreads() throws DbConnectionClosed {
        this.m4Dbc.stopDbThread();
        this.busiDbc.stopDbThread();
        throw new DbConnectionClosed("Requested to stop DB threads.");
    }
}

