/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.wizard;

import com.syllogic.miningmart.concepteditor.db.DBConnectInfo;
import com.syllogic.miningmart.concepteditor.db.DBObject;
import com.syllogic.miningmart.concepteditor.db.DBUtil;
import com.syllogic.miningmart.concepteditor.dialogs.MapColumnsPanel;
import com.syllogic.miningmart.concepteditor.util.Constants;
import com.syllogic.miningmart.concepteditor.wizard.Wizard;
import com.syllogic.miningmart.concepteditor.wizard.WizardScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import org.apache.log4j.Logger;

public class M2mWizardScreen3
extends WizardScreen {
    private static Logger logger = Logger.getLogger((String)"M2mWizardSceen3");
    private String titleText = "\n Step 2: Define keys for the relation between crosstable and from Concept:\n";
    private JTextArea titleTextArea = new JTextArea(this.titleText);
    private String fromColumnSetLabel = "ColumnSet associated with the from Concept: ";
    private String crosstableLabel = "ColumnSet associated with the crosstable: ";
    private String fromColumnSetColumnTitle = "From ColumnSet";
    private String crosstableColumnTitle = "Crosstable";
    private MapColumnsPanel mapColumnsPanel = new MapColumnsPanel(this.fromColumnSetLabel, this.crosstableLabel, this.fromColumnSetColumnTitle, this.crosstableColumnTitle);
    private ColumnSet fromColumnSet = null;
    private List dbObjectColumnNames = null;
    private List dbObjectColumnTypes = null;

    public M2mWizardScreen3() {
        this.initGUI();
    }

    public M2mWizardScreen3(Wizard wizard) {
        super(wizard);
        this.initGUI();
    }

    protected void initGUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(Constants.LIGHT_GREY);
        this.titleTextArea.setEditable(false);
        this.titleTextArea.setLineWrap(true);
        this.titleTextArea.setWrapStyleWord(true);
        this.titleTextArea.setPreferredSize(new Dimension(580, 60));
        this.titleTextArea.setBackground(Constants.LIGHT_GREY);
        String fontName = this.titleTextArea.getFont().getName();
        this.titleTextArea.setFont(new Font(fontName, 1, 16));
        this.add((Component)this.titleTextArea, "North");
        this.add((Component)this.mapColumnsPanel, "Center");
        this.setCanProceed(false);
    }

    protected void init() {
        DBObject dbObject = (DBObject)this.inputInfo.get("DBObject");
        String dbObjectName = dbObject.getName();
        String selectColumns = "SELECT column_name, data_type FROM \tUSER_TAB_COLUMNS WHERE table_name = '" + dbObjectName + "'";
        Map columnNamesMap = null;
        try {
            columnNamesMap = DBUtil.executeSQLQ(DBConnectInfo.getDBConnectInfo(), selectColumns, 5000);
        }
        catch (SQLException e) {
            logger.error((Object)"Query to find column names failed", (Throwable)e);
            String message = "Query to find column names failed";
            JOptionPane.showMessageDialog(this, message, "Error", 0);
            return;
        }
        this.dbObjectColumnNames = (List)columnNamesMap.get("COLUMN_NAME");
        this.dbObjectColumnTypes = (List)columnNamesMap.get("DATA_TYPE");
        String fromColumnSetName = this.fromColumnSet.getName();
        ArrayList fromColumnNames = new ArrayList();
        this.fillColumnNames(this.fromColumnSet, fromColumnNames);
        this.mapColumnsPanel.initForEdit(fromColumnSetName, fromColumnNames, dbObjectName, this.dbObjectColumnNames);
    }

    private void fillColumnNames(ColumnSet columnSet, Collection columns) {
        columns.clear();
        Collection allColumns = columnSet.getAllColumns();
        Iterator i = allColumns.iterator();
        while (i.hasNext()) {
            Column aColumn = (Column)i.next();
            columns.add(aColumn.getName());
        }
    }

    public void setFromColumnSet(ColumnSet fromColumnSet) {
        this.fromColumnSet = fromColumnSet;
    }

    public boolean canProceed() {
        if (this.mapColumnsPanel.atLeastOneKeyDefined()) {
            Map selectedFromColumns = this.mapColumnsPanel.getSelectedFromColumnSetColumns();
            Map selectedToColumns = this.mapColumnsPanel.getSelectedToColumnSetColumns();
            this.screenInfo.clear();
            this.screenInfo.putAll(this.inputInfo);
            this.screenInfo.put("FromColumnSetColumns", selectedFromColumns);
            this.screenInfo.put("FromColumnSetCrosstableColumns", selectedToColumns);
            this.screenInfo.put("DBObjectColumnNames", this.dbObjectColumnNames);
            this.screenInfo.put("DBObjectColumnTypes", this.dbObjectColumnTypes);
            return true;
        }
        return false;
    }
}

