/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import com.syllogic.miningmart.concepteditor.util.PanelCreator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.PrimaryKey;
import miningmart.m4.Relationship;
import org.apache.log4j.Logger;

public class OneToManyRelationDialog
extends JDialog
implements ActionListener,
Closeable {
    private static Logger logger = Logger.getLogger((String)"OneToManyRelationDialog");
    private Frame parentFrame;
    private List fromConceptBaseAttributes = new ArrayList();
    private List toConceptBaseAttributes = new ArrayList();
    private Map selectedToConceptBaseAttributes = new HashMap();
    private Map selectedFromConceptBaseAttributes = new HashMap();
    private final String[] columnNames = new String[]{"FromConcept", "ToConcept"};
    private int numberOfRows = 1;
    private ColumnSet toConceptColumnSet;
    private PrimaryKey toConceptPK;
    private boolean cancelPressed = false;
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton addFieldButton = new JButton();
    private JTextField fromConceptTextField = new JTextField();
    private JTextField toConceptTextField = new JTextField();
    private MyTableModel tableModel = new MyTableModel();
    private JTable table = new JTable(this.tableModel);
    JComboBox fromConceptComboBox = new JComboBox();
    JComboBox toConceptComboBox = new JComboBox();

    public OneToManyRelationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setParent(parent);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("Define one-to-many relationship");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OneToManyRelationDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        PanelCreator aPanelCreator = new PanelCreator();
        GridBagConstraints defaultCon = new GridBagConstraints();
        String infoMessage = "Here the single-to-many relationship can be defined between the FromConcept and the ToConcept. The FromConcept contains the ForeignKey and the ToConcept contains the PrimaryKey.Below the attribute(s) that is(are) key should be matched.";
        JTextArea infoMessageTextArea = new JTextArea(infoMessage);
        infoMessageTextArea.setEditable(false);
        infoMessageTextArea.setLineWrap(true);
        infoMessageTextArea.setWrapStyleWord(true);
        infoMessageTextArea.setBorder(BorderFactory.createEtchedBorder());
        infoMessageTextArea.setPreferredSize(new Dimension(480, 80));
        defaultCon.anchor = 10;
        defaultCon.gridx = 0;
        defaultCon.gridwidth = 0;
        defaultCon.weightx = 100.0;
        aPanelCreator.addComponent(null, (Component)infoMessageTextArea, defaultCon);
        aPanelCreator.addEmptyLine();
        GridBagConstraints labelCon = new GridBagConstraints();
        labelCon.gridx = 0;
        labelCon.anchor = 13;
        labelCon.gridwidth = 1;
        labelCon.weightx = 8.0;
        String fromConceptLabel = "From Concept: ";
        this.fromConceptTextField.setText("No From Concept available");
        this.fromConceptTextField.setEditable(false);
        this.fromConceptTextField.setBorder(BorderFactory.createEtchedBorder());
        defaultCon.gridx = 1;
        defaultCon.anchor = 17;
        defaultCon.weightx = 92.0;
        aPanelCreator.addComponent(fromConceptLabel, labelCon, this.fromConceptTextField, defaultCon);
        String toConceptLabel = "To Concept: ";
        this.toConceptTextField.setText("No To Concept available");
        this.toConceptTextField.setEditable(false);
        this.toConceptTextField.setBorder(BorderFactory.createEtchedBorder());
        defaultCon.gridx = 1;
        defaultCon.anchor = 17;
        defaultCon.weightx = 83.0;
        aPanelCreator.addComponent(toConceptLabel, labelCon, this.toConceptTextField, defaultCon);
        aPanelCreator.addEmptyLine();
        this.setUpFromConceptColumn();
        this.setUpToConceptColumn();
        this.table.setPreferredScrollableViewportSize(new Dimension(480, 80));
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        defaultCon.anchor = 10;
        defaultCon.gridx = 0;
        defaultCon.gridwidth = 0;
        defaultCon.weightx = 100.0;
        aPanelCreator.addComponent(null, (Component)tableScrollPane, defaultCon);
        this.addFieldButton.setText("Add Key definition field");
        this.addFieldButton.setActionCommand("Add Key definition field");
        this.addFieldButton.setMnemonic('A');
        this.addFieldButton.addActionListener(this);
        defaultCon.anchor = 17;
        defaultCon.gridx = 0;
        defaultCon.gridwidth = 2;
        defaultCon.weighty = 1.0;
        defaultCon.weightx = 35.0;
        aPanelCreator.addComponent(null, (Component)this.addFieldButton, defaultCon);
        aPanelCreator.addEmptyLine();
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(this);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)aPanelCreator.getPanel(), "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        ((Component)this).setSize(500, 400);
    }

    public void initForEdit(Relationship relationship) {
        Concept toConcept = relationship.getToConcept();
        Concept fromConcept = relationship.getFromConcept();
        this.fromConceptTextField.setText(fromConcept.getName());
        this.toConceptTextField.setText(toConcept.getName());
        this.fillBaseAttributes(fromConcept, this.fromConceptBaseAttributes);
        this.fillBaseAttributes(toConcept, this.toConceptBaseAttributes);
        this.fillComboBox(this.fromConceptComboBox, this.fromConceptBaseAttributes);
        this.fillComboBox(this.toConceptComboBox, this.toConceptBaseAttributes);
        this.setInitialSelection(relationship);
    }

    private void setInitialSelection(Relationship relationship) {
        this.selectedToConceptBaseAttributes.clear();
        this.selectedFromConceptBaseAttributes.clear();
        this.toConceptColumnSet = null;
        this.toConceptPK = null;
        Collection columnSets = relationship.getToConcept().getAllColumnSets();
        ColumnSet toConceptColumnSet = (ColumnSet)columnSets.iterator().next();
        PrimaryKey toConceptPK = toConceptColumnSet.getPrimaryKey();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(toConceptPK != null ? "PrimaryKey found" : "PrimaryKey not found"));
        }
        if (toConceptPK != null) {
            Collection pkColumns = toConceptPK.getAllColumns();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Nr of pk columns: " + pkColumns.size()));
            }
            int row = 0;
            Iterator i = pkColumns.iterator();
            while (i.hasNext()) {
                Column aPkColumn = (Column)i.next();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(aPkColumn != null ? "PrimaryKey Column found" : "PrimaryKey Column not found"));
                }
                BaseAttribute aBaseAttribute = aPkColumn.getBaseAttribute();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(aBaseAttribute != null ? "BaseAttribute found" : "BaseAttribute not found"));
                }
                String aPkBaseAttributeName = aPkColumn.getBaseAttribute().getName();
                this.selectedToConceptBaseAttributes.put(new Integer(row), aPkBaseAttributeName);
                this.selectedFromConceptBaseAttributes.put(new Integer(row), "<NONE...>");
                ++row;
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Nr of rows: " + row));
            }
            this.numberOfRows = row;
        } else {
            this.selectedToConceptBaseAttributes.put(new Integer(0), "<NONE...>");
            this.selectedFromConceptBaseAttributes.put(new Integer(0), "<NONE...>");
            this.numberOfRows = 1;
        }
    }

    private void fillBaseAttributes(Concept concept, List baseAttributes) {
        baseAttributes.clear();
        Collection allBaseAttributes = concept.getAllBaseAttributes();
        Iterator i = allBaseAttributes.iterator();
        while (i.hasNext()) {
            BaseAttribute aBaseAttribute = (BaseAttribute)i.next();
            baseAttributes.add(aBaseAttribute.getName());
        }
        Collections.sort(baseAttributes);
    }

    private void fillComboBox(JComboBox comboBox, List baseAttributes) {
        comboBox.removeAllItems();
        Iterator i = baseAttributes.iterator();
        while (i.hasNext()) {
            String aName = (String)i.next();
            comboBox.addItem(aName);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("OK")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK button accessed");
            }
            this.doOK();
        } else if (command.equalsIgnoreCase("Cancel")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancel button accessed");
            }
            this.doCancel();
        } else if (command.equalsIgnoreCase("Add Key definition field")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Add Key definition field");
            }
            this.doAddField();
        }
    }

    private boolean atLeastOneKeyDefined() {
        int i = 0;
        while (i < this.numberOfRows) {
            String fromSelection = (String)this.selectedFromConceptBaseAttributes.get(new Integer(i));
            String toSelection = (String)this.selectedToConceptBaseAttributes.get(new Integer(i));
            if (!fromSelection.equals("<NONE...>") && !fromSelection.equals("<NONE...>")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void doOK() {
        if (!this.atLeastOneKeyDefined()) {
            logger.warn((Object)"No matching keys have been selected!");
            String message = "No matching keys have been selected!\nPlease select at least one matching key pair.";
            JOptionPane.showMessageDialog(null, message, "Input check", 2);
            return;
        }
        ((Component)this).setVisible(false);
        this.setCancelPressed(false);
    }

    private void doCancel() {
        this.close();
    }

    public void close() {
        ((Component)this).setVisible(false);
        this.setCancelPressed(true);
    }

    private void doAddField() {
        this.tableModel.setValueAt("<NONE...>", this.numberOfRows, 0);
        this.tableModel.setValueAt("<NONE...>", this.numberOfRows, 1);
        ++this.numberOfRows;
        this.table.updateUI();
    }

    public Map getSelectedToConceptBaseAttributes() {
        return this.selectedToConceptBaseAttributes;
    }

    public Map getSelectedFromConceptBaseAttributes() {
        return this.selectedFromConceptBaseAttributes;
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }

    private void setParent(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    private void setUpToConceptColumn() {
        TableColumn toConceptColumn = this.table.getColumnModel().getColumn(1);
        toConceptColumn.setCellEditor(new DefaultCellEditor(this.toConceptComboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for list of BaseAttributes");
        toConceptColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = toConceptColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText("Click to see a list of choices");
        }
    }

    private void setUpFromConceptColumn() {
        TableColumn fromConceptColumn = this.table.getColumnModel().getColumn(0);
        fromConceptColumn.setCellEditor(new DefaultCellEditor(this.fromConceptComboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for list of BaseAttributes");
        fromConceptColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = fromConceptColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText("Click to see a list of choices");
        }
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private void setCancelPressed(boolean value) {
        this.cancelPressed = value;
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        public String getColumnName(int col) {
            return OneToManyRelationDialog.this.columnNames[col];
        }

        public int getRowCount() {
            return OneToManyRelationDialog.this.numberOfRows;
        }

        public int getColumnCount() {
            return OneToManyRelationDialog.this.columnNames.length;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return OneToManyRelationDialog.this.selectedFromConceptBaseAttributes.get(new Integer(row));
            }
            if (col == 1) {
                return OneToManyRelationDialog.this.selectedToConceptBaseAttributes.get(new Integer(row));
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                OneToManyRelationDialog.this.selectedFromConceptBaseAttributes.put(new Integer(row), value);
                this.fireTableCellUpdated(row, col);
            } else if (col == 1) {
                OneToManyRelationDialog.this.selectedToConceptBaseAttributes.put(new Integer(row), value);
                this.fireTableCellUpdated(row, col);
            }
        }
    }
}

