/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.util.Constants;
import com.syllogic.miningmart.concepteditor.util.PanelCreator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class MapColumnsPanel
extends JPanel
implements ActionListener {
    private static Logger logger = Logger.getLogger((String)"MapColumnsPanel");
    private Collection fromColumnSetColumns = new ArrayList();
    private Collection toColumnSetColumns = new ArrayList();
    private Map selectedToColumnSetColumns = new HashMap();
    private Map selectedFromColumnSetColumns = new HashMap();
    private final String[] columnNames = new String[]{"Column1", "Column2"};
    private int numberOfRows = 1;
    private JButton addFieldButton = new JButton();
    private JTextField fromColumnSetTextField = new JTextField();
    private JTextField toColumnSetTextField = new JTextField();
    private MyTableModel tableModel;
    private JTable table;
    private JComboBox fromColumnSetComboBox = new JComboBox();
    private JComboBox toColumnSetComboBox = new JComboBox();
    private String fromColumnSetLabel;
    private String toColumnSetLabel;

    public MapColumnsPanel(String label1, String label2, String columnTitle1, String columnTitle2) {
        this.fromColumnSetLabel = label1;
        this.toColumnSetLabel = label2;
        this.columnNames[0] = columnTitle1;
        this.columnNames[1] = columnTitle2;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new GridLayout(1, 1));
        this.setBackground(Constants.LIGHT_GREY);
        PanelCreator aPanelCreator = new PanelCreator();
        GridBagConstraints defaultCon = new GridBagConstraints();
        aPanelCreator.addEmptyLine();
        GridBagConstraints labelCon = new GridBagConstraints();
        labelCon.gridx = 0;
        labelCon.anchor = 17;
        labelCon.gridwidth = 1;
        labelCon.weightx = 15.0;
        this.fromColumnSetTextField.setText("No object available");
        this.fromColumnSetTextField.setEditable(false);
        this.fromColumnSetTextField.setBorder(BorderFactory.createEtchedBorder());
        defaultCon.gridx = 1;
        defaultCon.anchor = 17;
        defaultCon.weightx = 85.0;
        defaultCon.gridwidth = 0;
        aPanelCreator.addComponent(this.fromColumnSetLabel, labelCon, this.fromColumnSetTextField, defaultCon);
        this.toColumnSetTextField.setText("No cross table available");
        this.toColumnSetTextField.setEditable(false);
        this.toColumnSetTextField.setBorder(BorderFactory.createEtchedBorder());
        defaultCon.gridx = 1;
        defaultCon.anchor = 17;
        defaultCon.weightx = 85.0;
        defaultCon.gridwidth = 0;
        aPanelCreator.addComponent(this.toColumnSetLabel, labelCon, this.toColumnSetTextField, defaultCon);
        aPanelCreator.addEmptyLine();
        this.tableModel = new MyTableModel();
        this.table = new JTable(this.tableModel);
        this.setUpFromColumnSetColumn();
        this.setUpToColumnSetColumn();
        this.table.setPreferredScrollableViewportSize(new Dimension(580, 80));
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        defaultCon.anchor = 10;
        defaultCon.gridx = 0;
        defaultCon.gridwidth = 0;
        defaultCon.weightx = 100.0;
        aPanelCreator.addComponent(null, (Component)tableScrollPane, defaultCon);
        this.addFieldButton.setText("Add Key definition field");
        this.addFieldButton.setActionCommand("Add Key definition field");
        this.addFieldButton.setMnemonic('A');
        this.addFieldButton.addActionListener(this);
        defaultCon.anchor = 17;
        defaultCon.gridx = 0;
        defaultCon.gridwidth = 2;
        defaultCon.weighty = 1.0;
        defaultCon.weightx = 35.0;
        aPanelCreator.addComponent(null, (Component)this.addFieldButton, defaultCon);
        aPanelCreator.addEmptyLine();
        JPanel centralPanel = aPanelCreator.getPanel();
        centralPanel.setBackground(Constants.LIGHT_GREY);
        this.add(centralPanel);
    }

    public void initForEdit(String fromColumnSetName, Collection fromColumnNames, String toColumnSetName, Collection toColumnNames) {
        this.fromColumnSetTextField.setText(fromColumnSetName);
        this.toColumnSetTextField.setText(toColumnSetName);
        this.fromColumnSetColumns = fromColumnNames;
        this.toColumnSetColumns = toColumnNames;
        this.fillComboBox(this.fromColumnSetComboBox, this.fromColumnSetColumns);
        this.fillComboBox(this.toColumnSetComboBox, this.toColumnSetColumns);
        this.selectedToColumnSetColumns.clear();
        this.selectedFromColumnSetColumns.clear();
        this.selectedToColumnSetColumns.put(new Integer(0), "<NONE...>");
        this.selectedFromColumnSetColumns.put(new Integer(0), "<NONE...>");
        this.numberOfRows = 1;
    }

    private void fillComboBox(JComboBox comboBox, Collection columns) {
        comboBox.removeAllItems();
        Iterator i = columns.iterator();
        while (i.hasNext()) {
            String aName = (String)i.next();
            comboBox.addItem(aName);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("Add Key definition field")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Add Key definition field");
            }
            this.doAddField();
        }
    }

    private void doAddField() {
        this.tableModel.setValueAt("<NONE...>", this.numberOfRows, 0);
        this.tableModel.setValueAt("<NONE...>", this.numberOfRows, 1);
        ++this.numberOfRows;
        this.table.updateUI();
    }

    public Map getSelectedToColumnSetColumns() {
        return this.selectedToColumnSetColumns;
    }

    public Map getSelectedFromColumnSetColumns() {
        return this.selectedFromColumnSetColumns;
    }

    private void setUpToColumnSetColumn() {
        TableColumn toColumnSetColumn = this.table.getColumnModel().getColumn(1);
        toColumnSetColumn.setCellEditor(new DefaultCellEditor(this.toColumnSetComboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for list of Columns");
        toColumnSetColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = toColumnSetColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText("Click to see a list of choices");
        }
    }

    private void setUpFromColumnSetColumn() {
        TableColumn fromColumnSetColumn = this.table.getColumnModel().getColumn(0);
        fromColumnSetColumn.setCellEditor(new DefaultCellEditor(this.fromColumnSetComboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for list of Columns");
        fromColumnSetColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = fromColumnSetColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText("Click to see a list of choices");
        }
    }

    public boolean atLeastOneKeyDefined() {
        int i = 0;
        while (i < this.numberOfRows) {
            String fromSelection = (String)this.selectedFromColumnSetColumns.get(new Integer(i));
            String toSelection = (String)this.selectedToColumnSetColumns.get(new Integer(i));
            if (!fromSelection.equals("<NONE...>") && !fromSelection.equals("<NONE...>")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        public String getColumnName(int col) {
            return MapColumnsPanel.this.columnNames[col];
        }

        public int getRowCount() {
            return MapColumnsPanel.this.numberOfRows;
        }

        public int getColumnCount() {
            return MapColumnsPanel.this.columnNames.length;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return MapColumnsPanel.this.selectedFromColumnSetColumns.get(new Integer(row));
            }
            if (col == 1) {
                return MapColumnsPanel.this.selectedToColumnSetColumns.get(new Integer(row));
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                MapColumnsPanel.this.selectedFromColumnSetColumns.put(new Integer(row), value);
                this.fireTableCellUpdated(row, col);
            } else if (col == 1) {
                MapColumnsPanel.this.selectedToColumnSetColumns.put(new Integer(row), value);
                this.fireTableCellUpdated(row, col);
            }
        }
    }
}

