/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.M4Interface;
import org.apache.log4j.Logger;

public class MapBaseAttributesDialog
extends JDialog
implements ActionListener,
Closeable {
    private static Logger logger = Logger.getLogger((String)"MapBaseAttributesDialog");
    private Frame parentFrame;
    private List baseAttributes = new ArrayList();
    private List columns = new ArrayList();
    private Map selectedColumns = new HashMap();
    private Map selectedPrimaryKeys = new HashMap();
    private final String[] columnNames = new String[]{"BaseAttribute", "Column", "PrimaryKey"};
    private JLabel titleText = new JLabel();
    private JPanel tablePanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private MyTableModel tableModel = new MyTableModel();
    private JTable table = new JTable(this.tableModel);
    JComboBox columnsComboBox = new JComboBox();

    public MapBaseAttributesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setParent(parent);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("Map BaseAttributes to Columns");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MapBaseAttributesDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        this.titleText.setText("Click on a Column cell and select a Column from the list: ");
        this.setUpColumnsColumn();
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 250));
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)new JScrollPane(this.table), "Center");
        this.tablePanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170), 1));
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(this);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)this.titleText, "North");
        this.getContentPane().add((Component)this.tablePanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    public void initForEdit(Concept concept, ColumnSet columnSet) {
        if (columnSet == null || concept == null) {
            logger.info((Object)"Concept and/or Columnset missing.");
            String message = "Concept and/or Columnset missing.\nCannot display dialog to map BaseAttributes";
            JOptionPane.showMessageDialog(this, message, "Error...", 2);
            return;
        }
        this.fillBaseAttributes(concept);
        this.fillColumns(columnSet);
        this.setInitialSelection();
        this.table.updateUI();
    }

    private void setInitialSelection() {
        this.selectedColumns.clear();
        this.selectedPrimaryKeys.clear();
        Iterator i = this.baseAttributes.iterator();
        while (i.hasNext()) {
            String aBaseAttributeName = (String)i.next();
            this.selectedColumns.put(aBaseAttributeName, "<NONE...>");
            this.selectedPrimaryKeys.put(aBaseAttributeName, new Boolean(false));
        }
    }

    private void fillBaseAttributes(Concept concept) {
        this.baseAttributes.clear();
        Collection allBaseAttributes = concept.getAllBaseAttributes();
        Iterator i = allBaseAttributes.iterator();
        while (i.hasNext()) {
            BaseAttribute aBaseAttribute = (BaseAttribute)i.next();
            this.baseAttributes.add(aBaseAttribute.getName());
        }
        Collections.sort(this.baseAttributes);
    }

    private void fillColumns(ColumnSet columnSet) {
        this.columns.clear();
        Collection allColumns = columnSet.getAllColumns();
        this.columns.add("<NONE...>");
        Iterator i = allColumns.iterator();
        while (i.hasNext()) {
            Column aColumn = (Column)i.next();
            this.columns.add(aColumn.getName());
        }
        Collections.sort(this.columns);
        this.columnsComboBox.removeAllItems();
        i = this.columns.iterator();
        while (i.hasNext()) {
            String aColumnName = (String)i.next();
            this.columnsComboBox.addItem(aColumnName);
        }
    }

    public void actionPerformed(ActionEvent e) {
        e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("OK")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK button accessed");
            }
            this.doOK();
        } else if (command.equalsIgnoreCase("Cancel")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancel button accessed");
            }
            this.doCancel();
        }
    }

    private boolean allBaseAttributesConnected() {
        Iterator i = this.selectedColumns.values().iterator();
        while (i.hasNext()) {
            String aValue = (String)i.next();
            if (!aValue.equalsIgnoreCase("<NONE...>")) continue;
            return false;
        }
        return true;
    }

    private void doOK() {
        if (!this.allBaseAttributesConnected()) {
            logger.warn((Object)"Not all BaseAttributes have been connected!");
            String message = "Not all BaseAttributes have been connected!\nDo you want to continue?";
            int choice = JOptionPane.showConfirmDialog(this, message, "Input check", 0, 3);
            if (choice != 0) {
                return;
            }
        }
        ((Component)this).setVisible(false);
    }

    private void doCancel() {
        this.close();
    }

    public void close() {
        ((Component)this).setVisible(false);
    }

    public Map getSelectedColumns() {
        return this.selectedColumns;
    }

    public Map getSelectedPrimaryKeys() {
        return this.selectedPrimaryKeys;
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }

    private void setParent(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    private void setUpColumnsColumn() {
        TableColumn columnsColumn = this.table.getColumnModel().getColumn(1);
        columnsColumn.setCellEditor(new DefaultCellEditor(this.columnsComboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for list of Columns");
        columnsColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = columnsColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText("Click to see a list of choices");
        }
    }

    public static void main(String[] args) {
        JFrame dataFrame = new JFrame();
        ((Component)dataFrame).setBounds(10, 10, 600, 400);
        ((Component)dataFrame).setVisible(true);
        M4Interface myInterface = M4Interface.getInstance();
        Case salesCase = null;
        try {
            salesCase = myInterface.findCaseForUpdate("DM_SALES_PREDICTION", true);
        }
        catch (M4Interface.CaseLockedException e) {
            logger.error((Object)"Case locked", (Throwable)e);
        }
        Concept shopSales = salesCase.getConcept("SHOP_SALE");
        ColumnSet shopSalesCS = shopSales.getColumnSet("DM_TIME_VALID");
        MapBaseAttributesDialog aDialog = new MapBaseAttributesDialog((Frame)dataFrame, true);
        aDialog.initForEdit(shopSales, shopSalesCS);
        aDialog.pack();
        ((Component)aDialog).setVisible(true);
        dataFrame.dispose();
        System.exit(0);
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        public String getColumnName(int col) {
            return MapBaseAttributesDialog.this.columnNames[col];
        }

        public int getRowCount() {
            return MapBaseAttributesDialog.this.baseAttributes.size();
        }

        public int getColumnCount() {
            return MapBaseAttributesDialog.this.columnNames.length;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return MapBaseAttributesDialog.this.baseAttributes.get(row);
            }
            if (col == 1) {
                return MapBaseAttributesDialog.this.selectedColumns.get(MapBaseAttributesDialog.this.baseAttributes.get(row));
            }
            if (col == 2) {
                return MapBaseAttributesDialog.this.selectedPrimaryKeys.get(MapBaseAttributesDialog.this.baseAttributes.get(row));
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                MapBaseAttributesDialog.this.selectedColumns.put(MapBaseAttributesDialog.this.baseAttributes.get(row), value);
                this.fireTableCellUpdated(row, col);
            } else if (col == 2) {
                MapBaseAttributesDialog.this.selectedPrimaryKeys.put(MapBaseAttributesDialog.this.baseAttributes.get(row), value);
                this.fireTableCellUpdated(row, col);
            }
        }
    }
}

