/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.dialogs.BaseAttributeDescriptionPanel;
import com.syllogic.miningmart.concepteditor.dialogs.BaseAttributePropertiesPanel;
import com.syllogic.miningmart.concepteditor.event.BaseAttributeEvent;
import com.syllogic.miningmart.concepteditor.event.BaseAttributeListener;
import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.CreateException;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;

public class BaseAttributeDialog
extends JDialog
implements ActionListener,
Closeable {
    private static Logger logger = Logger.getLogger((String)"BaseAttributeDialog");
    private ArrayList baListenerList = new ArrayList();
    public static final String NEWLINE = "\n";
    private int numberOfProperties = 4;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel southPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JTextArea messageTextArea = new JTextArea();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private BaseAttributePropertiesPanel propertiesTab = new BaseAttributePropertiesPanel();
    private BaseAttributeDescriptionPanel descriptionTab = new BaseAttributeDescriptionPanel();
    private BaseAttribute currentBaseAttribute;
    private BaseAttribute newBaseAttribute;
    private Concept currentConcept;

    public BaseAttributeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initGUI();
    }

    public void initForEdit(Concept concept, BaseAttribute baseAttribute) {
        if (concept == null && baseAttribute == null) {
            logger.error((Object)"Could properly initialize BaseAttribute dialog.");
            String message = "A initialization error occurred!\nCould properly initialize BaseAttribute dialog.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return;
        }
        this.tabbedPane.setSelectedIndex(0);
        this.setCurrentConcept(concept);
        this.currentBaseAttribute = null;
        if (baseAttribute == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"BaseAttribute is null, initializing for new BaseAttribute...");
            }
            this.initForNewBaseAttribute();
            return;
        }
        this.currentBaseAttribute = baseAttribute;
        this.propertiesTab.getNameTextField().setText(this.currentBaseAttribute.getName());
        this.propertiesTab.getBaseAttributeTypeComboBox().setSelectedItem(this.currentBaseAttribute.getAttributeType());
        this.propertiesTab.getDatatypeComboBox().setSelectedItem(this.currentBaseAttribute.getDatatype());
        if (this.currentBaseAttribute.getRelevance() != null && this.currentBaseAttribute.getRelevance().equalsIgnoreCase("YES")) {
            this.propertiesTab.getRelevanceCheckBox().setSelected(true);
        } else {
            this.propertiesTab.getRelevanceCheckBox().setSelected(false);
        }
        this.descriptionTab.getDescriptionTextArea().setText(this.currentBaseAttribute.getDocumentation());
    }

    private void initForNewBaseAttribute() {
        this.newBaseAttribute = null;
        this.propertiesTab.getNameTextField().setText("");
        this.propertiesTab.getBaseAttributeTypeComboBox().setSelectedItem(this.currentConcept.getConceptType());
        this.propertiesTab.getDatatypeComboBox().setSelectedItem("NOMINAL");
        this.propertiesTab.getRelevanceCheckBox().setSelected(false);
        this.descriptionTab.getDescriptionTextArea().setText("");
    }

    private void initGUI() {
        this.setTitle("BaseAttribute properties");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                BaseAttributeDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.southPanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170), 1));
        this.southPanel.add((Component)this.buttonPanel, "North");
        this.messageTextArea.setText("");
        this.messageTextArea.setBackground(new Color(212, 208, 200));
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setVerifyInputWhenFocusTarget(false);
        this.messageTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.messageTextArea.setMinimumSize(new Dimension(479, 18));
        this.messageTextArea.setPreferredSize(new Dimension(479, 18));
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(this);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.tabbedPane.add((Component)new JScrollPane(this.propertiesTab), "Properties");
        this.tabbedPane.add((Component)this.descriptionTab, "Description");
        int preferredHeight = (this.numberOfProperties + 1) * 20 + 80;
        this.tabbedPane.setPreferredSize(new Dimension(500, preferredHeight));
    }

    public void close() {
        this.currentBaseAttribute = null;
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("OK")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK button accessed");
            }
            this.doOKExisting();
        } else if (command.equalsIgnoreCase("Cancel")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancel button");
            }
            this.doCancel();
        }
    }

    private void doOKExisting() {
        if (this.currentBaseAttribute == null) {
            this.doOKNew();
            return;
        }
        String name = this.propertiesTab.getNameTextField().getText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BaseAttribute name: " + name));
        }
        if (name.equalsIgnoreCase("")) {
            logger.info((Object)"Name is not allowed to be empty.");
            String message = "Name is not allowed to be empty.\nPlease provide a name.";
            JOptionPane.showMessageDialog(this, message, "Name...?", 1);
            this.propertiesTab.getNameTextField().requestFocus();
            return;
        }
        if (!name.equals(this.currentBaseAttribute.getName())) {
            try {
                this.currentBaseAttribute.setName(name);
            }
            catch (NameExistsException e) {
                logger.info((Object)"There already exists a BaseAttribute with this name for this Concept.");
                String message = "There already exists a BaseAttribute with this name for this Concept.\nPlease provide another name.\n\n(Note: Names are case sensitive.)";
                JOptionPane.showMessageDialog(this, message, "Duplicate name...", 1);
                this.propertiesTab.getNameTextField().requestFocus();
                return;
            }
        }
        ((Component)this).setVisible(false);
        String type = (String)this.propertiesTab.getBaseAttributeTypeComboBox().getSelectedItem();
        if (type != this.currentBaseAttribute.getAttributeType()) {
            this.currentBaseAttribute.setAttributeType(type);
        }
        String datatype = (String)this.propertiesTab.getDatatypeComboBox().getSelectedItem();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Selected datatype is: " + datatype));
        }
        if (datatype != this.currentBaseAttribute.getDatatype()) {
            this.currentBaseAttribute.setDatatype(datatype);
        }
        boolean isRelevant = this.propertiesTab.getRelevanceCheckBox().isSelected();
        String currentRelevance = this.currentBaseAttribute.getRelevance();
        if (currentRelevance == null) {
            if (isRelevant) {
                this.currentBaseAttribute.setRelevance("YES");
            } else {
                this.currentBaseAttribute.setRelevance("NO");
            }
        } else if (isRelevant && !currentRelevance.equalsIgnoreCase("YES")) {
            this.currentBaseAttribute.setRelevance("YES");
        } else if (!isRelevant && currentRelevance.equalsIgnoreCase("YES")) {
            this.currentBaseAttribute.setRelevance("NO");
        }
        String oldDescription = this.currentBaseAttribute.getDocumentation();
        String description = this.descriptionTab.getDescriptionTextArea().getText();
        if (!description.equalsIgnoreCase(oldDescription)) {
            this.currentBaseAttribute.setDocumentation(description);
        }
        if (this.currentBaseAttribute.isChanged()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Trying to store a base Attribute...");
                    logger.debug((Object)("Name: " + this.currentBaseAttribute.getName()));
                    logger.debug((Object)("Type: " + this.currentBaseAttribute.getAttributeType()));
                    logger.debug((Object)("Datatype: " + this.currentBaseAttribute.getDatatype()));
                    logger.debug((Object)("Relevance: " + this.currentBaseAttribute.getRelevance()));
                }
                this.currentBaseAttribute.store();
            }
            catch (StorageException e) {
                logger.error((Object)"Could not store BaseAttribute record.", (Throwable)e);
                String message = "A data communication error occurred!\nCould not update the settings for the BaseAttribute.";
                JOptionPane.showMessageDialog(this, message, "Error", 2);
            }
            this.fireBaseAttributeChanged(this.currentConcept);
        }
    }

    private void doOKNew() {
        String name = this.propertiesTab.getNameTextField().getText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BaseAttribute name: " + name));
        }
        if (name.equalsIgnoreCase("")) {
            logger.info((Object)"Name is not allowed to be empty.");
            String message = "Name is not allowed to be empty.\nPlease provide a name.";
            JOptionPane.showMessageDialog(this, message, "Name...?", 1);
            this.propertiesTab.getNameTextField().requestFocus();
            return;
        }
        String type = (String)this.propertiesTab.getBaseAttributeTypeComboBox().getSelectedItem();
        String datatype = (String)this.propertiesTab.getDatatypeComboBox().getSelectedItem();
        boolean isRelevant = this.propertiesTab.getRelevanceCheckBox().isSelected();
        String description = this.descriptionTab.getDescriptionTextArea().getText();
        try {
            this.newBaseAttribute = this.currentConcept.createBaseAttribute(name, datatype, type);
        }
        catch (CreateException e) {
            logger.error((Object)"Could not create a new BaseAttribute.", (Throwable)e);
            String message = "A data communication error occurred!\nCould not create a new BaseAttribute.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return;
        }
        catch (NameExistsException e) {
            logger.info((Object)"There already exists a BaseAttribute with this name for this Concept.");
            String message = "There already exists a BaseAttribute with this name for this Concept.\nPlease provide another name.\n\n(Note: Names are case sensitive.)";
            JOptionPane.showMessageDialog(this, message, "Duplicate name...", 1);
            this.propertiesTab.getNameTextField().requestFocus();
            return;
        }
        ((Component)this).setVisible(false);
        if (isRelevant) {
            this.newBaseAttribute.setRelevance("YES");
        } else {
            this.newBaseAttribute.setRelevance("NO");
        }
        if (description != null || !description.equalsIgnoreCase("")) {
            this.newBaseAttribute.setDocumentation(description);
        }
        try {
            this.newBaseAttribute.store();
        }
        catch (StorageException e) {
            logger.error((Object)"Could not store BaseAttribute record.", (Throwable)e);
            String message = "A data communication error occurred!\nCould not update the settings for the BaseAttribute.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
        }
        this.fireBaseAttributeCreated(this.currentConcept);
    }

    public BaseAttribute getCreatedBaseAttribute() {
        return this.newBaseAttribute;
    }

    private void doCancel() {
        this.close();
    }

    private void setCurrentConcept(Concept concept) {
        this.currentConcept = concept;
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }

    public void addBaseAttributeListener(BaseAttributeListener l) {
        if (!this.baListenerList.contains(l)) {
            this.baListenerList.add(l);
        }
    }

    public void removeBaseAttributeListener(BaseAttributeListener l) {
        if (this.baListenerList.contains(l)) {
            ((AbstractCollection)this.baListenerList).remove(l);
        }
    }

    public void fireBaseAttributeChanged(Concept concept) {
        BaseAttributeEvent anEvent = new BaseAttributeEvent(this, concept);
        ArrayList aList = (ArrayList)this.baListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            BaseAttributeListener aListener = (BaseAttributeListener)aList.get(i);
            aListener.baseAttributeChanged(anEvent);
            ++i;
        }
    }

    public void fireBaseAttributeCreated(Concept concept) {
        BaseAttributeEvent anEvent = new BaseAttributeEvent(this, concept);
        ArrayList aList = (ArrayList)this.baListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            BaseAttributeListener aListener = (BaseAttributeListener)aList.get(i);
            aListener.baseAttributeCreated(anEvent);
            ++i;
        }
    }

    public void fireBaseAttributeDeleted(Concept concept) {
        BaseAttributeEvent anEvent = new BaseAttributeEvent(this, concept);
        ArrayList aList = (ArrayList)this.baListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            BaseAttributeListener aListener = (BaseAttributeListener)aList.get(i);
            aListener.baseAttributeDeleted(anEvent);
            ++i;
        }
    }
}

