/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.diagram;

import com.syllogic.jfc.diagram.DefaultDraggebleRelationRenderer;
import com.syllogic.jfc.diagram.DraggebleRelation;
import com.syllogic.miningmart.concepteditor.diagram.RelationshipComponent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class RelationshipRenderer
extends DefaultDraggebleRelationRenderer {
    private static final int WEST = 0;
    private static final int EAST = 1;
    private static final int NORTH = 2;
    private static final int SOUTH = 3;

    public Point[] getPoints(DraggebleRelation relationship, Rectangle fromRectangle, Rectangle toRectangle) {
        Point[] r = new Point[]{new Point(), new Point(), new Point(), new Point()};
        int midXFrom = fromRectangle.x + fromRectangle.width / 2;
        int midYFrom = fromRectangle.y + fromRectangle.height / 2;
        int rightSideFrom = fromRectangle.x + fromRectangle.width;
        int leftSideFrom = fromRectangle.x;
        int midXTo = toRectangle.x + toRectangle.width / 2;
        int midYTo = toRectangle.y + toRectangle.height / 2;
        int rightSideTo = toRectangle.x + toRectangle.width;
        int leftSideTo = toRectangle.x;
        if (relationship.getFromComponent() == relationship.getToComponent()) {
            Point p = relationship.getEndPoint(0);
            if (p == null) {
                p = new Point(100, 25);
                relationship.setEndPoint(0, p);
                r[0].x = rightSideFrom;
                r[0].y = fromRectangle.y + (int)((double)fromRectangle.height * ((double)p.y / 100.0));
                p = new Point(75, 0);
                relationship.setEndPoint(1, p);
                r[1].x = fromRectangle.x + (int)((double)fromRectangle.width * ((double)p.x / 100.0));
                r[1].y = fromRectangle.y;
                if (this.wantCubicLine(relationship)) {
                    p = new Point(fromRectangle.height / 4, -(fromRectangle.height / 4));
                    relationship.setEndPoint(2, p);
                    r[2].x = r[0].x + p.x;
                    r[2].y = r[0].y + p.y;
                    p = new Point(fromRectangle.width / 4, -(fromRectangle.width / 4));
                    relationship.setEndPoint(3, p);
                    r[3].x = r[1].x + p.x;
                    r[3].y = r[1].y + p.y;
                }
                return r;
            }
            r[0].x = rightSideFrom;
            r[0].y = fromRectangle.y + (int)((double)fromRectangle.height * ((double)p.y / 100.0));
            p = relationship.getEndPoint(1);
            r[1].x = toRectangle.x + (int)((double)toRectangle.width * ((double)p.x / 100.0));
            r[1].y = toRectangle.y;
            if (this.wantCubicLine(relationship)) {
                p = relationship.getEndPoint(2);
                r[2].x = r[0].x + p.x;
                r[2].y = r[0].y + p.y;
                p = relationship.getEndPoint(3);
                r[3].x = r[1].x + p.x;
                r[3].y = r[1].y + p.y;
            }
            return r;
        }
        Point p = relationship.getEndPoint(0);
        if (p == null) {
            p = new Point(midXFrom < midXTo ? 100 : 0, 50);
            relationship.setEndPoint(0, p);
            r[0].x = midXFrom < midXTo ? rightSideFrom : leftSideFrom;
            r[0].y = fromRectangle.y + (int)((double)fromRectangle.height * ((double)p.y / 100.0));
            p = new Point(midXTo > midXFrom ? 0 : 100, 50);
            relationship.setEndPoint(1, p);
            r[1].x = midXTo > midXFrom ? leftSideTo : rightSideTo;
            r[1].y = toRectangle.y + (int)((double)toRectangle.height * ((double)p.y / 100.0));
            if (this.wantCubicLine(relationship)) {
                p = new Point(25, 0);
                relationship.setEndPoint(2, p);
                r[2].x = midXFrom < midXTo ? r[0].x + p.x : r[0].x - p.x;
                r[2].y = r[0].y + p.y;
                relationship.setEndPoint(3, p);
                r[3].x = midXTo > midXFrom ? r[1].x - p.x : r[1].x + p.x;
                r[3].y = r[1].y + p.y;
            }
            return r;
        }
        r[0].x = midXFrom < midXTo ? rightSideFrom : leftSideFrom;
        r[0].y = fromRectangle.y + (int)((double)fromRectangle.height * ((double)p.y / 100.0));
        p = relationship.getEndPoint(1);
        r[1].x = midXTo > midXFrom ? leftSideTo : rightSideTo;
        r[1].y = toRectangle.y + (int)((double)toRectangle.height * ((double)p.y / 100.0));
        if (this.wantCubicLine(relationship)) {
            p = relationship.getEndPoint(2);
            r[2].x = midXFrom < midXTo ? r[0].x + p.x : r[0].x - p.x;
            r[2].y = r[0].y + p.y;
            p = relationship.getEndPoint(3);
            r[3].x = midXTo > midXFrom ? r[1].x - p.x : r[1].x + p.x;
            r[3].y = r[1].y + p.y;
        }
        return r;
    }

    private void drawArrow(Graphics g, Point point, int side, int size) {
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        xPoints[0] = point.x;
        yPoints[0] = point.y;
        xPoints[3] = point.x;
        yPoints[3] = point.y;
        switch (side) {
            case 0: {
                xPoints[1] = xPoints[0] - size;
                yPoints[1] = yPoints[0] + size;
                xPoints[2] = xPoints[0] - size;
                yPoints[2] = yPoints[0] - size;
                break;
            }
            case 1: {
                xPoints[1] = xPoints[0] + size;
                yPoints[1] = yPoints[0] + size;
                xPoints[2] = xPoints[0] + size;
                yPoints[2] = yPoints[0] - size;
                break;
            }
            case 2: {
                xPoints[1] = xPoints[0] - size;
                yPoints[1] = yPoints[0] - size;
                xPoints[2] = xPoints[0] + size;
                yPoints[2] = yPoints[0] - size;
                break;
            }
            case 3: {
                xPoints[1] = xPoints[0] - size;
                yPoints[1] = yPoints[0] + size;
                xPoints[2] = xPoints[0] + size;
                yPoints[2] = yPoints[0] + size;
            }
        }
        g.fillPolygon(xPoints, yPoints, 4);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Point[] aPoints = this.getPoints((DraggebleRelation)this.itsRelation, this.itsFromRectangle, this.itsToRectangle);
        Point aFromEndPoint = aPoints[0];
        Point aToEndPoint = aPoints[1];
        Point aFromCTRLPoint = aPoints[2];
        Point aToCTRLPoint = aPoints[3];
        int midXFrom = this.itsFromRectangle.x + this.itsFromRectangle.width / 2;
        int midYFrom = this.itsFromRectangle.y + this.itsFromRectangle.height / 2;
        int midXTo = this.itsToRectangle.x + this.itsToRectangle.width / 2;
        int midYTo = this.itsToRectangle.y + this.itsToRectangle.height / 2;
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        int arrowSize = 5;
        if (this.itsRelation.getFromComponent() == this.itsRelation.getToComponent()) {
            this.drawArrow(g, aToEndPoint, 2, arrowSize);
        } else if (midXFrom < midXTo) {
            this.drawArrow(g, aToEndPoint, 0, arrowSize);
        } else {
            this.drawArrow(g, aToEndPoint, 1, arrowSize);
        }
        String strName = ((RelationshipComponent)this.itsRelation).getRelationship().getName();
        int strNameMetrics = ((Component)this).getFontMetrics(this.getFont()).stringWidth(strName);
        if (strName == null) {
            return;
        }
        if (this.itsRelation.getFromComponent() == this.itsRelation.getToComponent()) {
            g.drawString(strName, aToCTRLPoint.x - strNameMetrics / 2, aToCTRLPoint.y - 10);
        } else {
            int xName = (this.itsFromRectangle.x + this.itsFromRectangle.width + this.itsToRectangle.x) / 2 - strNameMetrics / 2;
            int yName = (aFromCTRLPoint.y + aToCTRLPoint.y) / 2 - 10;
            g.drawString(strName, xName, yName);
        }
    }
}

