/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor;

import com.syllogic.miningmart.concepteditor.ConceptEditor;
import com.syllogic.miningmart.concepteditor.dialogs.SelectUtility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.Naming;
import java.util.Collection;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import miningmart.compilerInterface.CompilerAccess;
import miningmart.m4.Case;
import miningmart.m4.M4Interface;

public class ConceptEditorTestFrame
extends JFrame {
    static M4Interface myInterface;
    static String caseName;
    private JDesktopPane desktop = new JDesktopPane();
    private ConceptEditor conceptEditor = new ConceptEditor(this);
    private JMenuBar testFrameMenuBar = new JMenuBar();
    private JMenu testFrameFileMenu = new JMenu();
    private JMenuItem testFrameExitMenuItem = new JMenuItem();
    private static final String LOOKUP_STRING = "aCompilerAccessImpl";
    private static CompilerAccess compilerAccess;

    static {
        caseName = null;
    }

    public ConceptEditorTestFrame() {
        this.initTestFrame();
    }

    public static void main(String[] args) {
        ConceptEditorTestFrame testFrame = new ConceptEditorTestFrame();
        myInterface = M4Interface.getInstance();
        Collection allCaseNames = myInterface.getAllCaseNames();
        SelectUtility select = new SelectUtility();
        boolean found = false;
        while (!found) {
            caseName = (String)select.selectObject(testFrame, "CaseName", allCaseNames);
            if (caseName == null) {
                return;
            }
            Case aCase = null;
            try {
                aCase = myInterface.findCaseForUpdate(caseName, true);
                found = true;
            }
            catch (M4Interface.CaseLockedException e) {
                e.printStackTrace();
            }
        }
        String server = System.getProperty("COMPILER_SERVER");
        try {
            System.out.println("//" + server + "/" + LOOKUP_STRING);
            compilerAccess = (CompilerAccess)((Object)Naming.lookup("//localhost/aCompilerAccessImpl"));
            M4Interface.setCurrentCompilerAccess(compilerAccess);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ConceptEditor anEditor = testFrame.getConceptEditor();
        anEditor.setInterface(myInterface);
    }

    public ConceptEditor getConceptEditor() {
        return this.conceptEditor;
    }

    private void exit() {
        ConceptEditorTestFrame.releaseCase();
        System.exit(0);
    }

    public static void releaseCase() {
        myInterface.releaseCase(caseName);
    }

    private void initTestFrame() {
        ((Component)this).setSize(800, 600);
        this.setTitle("ConceptEditor Test Frame");
        this.desktop.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
        this.getContentPane().add(this.desktop);
        this.desktop.add(this.conceptEditor);
        this.testFrameFileMenu.setText("File");
        this.testFrameFileMenu.add(this.testFrameExitMenuItem);
        this.testFrameMenuBar.add(this.testFrameFileMenu);
        this.testFrameExitMenuItem.setText("Exit");
        this.testFrameExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConceptEditorTestFrame.this.exitActionPerformed(e);
            }
        });
        this.setJMenuBar(this.testFrameMenuBar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConceptEditorTestFrame.this.frameWindowClosing(e);
            }
        });
        this.show();
        this.conceptEditor.setVisible(true);
    }

    public void frameWindowClosing(WindowEvent e) {
        this.exit();
    }

    public void exitActionPerformed(ActionEvent e) {
        this.exit();
    }
}

