/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.jfc.diagram;

import com.syllogic.jfc.diagram.DiagramRelation;
import com.syllogic.jfc.diagram.PersistentStyleRelation;
import com.syllogic.jfc.diagram.RelationRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class DefaultRelationRenderer
extends JComponent
implements RelationRenderer {
    protected DiagramRelation itsRelation;
    protected Rectangle itsFromRectangle;
    protected Rectangle itsToRectangle;
    protected boolean itsIsSelected;
    private boolean itsWantCubicLine = false;
    private boolean itsWantArrow = true;

    public boolean isShowing() {
        return true;
    }

    public JComponent getComponent(DiagramRelation theRelation, Rectangle theFromRectangle, Rectangle theToRectangle, boolean isSelected) {
        this.itsRelation = theRelation;
        this.itsFromRectangle = theFromRectangle;
        this.itsToRectangle = theToRectangle;
        this.itsIsSelected = isSelected;
        return this;
    }

    public boolean wantCubicLine() {
        return this.itsWantCubicLine;
    }

    public boolean wantCubicLine(DiagramRelation theRelation) {
        PersistentStyleRelation aRel;
        Object o;
        if (theRelation instanceof PersistentStyleRelation && (o = (aRel = (PersistentStyleRelation)((Object)theRelation)).getStyleOption("Cubic")) != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return this.wantCubicLine();
    }

    public void setCubicLine(boolean yes) {
        this.itsWantCubicLine = yes;
    }

    public boolean wantArrow() {
        return this.itsWantArrow;
    }

    public boolean wantArrow(DiagramRelation theRelation) {
        PersistentStyleRelation aRel;
        Object o;
        if (theRelation instanceof PersistentStyleRelation && (o = (aRel = (PersistentStyleRelation)((Object)theRelation)).getStyleOption("ArrowHalfway")) != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return this.wantArrow();
    }

    public void setArrow(boolean yes) {
        this.itsWantArrow = yes;
    }

    public static Point intersect(Line2D theLine, double x10, double y10, double x11, double y11) {
        double y;
        double x;
        if (!theLine.intersectsLine(x10, y10, x11, y11)) {
            return null;
        }
        double x00 = theLine.getP1().getX();
        double y00 = theLine.getP1().getY();
        double x01 = theLine.getP2().getX();
        double y01 = theLine.getP2().getY();
        double a0 = (y01 - y00) / (x01 - x00);
        double b0 = y00 - a0 * x00;
        if (x10 == x11) {
            x = x10;
            y = a0 * x + b0;
        } else {
            double a1 = (y11 - y10) / (x11 - x10);
            double b1 = y10 - a1 * x10;
            x = (b1 - b0) / (a0 - a1);
            y = a0 * x + b0;
        }
        return new Point((int)x, (int)y);
    }

    public static Point insersect(Line2D theLine1, Line2D theLine2) {
        return DefaultRelationRenderer.intersect(theLine1, theLine2.getP1().getX(), theLine2.getP1().getY(), theLine2.getP2().getX(), theLine2.getP2().getY());
    }

    public static Point insersectRL(Rectangle theRect, Line2D theLine) {
        Point r = DefaultRelationRenderer.intersect(theLine, theRect.x, theRect.y, theRect.x + theRect.width, theRect.y);
        if (r == null) {
            r = DefaultRelationRenderer.intersect(theLine, theRect.x + theRect.width, theRect.y, theRect.x + theRect.width, theRect.y + theRect.height);
        }
        if (r == null) {
            r = DefaultRelationRenderer.intersect(theLine, theRect.x, theRect.y + theRect.height, theRect.x + theRect.width, theRect.y + theRect.height);
        }
        if (r == null) {
            r = DefaultRelationRenderer.intersect(theLine, theRect.x, theRect.y, theRect.x, theRect.y + theRect.height);
        }
        return r;
    }

    public static void addArrow(GeneralPath thePath, Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        double halfBase = 5.0;
        double height = 9.0;
        if (dx == 0.0) {
            double midy = (p1.getY() + p2.getY()) / 2.0;
            thePath.moveTo((float)p1.getX(), (float)midy);
            thePath.lineTo((float)(p1.getX() - 5.0), (float)(midy - 9.0));
            thePath.lineTo((float)(p1.getX() + 5.0), (float)(midy - 9.0));
            thePath.closePath();
        } else {
            double len = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
            double nx = dx / len;
            double ny = dy / len;
            double midLen = len / 2.0;
            double xt = p1.getX() + midLen * nx;
            double yt = p1.getY() + midLen * ny;
            double xb = p1.getX() + (midLen - 9.0) * nx;
            double yb = p1.getY() + (midLen - 9.0) * ny;
            double xb0 = xb - 5.0 * ny;
            double yb0 = yb + 5.0 * nx;
            double xb1 = xb + 5.0 * ny;
            double yb1 = yb - 5.0 * nx;
            thePath.moveTo((float)xt, (float)yt);
            thePath.lineTo((float)xb0, (float)yb0);
            thePath.lineTo((float)xb1, (float)yb1);
            thePath.closePath();
        }
    }

    public static void addArrow(GeneralPath thePath, CubicCurve2D theCurve) {
        CubicCurve2D.Double part1 = new CubicCurve2D.Double();
        CubicCurve2D.Double part2 = new CubicCurve2D.Double();
        theCurve.subdivide(part1, part2);
        DefaultRelationRenderer.addArrow(thePath, ((CubicCurve2D)part1).getCtrlP2(), ((CubicCurve2D)part2).getCtrlP1());
    }

    public static GeneralPath makeArrowedLine(Point2D p1, Point2D p2, boolean addArrow, boolean closeLine) {
        GeneralPath aPath = new GeneralPath(1);
        aPath.moveTo((float)p1.getX(), (float)p1.getY());
        aPath.lineTo((float)p2.getX(), (float)p2.getY());
        if (closeLine) {
            aPath.closePath();
        }
        if (addArrow) {
            DefaultRelationRenderer.addArrow(aPath, p1, p2);
        }
        return aPath;
    }

    public static GeneralPath makeArrowedLine(Point2D p1, Point2D p2, boolean addArrow) {
        return DefaultRelationRenderer.makeArrowedLine(p1, p2, addArrow, true);
    }

    public static GeneralPath makeArrowedLine(Point p1, Point p2) {
        return DefaultRelationRenderer.makeArrowedLine(p1, p2, true);
    }

    public Shape getShape(DiagramRelation theRelation, Rectangle theFromRectangle, Rectangle theToRectangle, boolean isSelected) {
        GeneralPath aPath;
        int midx0 = theFromRectangle.x + theFromRectangle.width / 2;
        int midy0 = theFromRectangle.y + theFromRectangle.height / 2;
        int midx1 = theToRectangle.x + theToRectangle.width / 2;
        int midy1 = theToRectangle.y + theToRectangle.height / 2;
        int x0 = midx0 > midx1 ? theFromRectangle.x : theFromRectangle.x + theFromRectangle.width;
        int y0 = theFromRectangle.y + theFromRectangle.height / 2;
        int x1 = midx0 > midx1 ? theToRectangle.x + theToRectangle.width : theToRectangle.x;
        int y1 = theToRectangle.y + theToRectangle.height / 2;
        if (this.wantCubicLine(theRelation)) {
            int xc0 = midx0 > midx1 ? theFromRectangle.x - 100 : theFromRectangle.x + theFromRectangle.width + 100;
            int xc1 = midx0 > midx1 ? theToRectangle.x + theToRectangle.width + 100 : theToRectangle.x - 100;
            aPath = new GeneralPath(1);
            aPath.moveTo(x0, y0);
            aPath.curveTo(xc0, y0, xc1, y1, x1, y1);
            aPath.curveTo(xc1, y1, xc0, y0, x0, y0);
            aPath.closePath();
            if (this.wantArrow(theRelation)) {
                DefaultRelationRenderer.addArrow(aPath, new CubicCurve2D.Double(x0, y0, xc0, y0, xc1, y1, x1, y1));
            }
        } else {
            Line2D.Double aLine = new Line2D.Double(midx0, midy0, midx1, midy1);
            Point p1 = DefaultRelationRenderer.insersectRL(theFromRectangle, aLine);
            Point p2 = DefaultRelationRenderer.insersectRL(theToRectangle, aLine);
            if (p1 == null) {
                p1 = new Point(0, 0);
            }
            if (p2 == null) {
                p2 = new Point(0, 0);
            }
            aPath = DefaultRelationRenderer.makeArrowedLine(p1, p2, this.wantArrow(theRelation));
        }
        return aPath;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Object aSetting = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.itsIsSelected ? Color.red : Color.blue);
        Shape aShape = this.getShape(this.itsRelation, this.itsFromRectangle, this.itsToRectangle, this.itsIsSelected);
        g2.draw(aShape);
        if (aShape instanceof GeneralPath) {
            g2.fill(aShape);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aSetting);
    }
}

