/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.jfc.diagram;

import com.syllogic.jfc.diagram.DefaultRelationRenderer;
import com.syllogic.jfc.diagram.DiagramRelation;
import com.syllogic.jfc.diagram.DraggebleRelation;
import com.syllogic.jfc.diagram.DraggebleRelationRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;

public class DefaultDraggebleRelationRenderer
extends DefaultRelationRenderer
implements DraggebleRelationRenderer {
    public Point[] getPoints(DraggebleRelation theRelation, Rectangle theFromRectangle, Rectangle theToRectangle) {
        Point[] r = new Point[]{new Point(), new Point(), new Point(), new Point()};
        Point p = theRelation.getEndPoint(0);
        if (p == null) {
            p = new Point(0, 0);
            theRelation.setEndPoint(0, p);
        }
        r[0].x = p.x + theFromRectangle.x + theFromRectangle.width / 2;
        r[0].y = p.y + theFromRectangle.y + theFromRectangle.height / 2;
        p = theRelation.getEndPoint(1);
        if (p == null) {
            p = new Point(0, 0);
            theRelation.setEndPoint(1, p);
        }
        r[1].x = p.x + theToRectangle.x + theToRectangle.width / 2;
        r[1].y = p.y + theToRectangle.y + theToRectangle.height / 2;
        if (this.wantCubicLine(theRelation)) {
            p = theRelation.getEndPoint(2);
            if (p == null) {
                p = new Point(r[0].x > r[1].x ? -25 : 25, 0);
                theRelation.setEndPoint(2, p);
            }
            r[2].x = r[0].x + p.x;
            r[2].y = r[0].y + p.y;
            p = theRelation.getEndPoint(3);
            if (p == null) {
                p = new Point(r[0].x > r[1].x ? 25 : -25, 0);
                theRelation.setEndPoint(3, p);
            }
            r[3].x = r[1].x + p.x;
            r[3].y = r[1].y + p.y;
        }
        return r;
    }

    private void fillPoints(DraggebleRelation theRel, Rectangle theFromRectangle, Rectangle theToRectangle, Point p1, Point c1, Point c2, Point p2) {
        Point[] aList = this.getPoints(theRel, theFromRectangle, theToRectangle);
        p1.setLocation(aList[0]);
        p2.setLocation(aList[1]);
        c1.setLocation(aList[2]);
        c2.setLocation(aList[3]);
    }

    public Shape getShape(DiagramRelation theRelation, Rectangle theFromRectangle, Rectangle theToRectangle, boolean isSelected, Point[] thePoints) {
        GeneralPath aPath;
        DraggebleRelation aRel = (DraggebleRelation)theRelation;
        if (this.wantCubicLine(aRel)) {
            aPath = new GeneralPath(1);
            aPath.moveTo(thePoints[0].x, thePoints[0].y);
            aPath.curveTo(thePoints[2].x, thePoints[2].y, thePoints[3].x, thePoints[3].y, thePoints[1].x, thePoints[1].y);
            aPath.curveTo(thePoints[3].x, thePoints[3].y, thePoints[2].x, thePoints[2].y, thePoints[0].x, thePoints[0].y);
            aPath.closePath();
            if (this.wantArrow(aRel)) {
                DefaultRelationRenderer.addArrow(aPath, new CubicCurve2D.Double(thePoints[0].x, thePoints[0].y, thePoints[2].x, thePoints[2].y, thePoints[3].x, thePoints[3].y, thePoints[1].x, thePoints[1].y));
            }
        } else {
            aPath = DefaultRelationRenderer.makeArrowedLine(thePoints[0], thePoints[1], this.wantArrow(aRel));
        }
        return aPath;
    }

    public Shape getShape(DiagramRelation theRelation, Rectangle theFromRectangle, Rectangle theToRectangle, boolean isSelected) {
        if (theRelation instanceof DraggebleRelation) {
            return this.getShape((DraggebleRelation)theRelation, theFromRectangle, theToRectangle, isSelected, this.getPoints((DraggebleRelation)theRelation, theFromRectangle, theToRectangle));
        }
        return super.getShape(theRelation, theFromRectangle, theToRectangle, isSelected);
    }

    public Shape getDragShape(DiagramRelation theRelation, Rectangle theFromRectangle, Rectangle theToRectangle, Point[] thePoints) {
        GeneralPath aPath;
        DraggebleRelation aRel = (DraggebleRelation)theRelation;
        if (this.wantCubicLine(aRel)) {
            aPath = new GeneralPath(1);
            aPath.moveTo(thePoints[0].x, thePoints[0].y);
            aPath.curveTo(thePoints[2].x, thePoints[2].y, thePoints[3].x, thePoints[3].y, thePoints[1].x, thePoints[1].y);
            if (this.wantArrow(aRel)) {
                DefaultRelationRenderer.addArrow(aPath, new CubicCurve2D.Double(thePoints[0].x, thePoints[0].y, thePoints[2].x, thePoints[2].y, thePoints[3].x, thePoints[3].y, thePoints[1].x, thePoints[1].y));
            }
        } else {
            aPath = DefaultRelationRenderer.makeArrowedLine(thePoints[0], thePoints[1], this.wantArrow(aRel), false);
        }
        return aPath;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!(this.itsRelation instanceof DraggebleRelation) || !this.itsIsSelected) {
            return;
        }
        DraggebleRelation aRel = (DraggebleRelation)this.itsRelation;
        Point p1 = new Point();
        Point c1 = new Point();
        Point c2 = new Point();
        Point p2 = new Point();
        this.fillPoints(aRel, this.itsFromRectangle, this.itsToRectangle, p1, c1, c2, p2);
        g.setColor(Color.yellow);
        g.fillRect(p1.x - 2, p1.y - 2, 5, 5);
        g.fillRect(p2.x - 2, p2.y - 2, 5, 5);
        if (this.wantCubicLine(this.itsRelation)) {
            g.fillRect(c1.x - 2, c1.y - 2, 5, 5);
            g.fillRect(c2.x - 2, c2.y - 2, 5, 5);
        }
    }
}

