/*
 * Decompiled with CFR 0.152.
 */
package cocon;

import cocon.CoConnection;
import cocon.CoConnectionChangeEvent;
import cocon.CoModel;
import cocon.CoObjectProperties;
import cocon.CoView;
import cocon.CoViewConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CoObjectPropertiesView
extends CoView
implements ActionListener {
    CoObjectProperties initModel = new CoObjectProperties();
    public JTextField name;
    public JTextArea description;
    public JTextField url;
    JButton buttonSave;
    JButton buttonClose;

    public CoObjectPropertiesView() {
        this.initCoObjectPropertiesView();
    }

    public int initCoObjectPropertiesView() {
        this.initModel.setName("");
        this.initModel.setDescription("");
        this.initModel.setUrl("");
        this.initControls();
        this.updateView();
        return 0;
    }

    public void initControls() {
        this.getViewPanel().removeAll();
        this.getViewPanel().setOpaque(true);
        this.getViewPanel().setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel label = new JLabel("Name: ", 4);
        this.name = new JTextField("", 30);
        label.setDisplayedMnemonic(78);
        label.setLabelFor(this.name);
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.name, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        label = new JLabel("Description: ", 4);
        this.description = new JTextArea(5, 0);
        this.description.setText("");
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.description);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.getViewport().setMinimumSize(new Dimension(5, 50));
        scrollPane.getViewport().setPreferredSize(new Dimension(300, 100));
        label.setDisplayedMnemonic(68);
        label.setLabelFor(this.description);
        panel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        label = new JLabel("URL: ", 4);
        this.url = new JTextField("", 30);
        label.setDisplayedMnemonic(85);
        label.setLabelFor(this.url);
        panel.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.url, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        box.add(panel);
        panel = new JPanel(new GridLayout(1, 2));
        panel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.buttonSave = new JButton("Save");
        this.buttonSave.setMnemonic(83);
        this.buttonSave.addActionListener(this);
        panel.add(this.buttonSave);
        this.buttonClose = new JButton("Close");
        this.buttonClose.setMnemonic(67);
        this.buttonClose.addActionListener(this);
        panel.add(this.buttonClose);
        box.add(panel);
        this.getViewPanel().add((Component)box, "Center");
    }

    public void updateView() {
        CoModel model = this.getModel();
        if (model != null) {
            this.name.setEditable(true);
            this.description.setEditable(true);
            this.url.setEditable(true);
            this.buttonSave.setEnabled(true);
        } else {
            this.name.setEditable(false);
            this.description.setEditable(false);
            this.url.setEditable(false);
            this.buttonSave.setEnabled(false);
        }
        if (model != null) {
            if (this.initModel.getName().equals(this.name.getText())) {
                this.initModel.setName(model.getName() == null ? "" : model.getName());
                this.name.setText(model.getName() == null ? "" : model.getName());
            }
            if (this.initModel.getDescription().equals(this.description.getText())) {
                this.initModel.setDescription(model.getDescription() == null ? "" : model.getDescription());
                this.description.setText(model.getDescription() == null ? "" : model.getDescription());
            }
            if (this.initModel.getUrl().equals(this.url.getText())) {
                this.initModel.setUrl(model.getUrl() == null ? "" : model.getUrl());
                this.url.setText(model.getUrl() == null ? "" : model.getUrl());
            }
        } else {
            this.initModel.setName("");
            this.name.setText("");
            this.initModel.setDescription("");
            this.description.setText("");
            this.initModel.setUrl("");
            this.url.setText("");
        }
    }

    public void updateModel() {
        CoModel model = this.getModel();
        if (model == null) {
            return;
        }
        if (!this.initModel.getName().equals(this.name.getText())) {
            this.initModel.setName(this.name.getText());
            model.setName(this.name.getText());
        }
        if (!this.initModel.getDescription().equals(this.description.getText())) {
            this.initModel.setDescription(this.description.getText());
            model.setDescription(this.description.getText());
        }
        if (!this.initModel.getUrl().equals(this.url.getText())) {
            this.initModel.setUrl(this.url.getText());
            model.setUrl(this.url.getText());
        }
    }

    public boolean isScrollable() {
        return false;
    }

    public String getWindowMenuName() {
        CoModel model = this.getModel();
        return model != null ? model.getName() : null;
    }

    public String getWindowTitle() {
        CoModel model = this.getModel();
        return model != null ? model.getName() : null;
    }

    public void actionPerformed(ActionEvent e) {
        CoModel model = this.getModel();
        JButton source = (JButton)e.getSource();
        if (source == this.buttonSave) {
            if (model != null) {
                this.updateModel();
            }
        } else if (source == this.buttonClose) {
            this.firePropertyChange("viewClosing", null, null);
            this.fireAutoPropertyChange("viewClosing", null, null);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        CoModel model = this.getModel();
        String propertyName = evt.getPropertyName();
        if (model != null && (propertyName == "name" || propertyName == "description" || propertyName == "url") && evt.getSource() == model) {
            this.updateView();
        }
    }

    public void addedInConnection(CoConnectionChangeEvent cce) {
        super.addedInConnection(cce);
    }

    public void addedOutConnection(CoConnectionChangeEvent cce) {
        super.addedOutConnection(cce);
    }

    public void addedConnection(CoConnectionChangeEvent cce) {
        super.addedConnection(cce);
        CoConnection connection = cce.getConnection();
        if (connection instanceof CoViewConnection && cce.getSource() == this) {
            this.updateView();
        }
    }

    public void removedInConnection(CoConnectionChangeEvent cce) {
        super.removedInConnection(cce);
    }

    public void removedOutConnection(CoConnectionChangeEvent cce) {
        super.removedOutConnection(cce);
    }

    public void removedConnection(CoConnectionChangeEvent cce) {
        super.removedConnection(cce);
        CoConnection connection = cce.getConnection();
        if (connection instanceof CoViewConnection && cce.getSource() == this) {
            this.updateView();
        }
    }
}

